/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.runners.inprocess.Clock;
import com.google.cloud.dataflow.sdk.runners.inprocess.InMemoryWatermarkManager;
import com.google.cloud.dataflow.sdk.util.TimerInternals;
import javax.annotation.Nullable;
import org.joda.time.Instant;

class InProcessTimerInternals
implements TimerInternals {
    private final Clock processingTimeClock;
    private final InMemoryWatermarkManager.TransformWatermarks watermarks;
    private final InMemoryWatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder;

    public static InProcessTimerInternals create(Clock clock, InMemoryWatermarkManager.TransformWatermarks watermarks, InMemoryWatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        return new InProcessTimerInternals(clock, watermarks, timerUpdateBuilder);
    }

    private InProcessTimerInternals(Clock clock, InMemoryWatermarkManager.TransformWatermarks watermarks, InMemoryWatermarkManager.TimerUpdate.TimerUpdateBuilder timerUpdateBuilder) {
        this.processingTimeClock = clock;
        this.watermarks = watermarks;
        this.timerUpdateBuilder = timerUpdateBuilder;
    }

    @Override
    public void setTimer(TimerInternals.TimerData timerKey) {
        this.timerUpdateBuilder.setTimer(timerKey);
    }

    @Override
    public void deleteTimer(TimerInternals.TimerData timerKey) {
        this.timerUpdateBuilder.deletedTimer(timerKey);
    }

    public InMemoryWatermarkManager.TimerUpdate getTimerUpdate() {
        return this.timerUpdateBuilder.build();
    }

    @Override
    public Instant currentProcessingTime() {
        return this.processingTimeClock.now();
    }

    @Override
    @Nullable
    public Instant currentSynchronizedProcessingTime() {
        return this.watermarks.getSynchronizedProcessingInputTime();
    }

    @Override
    public Instant currentInputWatermarkTime() {
        return this.watermarks.getInputWatermark();
    }

    @Override
    @Nullable
    public Instant currentOutputWatermarkTime() {
        return this.watermarks.getOutputWatermark();
    }
}

