/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.cloud.dataflow.sdk.options.ApplicationNameOptions;
import com.google.cloud.dataflow.sdk.options.Default;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.Hidden;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.runners.inprocess.Clock;
import com.google.cloud.dataflow.sdk.runners.inprocess.ExecutorServiceFactory;

public interface InProcessPipelineOptions
extends PipelineOptions,
ApplicationNameOptions {
    @Deprecated
    @JsonIgnore
    @Hidden
    public ExecutorServiceFactory getExecutorServiceFactory();

    public void setExecutorServiceFactory(ExecutorServiceFactory var1);

    @Deprecated
    @JsonIgnore
    @Hidden
    @Description(value="The processing time source used by the pipeline. When the current time is needed by the evaluator, the result of clock#now() is used.")
    public Clock getClock();

    public void setClock(Clock var1);

    @Default.Boolean(value=false)
    @Description(value="If the pipeline should shut down producers which have reached the maximum representable watermark. If this is set to true, a pipeline in which all PTransforms have reached the maximum watermark will be shut down, even if there are unbounded sources that could produce additional (late) data. By default, if the pipeline contains any unbounded PCollections, it will run until explicitly shut down.")
    public boolean isShutdownUnboundedProducersWithMaxWatermark();

    public void setShutdownUnboundedProducersWithMaxWatermark(boolean var1);

    @Default.Boolean(value=true)
    @Description(value="If the pipeline should block awaiting completion of the pipeline. If set to true, a call to Pipeline#run() will block until all PTransforms are complete. Otherwise, the Pipeline will execute asynchronously. If set to false, the completion of the pipeline can be awaited on by use of InProcessPipelineResult#awaitCompletion().")
    public boolean isBlockOnRun();

    public void setBlockOnRun(boolean var1);

    @Default.Boolean(value=true)
    @Description(value="Controls whether the runner should ensure that all of the elements of every PCollection are not mutated. PTransforms are not permitted to mutate input elements at any point, or output elements after they are output.")
    public boolean isTestImmutability();

    public void setTestImmutability(boolean var1);
}

