/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.dataflow.sdk.runners.inprocess.BundleFactory;
import com.google.cloud.dataflow.sdk.runners.inprocess.Clock;
import com.google.cloud.dataflow.sdk.runners.inprocess.CommittedResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.InMemoryWatermarkManager;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessExecutionContext;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineOptions;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessSideInputContainer;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessTransformResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.StepAndKey;
import com.google.cloud.dataflow.sdk.runners.inprocess.StructuralKey;
import com.google.cloud.dataflow.sdk.runners.inprocess.WatermarkCallbackExecutor;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.ReadyCheckingSideInputReader;
import com.google.cloud.dataflow.sdk.util.TimerInternals;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import com.google.cloud.dataflow.sdk.util.state.CopyOnAccessInMemoryStateInternals;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

class InProcessEvaluationContext {
    private final Map<AppliedPTransform<?, ?, ?>, String> stepNames;
    private final InProcessPipelineOptions options;
    private final Clock clock;
    private final BundleFactory bundleFactory;
    private final InMemoryWatermarkManager watermarkManager;
    private final WatermarkCallbackExecutor callbackExecutor;
    private final ConcurrentMap<StepAndKey, CopyOnAccessInMemoryStateInternals<?>> applicationStateInternals;
    private final InProcessSideInputContainer sideInputContainer;
    private final CounterSet mergedCounters;

    public static InProcessEvaluationContext create(InProcessPipelineOptions options, Clock clock, BundleFactory bundleFactory, Collection<AppliedPTransform<?, ?, ?>> rootTransforms, Map<PValue, Collection<AppliedPTransform<?, ?, ?>>> valueToConsumers, Map<AppliedPTransform<?, ?, ?>, String> stepNames, Collection<PCollectionView<?>> views) {
        return new InProcessEvaluationContext(options, clock, bundleFactory, rootTransforms, valueToConsumers, stepNames, views);
    }

    private InProcessEvaluationContext(InProcessPipelineOptions options, Clock clock, BundleFactory bundleFactory, Collection<AppliedPTransform<?, ?, ?>> rootTransforms, Map<PValue, Collection<AppliedPTransform<?, ?, ?>>> valueToConsumers, Map<AppliedPTransform<?, ?, ?>, String> stepNames, Collection<PCollectionView<?>> views) {
        this.options = Preconditions.checkNotNull(options);
        this.clock = clock;
        this.bundleFactory = Preconditions.checkNotNull(bundleFactory);
        Preconditions.checkNotNull(rootTransforms);
        Preconditions.checkNotNull(valueToConsumers);
        Preconditions.checkNotNull(stepNames);
        Preconditions.checkNotNull(views);
        this.stepNames = stepNames;
        this.watermarkManager = InMemoryWatermarkManager.create(clock, rootTransforms, valueToConsumers);
        this.sideInputContainer = InProcessSideInputContainer.create(this, views);
        this.applicationStateInternals = new ConcurrentHashMap();
        this.mergedCounters = new CounterSet(new Counter[0]);
        this.callbackExecutor = WatermarkCallbackExecutor.create(MoreExecutors.directExecutor());
    }

    public CommittedResult handleResult(@Nullable InProcessPipelineRunner.CommittedBundle<?> completedBundle, Iterable<TimerInternals.TimerData> completedTimers, InProcessTransformResult result) {
        CopyOnAccessInMemoryStateInternals<?> theirState;
        Iterable<? extends InProcessPipelineRunner.CommittedBundle<?>> committedBundles = this.commitBundles(result.getOutputBundles());
        EnumSet<CommittedResult.OutputType> outputTypes = EnumSet.copyOf(result.getOutputTypes());
        if (Iterables.isEmpty(committedBundles)) {
            outputTypes.remove((Object)CommittedResult.OutputType.BUNDLE);
        } else {
            outputTypes.add(CommittedResult.OutputType.BUNDLE);
        }
        CommittedResult committedResult = CommittedResult.create(result, completedBundle == null ? null : completedBundle.withElements(result.getUnprocessedElements()), committedBundles, outputTypes);
        this.watermarkManager.updateWatermarks(completedBundle, result.getTimerUpdate().withCompletedTimers(completedTimers), committedResult, result.getWatermarkHold());
        if (result.getCounters() != null) {
            this.mergedCounters.merge(result.getCounters());
        }
        if ((theirState = result.getState()) != null) {
            CopyOnAccessInMemoryStateInternals<?> committedState = theirState.commit();
            StepAndKey stepAndKey = StepAndKey.of(result.getTransform(), completedBundle == null ? null : completedBundle.getKey());
            if (!committedState.isEmpty()) {
                this.applicationStateInternals.put(stepAndKey, committedState);
            } else {
                this.applicationStateInternals.remove(stepAndKey);
            }
        }
        return committedResult;
    }

    private Iterable<? extends InProcessPipelineRunner.CommittedBundle<?>> commitBundles(Iterable<? extends InProcessPipelineRunner.UncommittedBundle<?>> bundles) {
        ImmutableList.Builder completed = ImmutableList.builder();
        for (InProcessPipelineRunner.UncommittedBundle<?> inProgress : bundles) {
            AppliedPTransform<?, ?, ?> producing;
            InMemoryWatermarkManager.TransformWatermarks watermarks;
            InProcessPipelineRunner.CommittedBundle<?> committed = inProgress.commit((watermarks = this.watermarkManager.getWatermarks(producing = inProgress.getPCollection().getProducingTransformInternal())).getSynchronizedProcessingOutputTime());
            if (Iterables.isEmpty(committed.getElements())) continue;
            completed.add(committed);
        }
        return completed.build();
    }

    private void fireAllAvailableCallbacks() {
        for (AppliedPTransform<?, ?, ?> transform : this.stepNames.keySet()) {
            this.fireAvailableCallbacks(transform);
        }
    }

    private void fireAvailableCallbacks(AppliedPTransform<?, ?, ?> producingTransform) {
        InMemoryWatermarkManager.TransformWatermarks watermarks = this.watermarkManager.getWatermarks(producingTransform);
        this.callbackExecutor.fireForWatermark(producingTransform, watermarks.getOutputWatermark());
    }

    public <T> InProcessPipelineRunner.UncommittedBundle<T> createRootBundle(PCollection<T> output) {
        return this.bundleFactory.createRootBundle(output);
    }

    public <T> InProcessPipelineRunner.UncommittedBundle<T> createBundle(InProcessPipelineRunner.CommittedBundle<?> input, PCollection<T> output) {
        return this.bundleFactory.createBundle(input, output);
    }

    public <K, T> InProcessPipelineRunner.UncommittedBundle<T> createKeyedBundle(InProcessPipelineRunner.CommittedBundle<?> input, StructuralKey<K> key, PCollection<T> output) {
        return this.bundleFactory.createKeyedBundle(input, key, output);
    }

    public <ElemT, ViewT> InProcessPipelineRunner.PCollectionViewWriter<ElemT, ViewT> createPCollectionViewWriter(PCollection<Iterable<ElemT>> input, final PCollectionView<ViewT> output) {
        return new InProcessPipelineRunner.PCollectionViewWriter<ElemT, ViewT>(){

            @Override
            public void add(Iterable<WindowedValue<ElemT>> values) {
                InProcessEvaluationContext.this.sideInputContainer.write(output, values);
            }
        };
    }

    public void scheduleAfterOutputWouldBeProduced(PValue value, BoundedWindow window, WindowingStrategy<?, ?> windowingStrategy, Runnable runnable) {
        AppliedPTransform<?, ?, ?> producing = this.getProducing(value);
        this.callbackExecutor.callOnGuaranteedFiring(producing, window, windowingStrategy, runnable);
        this.fireAvailableCallbacks(this.lookupProducing(value));
    }

    private AppliedPTransform<?, ?, ?> getProducing(PValue value) {
        if (value.getProducingTransformInternal() != null) {
            return value.getProducingTransformInternal();
        }
        return this.lookupProducing(value);
    }

    private AppliedPTransform<?, ?, ?> lookupProducing(PValue value) {
        for (AppliedPTransform<?, ?, ?> transform : this.stepNames.keySet()) {
            if (!transform.getOutput().equals(value) && !transform.getOutput().expand().contains(value)) continue;
            return transform;
        }
        return null;
    }

    public InProcessPipelineOptions getPipelineOptions() {
        return this.options;
    }

    public InProcessExecutionContext getExecutionContext(AppliedPTransform<?, ?, ?> application, StructuralKey<?> key) {
        StepAndKey stepAndKey = StepAndKey.of(application, key);
        return new InProcessExecutionContext(this.clock, key, (CopyOnAccessInMemoryStateInternals)this.applicationStateInternals.get(stepAndKey), this.watermarkManager.getWatermarks(application));
    }

    public Collection<AppliedPTransform<?, ?, ?>> getSteps() {
        return this.stepNames.keySet();
    }

    public String getStepName(AppliedPTransform<?, ?, ?> application) {
        return this.stepNames.get(application);
    }

    public ReadyCheckingSideInputReader createSideInputReader(List<PCollectionView<?>> sideInputs) {
        return this.sideInputContainer.createReaderForViews(sideInputs);
    }

    public CounterSet createCounterSet() {
        return new CounterSet(new Counter[0]);
    }

    public CounterSet getCounters() {
        return this.mergedCounters;
    }

    @VisibleForTesting
    void forceRefresh() {
        this.watermarkManager.refreshAll();
        this.fireAllAvailableCallbacks();
    }

    public Map<AppliedPTransform<?, ?, ?>, Map<StructuralKey<?>, InMemoryWatermarkManager.FiredTimers>> extractFiredTimers() {
        this.forceRefresh();
        Map<AppliedPTransform<?, ?, ?>, Map<StructuralKey<?>, InMemoryWatermarkManager.FiredTimers>> fired = this.watermarkManager.extractFiredTimers();
        return fired;
    }

    public boolean isDone(AppliedPTransform<?, ?, ?> transform) {
        if (this.watermarkManager.getWatermarks(transform).getOutputWatermark().isBefore((ReadableInstant)BoundedWindow.TIMESTAMP_MAX_VALUE)) {
            return false;
        }
        for (PValue pValue : transform.getOutput().expand()) {
            PCollection.IsBounded bounded;
            if (!(pValue instanceof PCollection) || !(bounded = ((PCollection)pValue).isBounded()).equals((Object)PCollection.IsBounded.UNBOUNDED) || this.options.isShutdownUnboundedProducersWithMaxWatermark()) continue;
            return false;
        }
        return true;
    }

    public boolean isDone() {
        for (AppliedPTransform<?, ?, ?> transform : this.stepNames.keySet()) {
            if (this.isDone(transform)) continue;
            return false;
        }
        return true;
    }

    public Instant now() {
        return this.clock.now();
    }

    Clock getClock() {
        return this.clock;
    }
}

