/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.inprocess;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.runners.inprocess.AbstractModelEnforcement;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.inprocess.InProcessTransformResult;
import com.google.cloud.dataflow.sdk.runners.inprocess.ModelEnforcement;
import com.google.cloud.dataflow.sdk.runners.inprocess.ModelEnforcementFactory;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.util.IllegalMutationException;
import com.google.cloud.dataflow.sdk.util.MutationDetector;
import com.google.cloud.dataflow.sdk.util.MutationDetectors;
import com.google.cloud.dataflow.sdk.util.UserCodeException;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import java.util.IdentityHashMap;
import java.util.Map;

class ImmutabilityEnforcementFactory
implements ModelEnforcementFactory {
    ImmutabilityEnforcementFactory() {
    }

    public static ModelEnforcementFactory create() {
        return new ImmutabilityEnforcementFactory();
    }

    @Override
    public <T> ModelEnforcement<T> forBundle(InProcessPipelineRunner.CommittedBundle<T> input, AppliedPTransform<?, ?, ?> consumer) {
        return new ImmutabilityCheckingEnforcement(input, consumer);
    }

    private static class ImmutabilityCheckingEnforcement<T>
    extends AbstractModelEnforcement<T> {
        private final AppliedPTransform<?, ?, ?> transform;
        private final Map<WindowedValue<T>, MutationDetector> mutationElements;
        private final Coder<T> coder;

        private ImmutabilityCheckingEnforcement(InProcessPipelineRunner.CommittedBundle<T> input, AppliedPTransform<?, ?, ?> transform) {
            this.transform = transform;
            this.coder = input.getPCollection().getCoder();
            this.mutationElements = new IdentityHashMap<WindowedValue<T>, MutationDetector>();
        }

        @Override
        public void beforeElement(WindowedValue<T> element) {
            try {
                this.mutationElements.put(element, MutationDetectors.forValueWithCoder(element.getValue(), this.coder));
            }
            catch (CoderException e) {
                throw UserCodeException.wrap(e);
            }
        }

        @Override
        public void afterElement(WindowedValue<T> element) {
            this.verifyUnmodified(this.mutationElements.get(element));
        }

        @Override
        public void afterFinish(InProcessPipelineRunner.CommittedBundle<T> input, InProcessTransformResult result, Iterable<? extends InProcessPipelineRunner.CommittedBundle<?>> outputs) {
            for (MutationDetector detector : this.mutationElements.values()) {
                this.verifyUnmodified(detector);
            }
        }

        private void verifyUnmodified(MutationDetector detector) {
            try {
                detector.verifyUnmodified();
            }
            catch (IllegalMutationException e) {
                throw new IllegalMutationException(String.format("PTransform %s illegaly mutated value %s of class %s. Input values must not be mutated in any way.", this.transform.getFullName(), e.getSavedValue(), e.getSavedValue().getClass()), e.getSavedValue(), e.getNewValue());
            }
        }
    }
}

