/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.dataflow;

import com.google.api.services.dataflow.model.MetricStructuredName;
import com.google.api.services.dataflow.model.MetricUpdate;
import com.google.cloud.dataflow.sdk.runners.dataflow.DataflowAggregatorTransforms;
import com.google.cloud.dataflow.sdk.transforms.Aggregator;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataflowMetricUpdateExtractor {
    private static final String STEP_NAME_CONTEXT_KEY = "step";
    private static final String IS_TENTATIVE_KEY = "tentative";

    private DataflowMetricUpdateExtractor() {
    }

    public static <OutputT> Map<String, OutputT> fromMetricUpdates(Aggregator<?, OutputT> aggregator, DataflowAggregatorTransforms aggregatorTransforms, List<MetricUpdate> metricUpdates) {
        HashMap<String, OutputT> results = new HashMap<String, OutputT>();
        if (metricUpdates == null) {
            return results;
        }
        String aggregatorName = aggregator.getName();
        Collection<String> aggregatorSteps = aggregatorTransforms.getAggregatorStepNames(aggregator);
        for (MetricUpdate metricUpdate : metricUpdates) {
            MetricStructuredName metricStructuredName = metricUpdate.getName();
            Map context = metricStructuredName.getContext();
            if (!metricStructuredName.getName().equals(aggregatorName) || context == null || !aggregatorSteps.contains(context.get(STEP_NAME_CONTEXT_KEY))) continue;
            AppliedPTransform<?, ?, ?> transform = aggregatorTransforms.getAppliedTransformForStepName((String)context.get(STEP_NAME_CONTEXT_KEY));
            String fullName = transform.getFullName();
            if (!Boolean.parseBoolean((String)context.get(IS_TENTATIVE_KEY)) && results.containsKey(fullName)) continue;
            results.put(fullName, DataflowMetricUpdateExtractor.toValue(aggregator, metricUpdate));
        }
        return results;
    }

    private static <OutputT> OutputT toValue(Aggregator<?, OutputT> aggregator, MetricUpdate metricUpdate) {
        Combine.CombineFn<?, ?, OutputT> combineFn = aggregator.getCombineFn();
        Class<OutputT> outputType = combineFn.getOutputType().getRawType();
        if (outputType.equals(Long.class)) {
            Long asLong = DataflowMetricUpdateExtractor.toNumber(metricUpdate).longValue();
            return (OutputT)asLong;
        }
        if (outputType.equals(Integer.class)) {
            Integer asInt = DataflowMetricUpdateExtractor.toNumber(metricUpdate).intValue();
            return (OutputT)asInt;
        }
        if (outputType.equals(Double.class)) {
            Double asDouble = DataflowMetricUpdateExtractor.toNumber(metricUpdate).doubleValue();
            return (OutputT)asDouble;
        }
        throw new UnsupportedOperationException("Unsupported Output Type " + outputType + " in aggregator " + aggregator);
    }

    private static Number toNumber(MetricUpdate update) {
        if (update.getScalar() instanceof Number) {
            return (Number)update.getScalar();
        }
        throw new IllegalArgumentException("Metric Update " + update + " does not have a numeric scalar");
    }
}

