/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners.dataflow;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.windowing.Window;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.PCollection;

public class AssignWindows<T>
extends PTransform<PCollection<T>, PCollection<T>> {
    private final Window.Bound<T> transform;

    public AssignWindows(Window.Bound<T> transform) {
        this.transform = transform;
    }

    @Override
    public PCollection<T> apply(PCollection<T> input) {
        WindowingStrategy<?, ?> outputStrategy = this.transform.getOutputStrategyInternal(input.getWindowingStrategy());
        if (this.transform.getWindowFn() != null) {
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), outputStrategy, input.isBounded());
        }
        return ((PCollection)input.apply(ParDo.named("Identity").of(new DoFn<T, T>(){

            @Override
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output(c.element());
            }
        }))).setWindowingStrategyInternal(outputStrategy);
    }

    @Override
    public void validate(PCollection<T> input) {
        this.transform.validate(input);
    }

    @Override
    protected Coder<?> getDefaultOutputCoder(PCollection<T> input) {
        return input.getCoder();
    }

    @Override
    protected String getKindString() {
        return "Window.Into()";
    }
}

