/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class TransformTreeNode {
    private final TransformTreeNode enclosingNode;
    private final PTransform<?, ?> transform;
    private final String fullName;
    private final Collection<TransformTreeNode> parts = new ArrayList<TransformTreeNode>();
    private final Map<PValue, TransformTreeNode> inputs = new HashMap<PValue, TransformTreeNode>();
    private final PInput input;
    private POutput output;
    private boolean finishedSpecifying = false;

    public TransformTreeNode(@Nullable TransformTreeNode enclosingNode, @Nullable PTransform<?, ?> transform, String fullName, @Nullable PInput input) {
        this.enclosingNode = enclosingNode;
        this.transform = transform;
        Preconditions.checkArgument(enclosingNode == null && transform == null || enclosingNode != null && transform != null, "EnclosingNode and transform must both be specified, or both be null");
        this.fullName = fullName;
        this.input = input;
    }

    public PTransform<?, ?> getTransform() {
        return this.transform;
    }

    public TransformTreeNode getEnclosingNode() {
        return this.enclosingNode;
    }

    public void addComposite(TransformTreeNode node) {
        this.parts.add(node);
    }

    public boolean isCompositeNode() {
        return !this.parts.isEmpty() || this.returnsOthersOutput() || this.isRootNode();
    }

    private boolean returnsOthersOutput() {
        PTransform<?, ?> transform = this.getTransform();
        for (PValue pValue : this.getExpandedOutputs()) {
            if (pValue.getProducingTransformInternal().getTransform().equals(transform)) continue;
            return true;
        }
        return false;
    }

    public boolean isRootNode() {
        return this.transform == null;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void addInputProducer(PValue expandedInput, TransformTreeNode producer) {
        Preconditions.checkState(!this.finishedSpecifying);
        this.inputs.put(expandedInput, producer);
    }

    public PInput getInput() {
        return this.input;
    }

    public Map<PValue, TransformTreeNode> getInputs() {
        return Collections.unmodifiableMap(this.inputs);
    }

    public void setOutput(POutput output) {
        Preconditions.checkState(!this.finishedSpecifying);
        Preconditions.checkState(this.output == null);
        this.output = output;
    }

    public POutput getOutput() {
        return this.output;
    }

    public Collection<? extends PValue> getExpandedOutputs() {
        if (this.output != null) {
            return this.output.expand();
        }
        return Collections.emptyList();
    }

    public void visit(Pipeline.PipelineVisitor visitor, Set<PValue> visitedValues) {
        if (!this.finishedSpecifying) {
            this.finishSpecifying();
        }
        for (Map.Entry<PValue, TransformTreeNode> entry : this.inputs.entrySet()) {
            if (!visitedValues.add(entry.getKey())) continue;
            visitor.visitValue(entry.getKey(), entry.getValue());
        }
        if (this.isCompositeNode()) {
            visitor.enterCompositeTransform(this);
            for (TransformTreeNode transformTreeNode : this.parts) {
                transformTreeNode.visit(visitor, visitedValues);
            }
            visitor.leaveCompositeTransform(this);
        } else {
            visitor.visitTransform(this);
        }
        for (PValue pValue : this.getExpandedOutputs()) {
            if (!visitedValues.add(pValue)) continue;
            visitor.visitValue(pValue, this);
        }
    }

    public void finishSpecifying() {
        if (this.finishedSpecifying) {
            return;
        }
        this.finishedSpecifying = true;
        for (TransformTreeNode input : this.inputs.values()) {
            if (input == null) continue;
            input.finishSpecifying();
        }
        if (this.output != null) {
            this.output.finishSpecifyingOutput();
        }
    }
}

