/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.runners;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.services.dataflow.model.AutoscalingSettings;
import com.google.api.services.dataflow.model.DataflowPackage;
import com.google.api.services.dataflow.model.Disk;
import com.google.api.services.dataflow.model.Environment;
import com.google.api.services.dataflow.model.Job;
import com.google.api.services.dataflow.model.Step;
import com.google.api.services.dataflow.model.WorkerPool;
import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.IterableCoder;
import com.google.cloud.dataflow.sdk.io.Read;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.options.StreamingOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Strings;
import com.google.cloud.dataflow.sdk.runners.DataflowPipelineRunner;
import com.google.cloud.dataflow.sdk.runners.TransformTreeNode;
import com.google.cloud.dataflow.sdk.runners.dataflow.ReadTranslator;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.Combine;
import com.google.cloud.dataflow.sdk.transforms.Create;
import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.Flatten;
import com.google.cloud.dataflow.sdk.transforms.GroupByKey;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.View;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.transforms.display.HasDisplayData;
import com.google.cloud.dataflow.sdk.transforms.windowing.DefaultTrigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.Window;
import com.google.cloud.dataflow.sdk.util.AppliedCombineFn;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.CoderUtils;
import com.google.cloud.dataflow.sdk.util.DoFnInfo;
import com.google.cloud.dataflow.sdk.util.OutputReference;
import com.google.cloud.dataflow.sdk.util.SerializableUtils;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PCollectionList;
import com.google.cloud.dataflow.sdk.values.PCollectionTuple;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.PValue;
import com.google.cloud.dataflow.sdk.values.TupleTag;
import com.google.cloud.dataflow.sdk.values.TypedPValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataflowPipelineTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(DataflowPipelineTranslator.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static Map<Class, TransformTranslator> transformTranslators = new HashMap<Class, TransformTranslator>();
    private final DataflowPipelineOptions options;

    public static DataflowPipelineTranslator fromOptions(DataflowPipelineOptions options) {
        return new DataflowPipelineTranslator(options);
    }

    private DataflowPipelineTranslator(DataflowPipelineOptions options) {
        this.options = options;
    }

    public JobSpecification translate(Pipeline pipeline, DataflowPipelineRunner runner, List<DataflowPackage> packages) {
        Translator translator = new Translator(pipeline, runner);
        Job result = translator.translate(packages);
        return new JobSpecification(result, Collections.unmodifiableMap(translator.stepNames));
    }

    public static String jobToString(Job job) {
        try {
            return MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)job);
        }
        catch (JsonProcessingException exc) {
            throw new IllegalStateException("Failed to render Job as String.", exc);
        }
    }

    public static <TransformT extends PTransform> void registerTransformTranslator(Class<TransformT> transformClass, TransformTranslator<? extends TransformT> transformTranslator) {
        if (transformTranslators.put(transformClass, transformTranslator) != null) {
            throw new IllegalArgumentException("defining multiple translators for " + transformClass);
        }
    }

    public <TransformT extends PTransform> TransformTranslator<TransformT> getTransformTranslator(Class<TransformT> transformClass) {
        return transformTranslators.get(transformClass);
    }

    public String toString() {
        return "DataflowPipelineTranslator#" + this.hashCode();
    }

    private static void translateInputs(PCollection<?> input, List<PCollectionView<?>> sideInputs, TranslationContext context) {
        context.addInput("parallel_input", input);
        DataflowPipelineTranslator.translateSideInputs(sideInputs, context);
    }

    private static void translateSideInputs(List<PCollectionView<?>> sideInputs, TranslationContext context) {
        HashMap<String, Object> nonParInputs = new HashMap<String, Object>();
        for (PCollectionView<?> view : sideInputs) {
            nonParInputs.put(view.getTagInternal().getId(), (Object)context.asOutputReference(view));
        }
        context.addInput("non_parallel_inputs", nonParInputs);
    }

    private static void translateFn(DoFn fn, WindowingStrategy windowingStrategy, Iterable<PCollectionView<?>> sideInputs, Coder inputCoder, TranslationContext context) {
        context.addInput("user_fn", fn.getClass().getName());
        context.addInput("serialized_fn", StringUtils.byteArrayToJsonString(SerializableUtils.serializeToByteArray(new DoFnInfo(fn, windowingStrategy, sideInputs, inputCoder))));
    }

    private static void translateOutputs(PCollectionTuple outputs, TranslationContext context) {
        for (Map.Entry<TupleTag<?>, PCollection<?>> entry : outputs.getAll().entrySet()) {
            TupleTag<?> tag = entry.getKey();
            PCollection<?> output = entry.getValue();
            context.addOutput(tag.getId(), output);
        }
    }

    static {
        DataflowPipelineTranslator.registerTransformTranslator(View.CreatePCollectionView.class, new TransformTranslator<View.CreatePCollectionView>(){

            @Override
            public void translate(View.CreatePCollectionView transform, TranslationContext context) {
                this.translateTyped(transform, context);
            }

            private <ElemT, ViewT> void translateTyped(View.CreatePCollectionView<ElemT, ViewT> transform, TranslationContext context) {
                context.addStep(transform, "CollectionToSingleton");
                context.addInput("parallel_input", (PInput)context.getInput(transform));
                context.addCollectionToSingletonOutput("output", (PValue)context.getInput(transform), (PValue)context.getOutput(transform));
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(Combine.GroupedValues.class, new TransformTranslator<Combine.GroupedValues>(){

            @Override
            public void translate(Combine.GroupedValues transform, TranslationContext context) {
                this.translateHelper(transform, context);
            }

            private <K, InputT, OutputT> void translateHelper(Combine.GroupedValues<K, InputT, OutputT> transform, TranslationContext context) {
                context.addStep(transform, "CombineValues");
                DataflowPipelineTranslator.translateInputs((PCollection)context.getInput(transform), transform.getSideInputs(), context);
                AppliedCombineFn<K, InputT, ?, OutputT> fn = transform.getAppliedFn(((PCollection)context.getInput(transform)).getPipeline().getCoderRegistry(), ((PCollection)context.getInput(transform)).getCoder(), ((PCollection)context.getInput(transform)).getWindowingStrategy());
                context.addEncodingInput(fn.getAccumulatorCoder());
                context.addInput("serialized_fn", StringUtils.byteArrayToJsonString(SerializableUtils.serializeToByteArray(fn)));
                context.addOutput("output", (PValue)context.getOutput(transform));
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(Create.Values.class, new TransformTranslator<Create.Values>(){

            @Override
            public void translate(Create.Values transform, TranslationContext context) {
                this.createHelper(transform, context);
            }

            private <T> void createHelper(Create.Values<T> transform, TranslationContext context) {
                context.addStep(transform, "CreateCollection");
                Coder coder = ((PCollection)context.getOutput(transform)).getCoder();
                LinkedList<CloudObject> elements = new LinkedList<CloudObject>();
                for (T elem : transform.getElements()) {
                    byte[] encodedBytes;
                    try {
                        encodedBytes = CoderUtils.encodeToByteArray(coder, elem);
                    }
                    catch (CoderException exn) {
                        throw new IllegalArgumentException("Unable to encode element '" + elem + "' of transform '" + transform + "' using coder '" + coder + "'.", exn);
                    }
                    String encodedJson = StringUtils.byteArrayToJsonString(encodedBytes);
                    assert (Arrays.equals(encodedBytes, StringUtils.jsonStringToByteArray(encodedJson)));
                    elements.add(CloudObject.forString(encodedJson));
                }
                context.addInput("element", elements);
                context.addValueOnlyOutput("output", (PValue)context.getOutput(transform));
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(Flatten.FlattenPCollectionList.class, new TransformTranslator<Flatten.FlattenPCollectionList>(){

            @Override
            public void translate(Flatten.FlattenPCollectionList transform, TranslationContext context) {
                this.flattenHelper(transform, context);
            }

            private <T> void flattenHelper(Flatten.FlattenPCollectionList<T> transform, TranslationContext context) {
                context.addStep(transform, "Flatten");
                LinkedList<OutputReference> inputs = new LinkedList<OutputReference>();
                for (PCollection input : ((PCollectionList)context.getInput(transform)).getAll()) {
                    inputs.add(context.asOutputReference(input));
                }
                context.addInput("inputs", inputs);
                context.addOutput("output", (PValue)context.getOutput(transform));
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(DataflowPipelineRunner.GroupByKeyAndSortValuesOnly.class, new TransformTranslator<DataflowPipelineRunner.GroupByKeyAndSortValuesOnly>(){

            @Override
            public void translate(DataflowPipelineRunner.GroupByKeyAndSortValuesOnly transform, TranslationContext context) {
                this.groupByKeyAndSortValuesHelper(transform, context);
            }

            private <K1, K2, V> void groupByKeyAndSortValuesHelper(DataflowPipelineRunner.GroupByKeyAndSortValuesOnly<K1, K2, V> transform, TranslationContext context) {
                context.addStep(transform, "GroupByKey");
                context.addInput("parallel_input", (PInput)context.getInput(transform));
                context.addOutput("output", (PValue)context.getOutput(transform));
                context.addInput("sort_values", true);
                context.addInput("disallow_combiner_lifting", true);
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(GroupByKey.class, new TransformTranslator<GroupByKey>(){

            @Override
            public void translate(GroupByKey transform, TranslationContext context) {
                this.groupByKeyHelper(transform, context);
            }

            private <K, V> void groupByKeyHelper(GroupByKey<K, V> transform, TranslationContext context) {
                context.addStep(transform, "GroupByKey");
                context.addInput("parallel_input", (PInput)context.getInput(transform));
                context.addOutput("output", (PValue)context.getOutput(transform));
                WindowingStrategy<?, ?> windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                boolean isStreaming = context.getPipelineOptions().as(StreamingOptions.class).isStreaming();
                boolean disallowCombinerLifting = !windowingStrategy.getWindowFn().isNonMerging() || isStreaming && !transform.fewKeys() || !(windowingStrategy.getTrigger().getSpec() instanceof DefaultTrigger);
                context.addInput("disallow_combiner_lifting", disallowCombinerLifting);
                context.addInput("serialized_fn", StringUtils.byteArrayToJsonString(SerializableUtils.serializeToByteArray(windowingStrategy)));
                context.addInput("is_merging_window_fn", !windowingStrategy.getWindowFn().isNonMerging());
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(ParDo.BoundMulti.class, new TransformTranslator<ParDo.BoundMulti>(){

            @Override
            public void translate(ParDo.BoundMulti transform, TranslationContext context) {
                this.translateMultiHelper(transform, context);
            }

            private <InputT, OutputT> void translateMultiHelper(ParDo.BoundMulti<InputT, OutputT> transform, TranslationContext context) {
                context.addStep(transform, "ParallelDo");
                DataflowPipelineTranslator.translateInputs((PCollection)context.getInput(transform), transform.getSideInputs(), context);
                DataflowPipelineTranslator.translateFn(transform.getFn(), ((PCollection)context.getInput(transform)).getWindowingStrategy(), transform.getSideInputs(), ((PCollection)context.getInput(transform)).getCoder(), context);
                DataflowPipelineTranslator.translateOutputs((PCollectionTuple)context.getOutput(transform), context);
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(ParDo.Bound.class, new TransformTranslator<ParDo.Bound>(){

            @Override
            public void translate(ParDo.Bound transform, TranslationContext context) {
                this.translateSingleHelper(transform, context);
            }

            private <InputT, OutputT> void translateSingleHelper(ParDo.Bound<InputT, OutputT> transform, TranslationContext context) {
                context.addStep(transform, "ParallelDo");
                DataflowPipelineTranslator.translateInputs((PCollection)context.getInput(transform), transform.getSideInputs(), context);
                DataflowPipelineTranslator.translateFn(transform.getFn(), ((PCollection)context.getInput(transform)).getWindowingStrategy(), transform.getSideInputs(), ((PCollection)context.getInput(transform)).getCoder(), context);
                context.addOutput("output", (PValue)context.getOutput(transform));
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(Window.Bound.class, new TransformTranslator<Window.Bound>(){

            @Override
            public void translate(Window.Bound transform, TranslationContext context) {
                this.translateHelper(transform, context);
            }

            private <T> void translateHelper(Window.Bound<T> transform, TranslationContext context) {
                context.addStep(transform, "Bucket");
                context.addInput("parallel_input", (PInput)context.getInput(transform));
                context.addOutput("output", (PValue)context.getOutput(transform));
                WindowingStrategy<?, ?> strategy = ((PCollection)context.getOutput(transform)).getWindowingStrategy();
                byte[] serializedBytes = SerializableUtils.serializeToByteArray(strategy);
                String serializedJson = StringUtils.byteArrayToJsonString(serializedBytes);
                assert (Arrays.equals(serializedBytes, StringUtils.jsonStringToByteArray(serializedJson)));
                context.addInput("serialized_fn", serializedJson);
            }
        });
        DataflowPipelineTranslator.registerTransformTranslator(Read.Bounded.class, new ReadTranslator());
    }

    class Translator
    implements Pipeline.PipelineVisitor,
    TranslationContext {
        private final Pipeline pipeline;
        private final DataflowPipelineRunner runner;
        private final Job job = new Job();
        private Step currentStep;
        private final Map<AppliedPTransform<?, ?, ?>, String> stepNames = new HashMap();
        private final Map<POutput, String> outputNames = new HashMap<POutput, String>();
        private final Map<POutput, Coder<?>> outputCoders = new HashMap();
        private AppliedPTransform<?, ?, ?> currentTransform;

        public Translator(Pipeline pipeline, DataflowPipelineRunner runner) {
            this.pipeline = pipeline;
            this.runner = runner;
        }

        public Job translate(List<DataflowPackage> packages) {
            this.job.setName(DataflowPipelineTranslator.this.options.getJobName().toLowerCase());
            Environment environment = new Environment();
            this.job.setEnvironment(environment);
            try {
                environment.setSdkPipelineOptions((Map)MAPPER.readValue(MAPPER.writeValueAsBytes((Object)DataflowPipelineTranslator.this.options), Map.class));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("PipelineOptions specified failed to serialize to JSON.", e);
            }
            WorkerPool workerPool = new WorkerPool();
            if (DataflowPipelineTranslator.this.options.getTeardownPolicy() != null) {
                workerPool.setTeardownPolicy(DataflowPipelineTranslator.this.options.getTeardownPolicy().getTeardownPolicyName());
            }
            if (DataflowPipelineTranslator.this.options.isStreaming()) {
                this.job.setType("JOB_TYPE_STREAMING");
            } else {
                this.job.setType("JOB_TYPE_BATCH");
                workerPool.setDiskType(DataflowPipelineTranslator.this.options.getWorkerDiskType());
            }
            if (DataflowPipelineTranslator.this.options.getWorkerMachineType() != null) {
                workerPool.setMachineType(DataflowPipelineTranslator.this.options.getWorkerMachineType());
            }
            if (DataflowPipelineTranslator.this.options.getUsePublicIps() != null) {
                if (DataflowPipelineTranslator.this.options.getUsePublicIps().booleanValue()) {
                    workerPool.setIpConfiguration("WORKER_IP_PUBLIC");
                } else {
                    workerPool.setIpConfiguration("WORKER_IP_PRIVATE");
                }
            }
            workerPool.setPackages(packages);
            workerPool.setNumWorkers(Integer.valueOf(DataflowPipelineTranslator.this.options.getNumWorkers()));
            if (DataflowPipelineTranslator.this.options.isStreaming() && (DataflowPipelineTranslator.this.options.getExperiments() == null || !DataflowPipelineTranslator.this.options.getExperiments().contains("enable_windmill_service"))) {
                Disk disk = new Disk();
                disk.setDiskType(DataflowPipelineTranslator.this.options.getWorkerDiskType());
                workerPool.setDataDisks(Collections.singletonList(disk));
            }
            if (!Strings.isNullOrEmpty(DataflowPipelineTranslator.this.options.getZone())) {
                workerPool.setZone(DataflowPipelineTranslator.this.options.getZone());
            }
            if (!Strings.isNullOrEmpty(DataflowPipelineTranslator.this.options.getNetwork())) {
                workerPool.setNetwork(DataflowPipelineTranslator.this.options.getNetwork());
            }
            if (!Strings.isNullOrEmpty(DataflowPipelineTranslator.this.options.getSubnetwork())) {
                workerPool.setSubnetwork(DataflowPipelineTranslator.this.options.getSubnetwork());
            }
            if (DataflowPipelineTranslator.this.options.getDiskSizeGb() > 0) {
                workerPool.setDiskSizeGb(Integer.valueOf(DataflowPipelineTranslator.this.options.getDiskSizeGb()));
            }
            AutoscalingSettings settings = new AutoscalingSettings();
            if (DataflowPipelineTranslator.this.options.getAutoscalingAlgorithm() != null) {
                settings.setAlgorithm(DataflowPipelineTranslator.this.options.getAutoscalingAlgorithm().getAlgorithm());
            }
            settings.setMaxNumWorkers(Integer.valueOf(DataflowPipelineTranslator.this.options.getMaxNumWorkers()));
            workerPool.setAutoscalingSettings(settings);
            LinkedList<WorkerPool> workerPools = new LinkedList<WorkerPool>();
            workerPools.add(workerPool);
            environment.setWorkerPools(workerPools);
            this.pipeline.traverseTopologically(this);
            return this.job;
        }

        @Override
        public DataflowPipelineOptions getPipelineOptions() {
            return DataflowPipelineTranslator.this.options;
        }

        @Override
        public <InputT extends PInput> InputT getInput(PTransform<InputT, ?> transform) {
            return (InputT)this.getCurrentTransform(transform).getInput();
        }

        @Override
        public <OutputT extends POutput> OutputT getOutput(PTransform<?, OutputT> transform) {
            return (OutputT)this.getCurrentTransform(transform).getOutput();
        }

        @Override
        public String getFullName(PTransform<?, ?> transform) {
            return this.getCurrentTransform(transform).getFullName();
        }

        private AppliedPTransform<?, ?, ?> getCurrentTransform(PTransform<?, ?> transform) {
            Preconditions.checkArgument(this.currentTransform != null && this.currentTransform.getTransform() == transform, "can only be called with current transform");
            return this.currentTransform;
        }

        @Override
        public void enterCompositeTransform(TransformTreeNode node) {
        }

        @Override
        public void leaveCompositeTransform(TransformTreeNode node) {
        }

        @Override
        public void visitTransform(TransformTreeNode node) {
            PTransform<?, ?> transform = node.getTransform();
            TransformTranslator<?> translator = DataflowPipelineTranslator.this.getTransformTranslator(transform.getClass());
            if (translator == null) {
                throw new IllegalStateException("no translator registered for " + transform);
            }
            LOG.debug("Translating {}", transform);
            this.currentTransform = AppliedPTransform.of(node.getFullName(), node.getInput(), node.getOutput(), transform);
            translator.translate(transform, this);
            this.currentTransform = null;
        }

        @Override
        public void visitValue(PValue value, TransformTreeNode producer) {
            LOG.debug("Checking translation of {}", (Object)value);
            if (value.getProducingTransformInternal() == null) {
                throw new RuntimeException("internal error: expecting a PValue to have a producingTransform");
            }
            if (!producer.isCompositeNode()) {
                this.asOutputReference(value);
            }
        }

        @Override
        public void addStep(PTransform<?, ?> transform, String type) {
            String stepName = this.genStepName();
            if (this.stepNames.put(this.getCurrentTransform(transform), stepName) != null) {
                throw new IllegalArgumentException(transform + " already has a name specified");
            }
            LinkedList<Step> steps = this.job.getSteps();
            if (steps == null) {
                steps = new LinkedList<Step>();
                this.job.setSteps(steps);
            }
            this.currentStep = new Step();
            this.currentStep.setName(stepName);
            this.currentStep.setKind(type);
            steps.add(this.currentStep);
            this.addInput("user_name", this.getFullName(transform));
            this.addDisplayData(stepName, transform);
        }

        @Override
        public void addStep(PTransform<?, ? extends PValue> transform, Step original) {
            LinkedList<Step> steps;
            Step step = original.clone();
            String stepName = step.getName();
            if (this.stepNames.put(this.getCurrentTransform(transform), stepName) != null) {
                throw new IllegalArgumentException(transform + " already has a name specified");
            }
            Map properties = step.getProperties();
            if (properties != null) {
                List outputInfoList = null;
                try {
                    List list;
                    outputInfoList = list = (List)properties.get("output_info");
                }
                catch (Exception e) {
                    throw new RuntimeException("Inconsistent dataflow pipeline translation", e);
                }
                if (outputInfoList != null && outputInfoList.size() > 0) {
                    String name;
                    Map firstOutputPort = (Map)outputInfoList.get(0);
                    try {
                        name = Structs.getString(firstOutputPort, "output_name");
                    }
                    catch (Exception e) {
                        name = null;
                    }
                    if (name != null) {
                        this.registerOutputName(this.getOutput(transform), name);
                    }
                }
            }
            if ((steps = this.job.getSteps()) == null) {
                steps = new LinkedList<Step>();
                this.job.setSteps(steps);
            }
            this.currentStep = step;
            steps.add(step);
        }

        @Override
        public void addEncodingInput(Coder<?> coder) {
            CloudObject encoding = SerializableUtils.ensureSerializable(coder);
            Structs.addObject(this.getProperties(), "encoding", (Map<String, Object>)((Object)encoding));
        }

        @Override
        public void addInput(String name, Boolean value) {
            Structs.addBoolean(this.getProperties(), name, value);
        }

        @Override
        public void addInput(String name, String value) {
            Structs.addString(this.getProperties(), name, value);
        }

        @Override
        public void addInput(String name, Long value) {
            Structs.addLong(this.getProperties(), name, value);
        }

        @Override
        public void addInput(String name, Map<String, Object> elements) {
            Structs.addDictionary(this.getProperties(), name, elements);
        }

        @Override
        public void addInput(String name, List<? extends Map<String, Object>> elements) {
            Structs.addList(this.getProperties(), name, elements);
        }

        @Override
        public void addInput(String name, PInput value) {
            if (!(value instanceof PValue)) {
                throw new IllegalStateException("Input must be a PValue");
            }
            this.addInput(name, (Map<String, Object>)((Object)this.asOutputReference((PValue)value)));
        }

        @Override
        public void addOutput(String name, PValue value) {
            Coder coder;
            if (value instanceof TypedPValue) {
                coder = ((TypedPValue)value).getCoder();
                if (value instanceof PCollection) {
                    coder = WindowedValue.getFullCoder(coder, ((PCollection)value).getWindowingStrategy().getWindowFn().windowCoder());
                }
            } else {
                coder = null;
            }
            this.addOutput(name, value, coder);
        }

        @Override
        public void addValueOnlyOutput(String name, PValue value) {
            Coder coder;
            if (value instanceof TypedPValue) {
                coder = ((TypedPValue)value).getCoder();
                if (value instanceof PCollection) {
                    coder = WindowedValue.getValueOnlyCoder(coder);
                }
            } else {
                coder = null;
            }
            this.addOutput(name, value, coder);
        }

        @Override
        public void addCollectionToSingletonOutput(String name, PValue inputValue, PValue outputValue) {
            Coder<?> inputValueCoder = Preconditions.checkNotNull(this.outputCoders.get(inputValue));
            Preconditions.checkState(inputValueCoder instanceof WindowedValue.WindowedValueCoder);
            IterableCoder<?> outputValueCoder = IterableCoder.of(inputValueCoder);
            this.addOutput(name, outputValue, outputValueCoder);
        }

        private void addOutput(String name, PValue value, Coder<?> valueCoder) {
            this.registerOutputName(value, name);
            Map<String, Object> properties = this.getProperties();
            ArrayList<HashMap<String, Object>> outputInfoList = null;
            try {
                outputInfoList = (ArrayList<HashMap<String, Object>>)properties.get("output_info");
            }
            catch (Exception e) {
                throw new RuntimeException("Inconsistent dataflow pipeline translation", e);
            }
            if (outputInfoList == null) {
                outputInfoList = new ArrayList<HashMap<String, Object>>();
                properties.put("output_info", outputInfoList);
            }
            HashMap<String, Object> outputInfo = new HashMap<String, Object>();
            Structs.addString(outputInfo, "output_name", name);
            Structs.addString(outputInfo, "user_name", value.getName());
            if (value instanceof PCollection && this.runner.doesPCollectionRequireIndexedFormat((PCollection)value)) {
                Structs.addBoolean(outputInfo, "use_indexed_format", true);
            }
            if (valueCoder != null) {
                CloudObject encoding = SerializableUtils.ensureSerializable(valueCoder);
                Structs.addObject(outputInfo, "encoding", (Map<String, Object>)((Object)encoding));
                this.outputCoders.put(value, valueCoder);
            }
            outputInfoList.add(outputInfo);
        }

        private void addDisplayData(String stepName, HasDisplayData hasDisplayData) {
            DisplayData displayData = DisplayData.from(hasDisplayData);
            List list = (List)MAPPER.convertValue((Object)displayData, List.class);
            Structs.addList(this.getProperties(), "display_data", list);
        }

        @Override
        public OutputReference asOutputReference(PValue value) {
            AppliedPTransform<?, ?, ?> transform = value.getProducingTransformInternal();
            String stepName = this.stepNames.get(transform);
            if (stepName == null) {
                throw new IllegalArgumentException(transform + " doesn't have a name specified");
            }
            String outputName = this.outputNames.get(value);
            if (outputName == null) {
                throw new IllegalArgumentException("output " + value + " doesn't have a name specified");
            }
            return new OutputReference(stepName, outputName);
        }

        private Map<String, Object> getProperties() {
            HashMap properties = this.currentStep.getProperties();
            if (properties == null) {
                properties = new HashMap();
                this.currentStep.setProperties(properties);
            }
            return properties;
        }

        private String genStepName() {
            return "s" + (this.stepNames.size() + 1);
        }

        private void registerOutputName(POutput value, String name) {
            if (this.outputNames.put(value, name) != null) {
                throw new IllegalArgumentException("output " + value + " already has a name specified");
            }
        }
    }

    public static interface TranslationContext {
        public DataflowPipelineOptions getPipelineOptions();

        public <InputT extends PInput> InputT getInput(PTransform<InputT, ?> var1);

        public <OutputT extends POutput> OutputT getOutput(PTransform<?, OutputT> var1);

        public String getFullName(PTransform<?, ?> var1);

        public void addStep(PTransform<?, ?> var1, String var2);

        public void addStep(PTransform<?, ? extends PValue> var1, Step var2);

        public void addEncodingInput(Coder<?> var1);

        public void addInput(String var1, Boolean var2);

        public void addInput(String var1, String var2);

        public void addInput(String var1, Long var2);

        public void addInput(String var1, PInput var2);

        public void addInput(String var1, Map<String, Object> var2);

        public void addInput(String var1, List<? extends Map<String, Object>> var2);

        public void addOutput(String var1, PValue var2);

        public void addValueOnlyOutput(String var1, PValue var2);

        public void addCollectionToSingletonOutput(String var1, PValue var2, PValue var3);

        public OutputReference asOutputReference(PValue var1);
    }

    public static interface TransformTranslator<TransformT extends PTransform> {
        public void translate(TransformT var1, TranslationContext var2);
    }

    public static class JobSpecification {
        private final Job job;
        private final Map<AppliedPTransform<?, ?, ?>, String> stepNames;

        public JobSpecification(Job job, Map<AppliedPTransform<?, ?, ?>, String> stepNames) {
            this.job = job;
            this.stepNames = stepNames;
        }

        public Job getJob() {
            return this.job;
        }

        public Map<AppliedPTransform<?, ?, ?>, String> getStepNames() {
            return this.stepNames;
        }
    }
}

