/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.v1.ReadRowsResponse;
import com.google.bigtable.v1.Row;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.ResultQueueEntry;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.ScanTimeoutException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import io.grpc.ClientCall;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ResponseQueueReader
implements StreamObserver<Row> {
    private final BlockingQueue<ResultQueueEntry<Row>> resultQueue;
    private final int readPartialRowTimeoutMillis;
    private boolean lastResponseProcessed = false;
    private AtomicBoolean completionMarkerFound = new AtomicBoolean(false);
    private final int capacityCap;
    private final int batchRequestSize;
    private AtomicInteger outstandingRequestCount;
    private final ClientCall<?, ReadRowsResponse> call;

    public ResponseQueueReader(int readPartialRowTimeoutMillis, int capacityCap, AtomicInteger outstandingRequestCount, int batchRequestSize, ClientCall<?, ReadRowsResponse> call) {
        this.resultQueue = new LinkedBlockingQueue<ResultQueueEntry<Row>>();
        this.readPartialRowTimeoutMillis = readPartialRowTimeoutMillis;
        this.capacityCap = capacityCap;
        this.outstandingRequestCount = outstandingRequestCount;
        this.batchRequestSize = batchRequestSize;
        this.call = call;
    }

    public synchronized Row getNextMergedRow() throws IOException {
        if (!this.lastResponseProcessed) {
            ResultQueueEntry<Row> queueEntry = this.getNext();
            if (queueEntry.isCompletionMarker()) {
                this.lastResponseProcessed = true;
            } else {
                return queueEntry.getResponseOrThrow();
            }
        }
        Preconditions.checkState(this.lastResponseProcessed, "Should only exit merge loop with by returning a complete Row or hitting end of stream.");
        return null;
    }

    private ResultQueueEntry<Row> getNext() throws IOException {
        ResultQueueEntry<Row> queueEntry;
        if (!this.completionMarkerFound.get() && this.moreCanBeRequested()) {
            this.call.request(this.batchRequestSize);
            this.outstandingRequestCount.addAndGet(this.batchRequestSize);
        }
        try {
            queueEntry = this.resultQueue.poll(this.readPartialRowTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted while waiting for next result", e);
        }
        if (queueEntry == null) {
            throw new ScanTimeoutException("Timeout while merging responses.");
        }
        return queueEntry;
    }

    private boolean moreCanBeRequested() {
        return this.outstandingRequestCount.get() + this.resultQueue.size() <= this.capacityCap - this.batchRequestSize;
    }

    public int available() {
        return this.resultQueue.size();
    }

    public void onNext(Row row) {
        try {
            this.resultQueue.put(ResultQueueEntry.fromResponse(row));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while adding a ResultQueueEntry", e);
        }
    }

    public void onError(Throwable t) {
        try {
            this.resultQueue.put(ResultQueueEntry.fromThrowable(t));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while adding a ResultQueueEntry", e);
        }
    }

    public void onCompleted() {
        try {
            this.completionMarkerFound.set(true);
            this.resultQueue.put(ResultQueueEntry.completionMarker());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while adding a ResultQueueEntry", e);
        }
    }
}

