/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async.AbstractRetryingRpcListener;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.ScheduledExecutorService;

public class RetryingUnaryRpcListener<RequestT, ResponseT>
extends AbstractRetryingRpcListener<RequestT, ResponseT, ResponseT> {
    static final StatusRuntimeException NO_VALUE_SET_EXCEPTION = Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException();
    private ResponseT value;

    public RetryingUnaryRpcListener(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, ScheduledExecutorService executorService) {
        super(retryOptions, request, retryableRpc, executorService);
    }

    public void onMessage(ResponseT message) {
        this.value = message;
        this.completionFuture.set(this.value);
    }

    @Override
    protected void onOK() {
        if (this.value == null) {
            this.completionFuture.setException(NO_VALUE_SET_EXCEPTION);
        }
    }
}

