/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.v1.ReadRowsRequest;
import com.google.bigtable.v1.Row;
import com.google.bigtable.v1.RowFilter;
import com.google.bigtable.v1.RowSet;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.dataflow.sdk.repackaged.com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.HashMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Multimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class BulkRead {
    protected static final Logger LOG = new Logger(BulkRead.class);
    private final BigtableDataClient client;
    private final String tableName;
    private RowFilter currentFilter;
    private Multimap<ByteString, SettableFuture<List<Row>>> futures;

    public BulkRead(BigtableDataClient client, BigtableTableName tableName) {
        this.client = client;
        this.tableName = tableName.toString();
    }

    public ListenableFuture<List<Row>> add(ReadRowsRequest request) throws InterruptedException {
        Preconditions.checkNotNull((Object)request);
        ByteString rowKey = request.getRowKey();
        Preconditions.checkArgument((!rowKey.equals((Object)ByteString.EMPTY) ? 1 : 0) != 0);
        RowFilter filter = request.getFilter();
        if (this.currentFilter == null) {
            this.currentFilter = filter;
        } else if (!filter.equals((Object)this.currentFilter)) {
            this.flush();
            this.currentFilter = filter;
        }
        if (this.futures == null) {
            this.futures = HashMultimap.create();
        }
        SettableFuture<List<Row>> future = SettableFuture.create();
        this.futures.put(rowKey, future);
        return future;
    }

    public void flush() {
        if (this.futures != null && !this.futures.isEmpty()) {
            try {
                Row row;
                ResultScanner<Row> scanner = this.client.readRows(ReadRowsRequest.newBuilder().setTableName(this.tableName).setFilter(this.currentFilter).setRowSet(RowSet.newBuilder().addAllRowKeys(this.futures.keys()).build()).setAllowRowInterleaving(true).build());
                while ((row = scanner.next()) != null) {
                    Collection<SettableFuture<List<Row>>> rowFutures = this.futures.get(row.getKey());
                    if (rowFutures != null) {
                        for (SettableFuture<List<Row>> rowFuture : rowFutures) {
                            rowFuture.set(ImmutableList.of(row));
                        }
                        this.futures.removeAll(row.getKey());
                        continue;
                    }
                    LOG.warn("Found key: %s, but it was not in the original request.", row.getKey());
                }
                for (Map.Entry<ByteString, SettableFuture<List<Row>>> entry : this.futures.entries()) {
                    entry.getValue().set(ImmutableList.of());
                }
            }
            catch (IOException e) {
                for (Map.Entry<ByteString, SettableFuture<List<Row>>> entry : this.futures.entries()) {
                    entry.getValue().setException(e);
                }
            }
        }
        this.futures = null;
        this.currentFilter = null;
    }
}

