/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.dataflow.sdk.options.ApplicationNameOptions;
import com.google.cloud.dataflow.sdk.options.DataflowWorkerHarnessOptions;
import com.google.cloud.dataflow.sdk.options.Default;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.PipelineOptionSpec;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsReflector;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsRegistrar;
import com.google.cloud.dataflow.sdk.options.PipelineOptionsValidator;
import com.google.cloud.dataflow.sdk.options.ProxyInvocationHandler;
import com.google.cloud.dataflow.sdk.options.Validation;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Function;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Optional;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Predicate;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Strings;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Collections2;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.FluentIterable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableListMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterators;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ListMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Maps;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Ordering;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Sets;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.SortedSetMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.TreeBasedTable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.TreeMultimap;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.UnmodifiableIterator;
import com.google.cloud.dataflow.sdk.runners.PipelineRunner;
import com.google.cloud.dataflow.sdk.runners.PipelineRunnerRegistrar;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.util.StringUtils;
import com.google.cloud.dataflow.sdk.util.common.ReflectHelpers;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineOptionsFactory {
    private static final Set<Class<?>> SIMPLE_TYPES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Boolean.TYPE)).add(Boolean.class)).add(Character.TYPE)).add(Character.class)).add(Short.TYPE)).add(Short.class)).add(Integer.TYPE)).add(Integer.class)).add(Long.TYPE)).add(Long.class)).add(Float.TYPE)).add(Float.class)).add(Double.TYPE)).add(Double.class)).add(String.class)).add(Class.class)).build();
    private static final Logger LOG = LoggerFactory.getLogger(PipelineOptionsFactory.class);
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final ClassLoader CLASS_LOADER;
    private static final Map<String, Class<? extends PipelineRunner<?>>> SUPPORTED_PIPELINE_RUNNERS;
    private static final Set<String> PIPELINE_OPTIONS_FACTORY_CLASSES;
    private static final Set<Method> IGNORED_METHODS;
    private static final Predicate<Method> NOT_SYNTHETIC_PREDICATE;
    private static final Set<Class<? extends PipelineOptions>> REGISTERED_OPTIONS;
    private static final Map<Class<? extends PipelineOptions>, Registration<?>> INTERFACE_CACHE;
    private static final Map<Set<Class<? extends PipelineOptions>>, Registration<?>> COMBINED_CACHE;
    private static final int TERMINAL_WIDTH = 80;

    public static PipelineOptions create() {
        return new Builder().as(PipelineOptions.class);
    }

    public static <T extends PipelineOptions> T as(Class<T> klass) {
        return new Builder().as(klass);
    }

    public static Builder fromArgs(String[] args) {
        return new Builder().fromArgs(args);
    }

    public Builder withValidation() {
        return new Builder().withValidation();
    }

    static boolean printHelpUsageAndExitIfNeeded(ListMultimap<String, String> options, PrintStream printStream, boolean exit) {
        if (options.containsKey("help")) {
            final String helpOption = Iterables.getOnlyElement(options.get("help"));
            if (Boolean.TRUE.toString().equals(helpOption)) {
                PipelineOptionsFactory.printHelp(printStream);
                if (exit) {
                    System.exit(0);
                } else {
                    return true;
                }
            }
            try {
                Class<?> klass = Class.forName(helpOption);
                if (!PipelineOptions.class.isAssignableFrom(klass)) {
                    throw new ClassNotFoundException("PipelineOptions of type " + klass + " not found.");
                }
                PipelineOptionsFactory.printHelp(printStream, klass);
            }
            catch (ClassNotFoundException e) {
                Iterable<Class<? extends PipelineOptions>> matches = Iterables.filter(PipelineOptionsFactory.getRegisteredOptions(), new Predicate<Class<? extends PipelineOptions>>(){

                    @Override
                    public boolean apply(Class<? extends PipelineOptions> input) {
                        if (helpOption.contains(".")) {
                            return input.getName().endsWith(helpOption);
                        }
                        return input.getSimpleName().equals(helpOption);
                    }
                });
                try {
                    PipelineOptionsFactory.printHelp(printStream, Iterables.getOnlyElement(matches));
                }
                catch (NoSuchElementException exception) {
                    printStream.format("Unable to find option %s.%n", helpOption);
                    PipelineOptionsFactory.printHelp(printStream);
                }
                catch (IllegalArgumentException exception) {
                    printStream.format("Multiple matches found for %s: %s.%n", helpOption, Iterables.transform(matches, ReflectHelpers.CLASS_NAME));
                    PipelineOptionsFactory.printHelp(printStream);
                }
            }
            if (exit) {
                System.exit(0);
            } else {
                return true;
            }
        }
        return false;
    }

    private static String findCallersClassName() {
        StackTraceElement next;
        UnmodifiableIterator<StackTraceElement> elements = Iterators.forArray(Thread.currentThread().getStackTrace());
        while (elements.hasNext() && !PIPELINE_OPTIONS_FACTORY_CLASSES.contains((next = (StackTraceElement)elements.next()).getClassName())) {
        }
        while (elements.hasNext()) {
            next = (StackTraceElement)elements.next();
            if (PIPELINE_OPTIONS_FACTORY_CLASSES.contains(next.getClassName())) continue;
            try {
                return Class.forName(next.getClassName()).getSimpleName();
            }
            catch (ClassNotFoundException e) {
                break;
            }
        }
        return "unknown";
    }

    static ClassLoader findClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = PipelineOptionsFactory.class.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static synchronized void register(Class<? extends PipelineOptions> iface) {
        Preconditions.checkNotNull(iface);
        Preconditions.checkArgument(iface.isInterface(), "Only interface types are supported.");
        if (REGISTERED_OPTIONS.contains(iface)) {
            return;
        }
        PipelineOptionsFactory.validateWellFormed(iface, REGISTERED_OPTIONS);
        REGISTERED_OPTIONS.add(iface);
    }

    @VisibleForTesting
    static synchronized void resetRegistry() {
        REGISTERED_OPTIONS.clear();
        PipelineOptionsFactory.initializeRegistry();
    }

    private static void initializeRegistry() {
        PipelineOptionsFactory.register(PipelineOptions.class);
        TreeSet<Object> pipelineOptionsRegistrars = Sets.newTreeSet(ObjectsClassComparator.INSTANCE);
        pipelineOptionsRegistrars.addAll(Lists.newArrayList(ServiceLoader.load(PipelineOptionsRegistrar.class, CLASS_LOADER)));
        for (PipelineOptionsRegistrar pipelineOptionsRegistrar : pipelineOptionsRegistrars) {
            for (Class<? extends PipelineOptions> klass : pipelineOptionsRegistrar.getPipelineOptions()) {
                PipelineOptionsFactory.register(klass);
            }
        }
    }

    static synchronized <T extends PipelineOptions> Registration<T> validateWellFormed(Class<T> iface, Set<Class<? extends PipelineOptions>> validatedPipelineOptionsInterfaces) {
        List<PropertyDescriptor> propertyDescriptors;
        Preconditions.checkArgument(iface.isInterface(), "Only interface types are supported.");
        ImmutableSet<Class> combinedPipelineOptionsInterfaces = FluentIterable.from(validatedPipelineOptionsInterfaces).append(iface).toSet();
        if (!COMBINED_CACHE.containsKey(combinedPipelineOptionsInterfaces)) {
            Class<?> allProxyClass = Proxy.getProxyClass(PipelineOptionsFactory.class.getClassLoader(), combinedPipelineOptionsInterfaces.toArray(EMPTY_CLASS_ARRAY));
            try {
                propertyDescriptors = PipelineOptionsFactory.validateClass(iface, validatedPipelineOptionsInterfaces, allProxyClass);
                COMBINED_CACHE.put(combinedPipelineOptionsInterfaces, new Registration(allProxyClass, propertyDescriptors));
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }
        if (!INTERFACE_CACHE.containsKey(iface)) {
            Class<?> proxyClass = Proxy.getProxyClass(PipelineOptionsFactory.class.getClassLoader(), iface);
            try {
                propertyDescriptors = PipelineOptionsFactory.validateClass(iface, validatedPipelineOptionsInterfaces, proxyClass);
                INTERFACE_CACHE.put(iface, new Registration(proxyClass, propertyDescriptors));
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }
        Registration<?> result = INTERFACE_CACHE.get(iface);
        return result;
    }

    public static Set<Class<? extends PipelineOptions>> getRegisteredOptions() {
        return Collections.unmodifiableSet(REGISTERED_OPTIONS);
    }

    public static void printHelp(PrintStream out) {
        Preconditions.checkNotNull(out);
        out.println("The set of registered options are:");
        TreeSet<Class<? extends PipelineOptions>> sortedOptions = new TreeSet<Class<? extends PipelineOptions>>(ClassNameComparator.INSTANCE);
        sortedOptions.addAll(REGISTERED_OPTIONS);
        for (Class clazz : sortedOptions) {
            out.format("  %s%n", clazz.getName());
        }
        out.format("%nUse --help=<OptionsName> for detailed help. For example:%n  --help=DataflowPipelineOptions <short names valid for registered options>%n  --help=com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions%n", new Object[0]);
    }

    public static void printHelp(PrintStream out, Class<? extends PipelineOptions> iface) {
        Preconditions.checkNotNull(out);
        Preconditions.checkNotNull(iface);
        PipelineOptionsFactory.validateWellFormed(iface, REGISTERED_OPTIONS);
        Set<PipelineOptionSpec> properties = PipelineOptionsReflector.getOptionSpecs(iface);
        TreeBasedTable<Class<? extends PipelineOptions>, String, Method> ifacePropGetterTable = TreeBasedTable.create(ClassNameComparator.INSTANCE, Ordering.natural());
        for (PipelineOptionSpec pipelineOptionSpec : properties) {
            ifacePropGetterTable.put(pipelineOptionSpec.getDefiningInterface(), pipelineOptionSpec.getName(), pipelineOptionSpec.getGetterMethod());
        }
        for (Map.Entry entry : ifacePropGetterTable.rowMap().entrySet()) {
            Class currentIface = (Class)entry.getKey();
            Map propertyNamesToGetters = (Map)entry.getValue();
            SortedSetMultimap<String, String> requiredGroupNameToProperties = PipelineOptionsFactory.getRequiredGroupNamesToProperties(propertyNamesToGetters);
            out.format("%s:%n", currentIface.getName());
            PipelineOptionsFactory.prettyPrintDescription(out, currentIface.getAnnotation(Description.class));
            out.println();
            ArrayList<String> lists = Lists.newArrayList(propertyNamesToGetters.keySet());
            Collections.sort(lists, String.CASE_INSENSITIVE_ORDER);
            for (String propertyName : lists) {
                Method method = (Method)propertyNamesToGetters.get(propertyName);
                String printableType = method.getReturnType().getSimpleName();
                if (method.getReturnType().isEnum()) {
                    printableType = Joiner.on(" | ").join(method.getReturnType().getEnumConstants());
                }
                out.format("  --%s=<%s>%n", propertyName, printableType);
                Optional<String> defaultValue = PipelineOptionsFactory.getDefaultValueFromAnnotation(method);
                if (defaultValue.isPresent()) {
                    out.format("    Default: %s%n", defaultValue.get());
                }
                PipelineOptionsFactory.prettyPrintDescription(out, method.getAnnotation(Description.class));
                PipelineOptionsFactory.prettyPrintRequiredGroups(out, method.getAnnotation(Validation.Required.class), requiredGroupNameToProperties);
            }
            out.println();
        }
    }

    private static void prettyPrintRequiredGroups(PrintStream out, Validation.Required annotation, SortedSetMultimap<String, String> requiredGroupNameToProperties) {
        if (annotation == null || annotation.groups() == null) {
            return;
        }
        for (String group : annotation.groups()) {
            SortedSet<String> groupMembers = requiredGroupNameToProperties.get(group);
            String requirement = groupMembers.size() == 1 ? Iterables.getOnlyElement(groupMembers) + " is required." : "At least one of " + groupMembers + " is required";
            PipelineOptionsFactory.terminalPrettyPrint(out, requirement.split("\\s+"));
        }
    }

    private static void prettyPrintDescription(PrintStream out, Description description) {
        if (description == null || description.value() == null) {
            return;
        }
        String[] words = description.value().split("\\s+");
        PipelineOptionsFactory.terminalPrettyPrint(out, words);
    }

    private static void terminalPrettyPrint(PrintStream out, String[] words) {
        String spacing = "   ";
        if (words.length == 0) {
            return;
        }
        out.print("   ");
        int lineLength = "   ".length();
        for (int i = 0; i < words.length; ++i) {
            out.print(" ");
            out.print(words[i]);
            if (i + 1 == words.length || words[i + 1].length() + (lineLength += 1 + words[i].length()) + 1 <= 80) continue;
            out.println();
            out.print("   ");
            lineLength = "   ".length();
        }
        out.println();
    }

    private static Optional<String> getDefaultValueFromAnnotation(Method method) {
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof Default.Class) {
                return Optional.of(((Default.Class)annotation).value().getSimpleName());
            }
            if (annotation instanceof Default.String) {
                return Optional.of(((Default.String)annotation).value());
            }
            if (annotation instanceof Default.Boolean) {
                return Optional.of(Boolean.toString(((Default.Boolean)annotation).value()));
            }
            if (annotation instanceof Default.Character) {
                return Optional.of(Character.toString(((Default.Character)annotation).value()));
            }
            if (annotation instanceof Default.Byte) {
                return Optional.of(Byte.toString(((Default.Byte)annotation).value()));
            }
            if (annotation instanceof Default.Short) {
                return Optional.of(Short.toString(((Default.Short)annotation).value()));
            }
            if (annotation instanceof Default.Integer) {
                return Optional.of(Integer.toString(((Default.Integer)annotation).value()));
            }
            if (annotation instanceof Default.Long) {
                return Optional.of(Long.toString(((Default.Long)annotation).value()));
            }
            if (annotation instanceof Default.Float) {
                return Optional.of(Float.toString(((Default.Float)annotation).value()));
            }
            if (annotation instanceof Default.Double) {
                return Optional.of(Double.toString(((Default.Double)annotation).value()));
            }
            if (annotation instanceof Default.Enum) {
                return Optional.of(((Default.Enum)annotation).value());
            }
            if (!(annotation instanceof Default.InstanceFactory)) continue;
            return Optional.of(((Default.InstanceFactory)annotation).value().getSimpleName());
        }
        return Optional.absent();
    }

    static Map<String, Class<? extends PipelineRunner<?>>> getRegisteredRunners() {
        return SUPPORTED_PIPELINE_RUNNERS;
    }

    static List<PropertyDescriptor> getPropertyDescriptors(Set<Class<? extends PipelineOptions>> interfaces) {
        return COMBINED_CACHE.get(interfaces).getPropertyDescriptors();
    }

    public static DataflowWorkerHarnessOptions createFromSystemPropertiesInternal() throws IOException {
        return PipelineOptionsFactory.createFromSystemProperties();
    }

    @Deprecated
    public static DataflowWorkerHarnessOptions createFromSystemProperties() throws IOException {
        DataflowWorkerHarnessOptions options;
        ObjectMapper objectMapper = new ObjectMapper();
        if (System.getProperties().containsKey("sdk_pipeline_options")) {
            String serializedOptions = System.getProperty("sdk_pipeline_options");
            LOG.info("Worker harness starting with: " + serializedOptions);
            options = ((PipelineOptions)objectMapper.readValue(serializedOptions, PipelineOptions.class)).as(DataflowWorkerHarnessOptions.class);
        } else {
            options = PipelineOptionsFactory.as(DataflowWorkerHarnessOptions.class);
        }
        if (System.getProperties().containsKey("worker_id")) {
            options.setWorkerId(System.getProperty("worker_id"));
        }
        if (System.getProperties().containsKey("job_id")) {
            options.setJobId(System.getProperty("job_id"));
        }
        return options;
    }

    private static List<PropertyDescriptor> getPropertyDescriptors(Class<? extends PipelineOptions> beanClass) throws IntrospectionException {
        TreeSet<Method> methods = Sets.newTreeSet(MethodComparator.INSTANCE);
        methods.addAll(Collections2.filter(Arrays.asList(beanClass.getMethods()), NOT_SYNTHETIC_PREDICATE));
        TreeMap<String, Method> propertyNamesToGetters = new TreeMap<String, Method>();
        for (Map.Entry<String, Method> entry : PipelineOptionsReflector.getPropertyNamesToGetters(methods).entries()) {
            propertyNamesToGetters.put(entry.getKey(), entry.getValue());
        }
        ArrayList<PropertyDescriptor> descriptors = Lists.newArrayList();
        ArrayList<TypeMismatch> mismatches = new ArrayList<TypeMismatch>();
        for (Method method : methods) {
            Class<?> setterPropertyType;
            Class<?> getterPropertyType;
            String methodName = method.getName();
            if (!methodName.startsWith("set") || method.getParameterTypes().length != 1 || method.getReturnType() != Void.TYPE) continue;
            String propertyName = Introspector.decapitalize(methodName.substring(3));
            Method getterMethod = (Method)propertyNamesToGetters.remove(propertyName);
            if (getterMethod != null && (getterPropertyType = getterMethod.getReturnType()) != (setterPropertyType = method.getParameterTypes()[0])) {
                TypeMismatch mismatch = new TypeMismatch();
                mismatch.propertyName = propertyName;
                mismatch.getterPropertyType = getterPropertyType;
                mismatch.setterPropertyType = setterPropertyType;
                mismatches.add(mismatch);
                continue;
            }
            descriptors.add(new PropertyDescriptor(propertyName, getterMethod, method));
        }
        PipelineOptionsFactory.throwForTypeMismatches(mismatches);
        for (Map.Entry entry : propertyNamesToGetters.entrySet()) {
            descriptors.add(new PropertyDescriptor((String)entry.getKey(), (Method)entry.getValue(), null));
        }
        return descriptors;
    }

    private static void throwForTypeMismatches(List<TypeMismatch> mismatches) {
        if (mismatches.size() == 1) {
            TypeMismatch mismatch = mismatches.get(0);
            throw new IllegalArgumentException(String.format("Type mismatch between getter and setter methods for property [%s]. Getter is of type [%s] whereas setter is of type [%s].", mismatch.propertyName, mismatch.getterPropertyType.getName(), mismatch.setterPropertyType.getName()));
        }
        if (mismatches.size() > 1) {
            StringBuilder builder = new StringBuilder(String.format("Type mismatches between getters and setters detected:", new Object[0]));
            for (TypeMismatch mismatch : mismatches) {
                builder.append(String.format("%n  - Property [%s]: Getter is of type [%s] whereas setter is of type [%s].", mismatch.propertyName, mismatch.getterPropertyType.getName(), mismatch.setterPropertyType.getName()));
            }
            throw new IllegalArgumentException(builder.toString());
        }
    }

    private static SortedSetMultimap<String, String> getRequiredGroupNamesToProperties(Map<String, Method> propertyNamesToGetters) {
        TreeMultimap<String, String> result = TreeMultimap.create();
        for (Map.Entry<String, Method> propertyEntry : propertyNamesToGetters.entrySet()) {
            Validation.Required requiredAnnotation = propertyEntry.getValue().getAnnotation(Validation.Required.class);
            if (requiredAnnotation == null) continue;
            for (String groupName : requiredAnnotation.groups()) {
                result.put(groupName, propertyEntry.getKey());
            }
        }
        return result;
    }

    private static List<PropertyDescriptor> validateClass(Class<? extends PipelineOptions> iface, Set<Class<? extends PipelineOptions>> validatedPipelineOptionsInterfaces, Class<? extends PipelineOptions> klass) throws IntrospectionException {
        HashSet<Method> methods = Sets.newHashSet(IGNORED_METHODS);
        for (Method method : klass.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) && !method.isSynthetic()) continue;
            methods.add(method);
        }
        try {
            methods.add(klass.getMethod("equals", Object.class));
            methods.add(klass.getMethod("hashCode", new Class[0]));
            methods.add(klass.getMethod("toString", new Class[0]));
            methods.add(klass.getMethod("as", Class.class));
            methods.add(klass.getMethod("cloneAs", Class.class));
            methods.add(klass.getMethod("populateDisplayData", DisplayData.Builder.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
        ImmutableSortedSet<Method> interfaceMethods = FluentIterable.from(ReflectHelpers.getClosureOfMethodsOnInterface(iface)).filter(NOT_SYNTHETIC_PREDICATE).toSortedSet(MethodComparator.INSTANCE);
        TreeMultimap<Method, Method> methodNameToMethodMap = TreeMultimap.create(MethodNameComparator.INSTANCE, MethodComparator.INSTANCE);
        for (Method method : interfaceMethods) {
            methodNameToMethodMap.put(method, method);
        }
        ArrayList<MultipleDefinitions> multipleDefinitions = Lists.newArrayList();
        for (Map.Entry entry : methodNameToMethodMap.asMap().entrySet()) {
            ImmutableSet returnTypes = FluentIterable.from(entry.getValue()).transform(ReturnTypeFetchingFunction.INSTANCE).toSet();
            ImmutableSortedSet<Method> collidingMethods = FluentIterable.from(entry.getValue()).toSortedSet(MethodComparator.INSTANCE);
            if (returnTypes.size() <= 1) continue;
            MultipleDefinitions defs = new MultipleDefinitions();
            defs.method = (Method)entry.getKey();
            defs.collidingMethods = collidingMethods;
            multipleDefinitions.add(defs);
        }
        PipelineOptionsFactory.throwForMultipleDefinitions(iface, multipleDefinitions);
        ImmutableSortedSet<Method> immutableSortedSet = FluentIterable.from(ReflectHelpers.getClosureOfMethodsOnInterfaces(validatedPipelineOptionsInterfaces)).append(ReflectHelpers.getClosureOfMethodsOnInterface(iface)).filter(NOT_SYNTHETIC_PREDICATE).toSortedSet(MethodComparator.INSTANCE);
        TreeMultimap<Method, Method> treeMultimap = TreeMultimap.create(MethodNameComparator.INSTANCE, MethodComparator.INSTANCE);
        for (Method method : immutableSortedSet) {
            treeMultimap.put(method, method);
        }
        List<PropertyDescriptor> descriptors = PipelineOptionsFactory.getPropertyDescriptors(klass);
        ArrayList<InconsistentlyIgnoredGetters> incompletelyIgnoredGetters = new ArrayList<InconsistentlyIgnoredGetters>();
        ArrayList<IgnoredSetter> ignoredSetters = new ArrayList<IgnoredSetter>();
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            if (propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null || IGNORED_METHODS.contains(propertyDescriptor.getReadMethod()) || IGNORED_METHODS.contains(propertyDescriptor.getWriteMethod())) continue;
            SortedSet getters = treeMultimap.get(propertyDescriptor.getReadMethod());
            SortedSet<Method> gettersWithJsonIgnore = Sets.filter(getters, JsonIgnorePredicate.INSTANCE);
            FluentIterable<String> getterClassNames = FluentIterable.from(getters).transform(MethodToDeclaringClassFunction.INSTANCE).transform(ReflectHelpers.CLASS_NAME);
            FluentIterable<String> gettersWithJsonIgnoreClassNames = FluentIterable.from(gettersWithJsonIgnore).transform(MethodToDeclaringClassFunction.INSTANCE).transform(ReflectHelpers.CLASS_NAME);
            if (!gettersWithJsonIgnore.isEmpty() && getters.size() != gettersWithJsonIgnore.size()) {
                InconsistentlyIgnoredGetters err = new InconsistentlyIgnoredGetters();
                err.descriptor = propertyDescriptor;
                err.getterClassNames = getterClassNames;
                err.gettersWithJsonIgnoreClassNames = gettersWithJsonIgnoreClassNames;
                incompletelyIgnoredGetters.add(err);
            }
            if (!incompletelyIgnoredGetters.isEmpty()) continue;
            SortedSet<Method> settersWithJsonIgnore = Sets.filter(treeMultimap.get(propertyDescriptor.getWriteMethod()), JsonIgnorePredicate.INSTANCE);
            FluentIterable<String> settersWithJsonIgnoreClassNames = FluentIterable.from(settersWithJsonIgnore).transform(MethodToDeclaringClassFunction.INSTANCE).transform(ReflectHelpers.CLASS_NAME);
            if (settersWithJsonIgnore.isEmpty()) continue;
            IgnoredSetter ignored = new IgnoredSetter();
            ignored.descriptor = propertyDescriptor;
            ignored.settersWithJsonIgnoreClassNames = settersWithJsonIgnoreClassNames;
            ignoredSetters.add(ignored);
        }
        PipelineOptionsFactory.throwForGettersWithInconsistentJsonIgnore(incompletelyIgnoredGetters);
        PipelineOptionsFactory.throwForSettersWithJsonIgnore(ignoredSetters);
        ArrayList<MissingBeanMethod> missingBeanMethods = new ArrayList<MissingBeanMethod>();
        for (PropertyDescriptor propertyDescriptor : descriptors) {
            MissingBeanMethod method;
            if (!IGNORED_METHODS.contains(propertyDescriptor.getWriteMethod()) && propertyDescriptor.getReadMethod() == null) {
                method = new MissingBeanMethod();
                method.property = propertyDescriptor;
                method.methodType = "getter";
                missingBeanMethods.add(method);
                continue;
            }
            if (!IGNORED_METHODS.contains(propertyDescriptor.getReadMethod()) && propertyDescriptor.getWriteMethod() == null) {
                method = new MissingBeanMethod();
                method.property = propertyDescriptor;
                method.methodType = "setter";
                missingBeanMethods.add(method);
                continue;
            }
            methods.add(propertyDescriptor.getReadMethod());
            methods.add(propertyDescriptor.getWriteMethod());
        }
        PipelineOptionsFactory.throwForMissingBeanMethod(iface, missingBeanMethods);
        TreeSet<Method> treeSet = new TreeSet<Method>(MethodComparator.INSTANCE);
        treeSet.addAll(Sets.filter(Sets.difference(Sets.newHashSet(klass.getMethods()), methods), NOT_SYNTHETIC_PREDICATE));
        Preconditions.checkArgument(treeSet.isEmpty(), "Methods %s on [%s] do not conform to being bean properties.", FluentIterable.from(treeSet).transform(ReflectHelpers.METHOD_FORMATTER), iface.getName());
        return descriptors;
    }

    private static void throwForMultipleDefinitions(Class<? extends PipelineOptions> iface, List<MultipleDefinitions> definitions) {
        if (definitions.size() == 1) {
            MultipleDefinitions errDef = definitions.get(0);
            throw new IllegalArgumentException(String.format("Method [%s] has multiple definitions %s with different return types for [%s].", errDef.method.getName(), errDef.collidingMethods, iface.getName()));
        }
        if (definitions.size() > 1) {
            StringBuilder errorBuilder = new StringBuilder(String.format("Interface [%s] has Methods with multiple definitions with different return types:", iface.getName()));
            for (MultipleDefinitions errDef : definitions) {
                errorBuilder.append(String.format("%n  - Method [%s] has multiple definitions %s", errDef.method.getName(), errDef.collidingMethods));
            }
            throw new IllegalArgumentException(errorBuilder.toString());
        }
    }

    private static void throwForGettersWithInconsistentJsonIgnore(List<InconsistentlyIgnoredGetters> getters) {
        if (getters.size() == 1) {
            InconsistentlyIgnoredGetters getter = getters.get(0);
            throw new IllegalArgumentException(String.format("Expected getter for property [%s] to be marked with @JsonIgnore on all %s, found only on %s", getter.descriptor.getName(), getter.getterClassNames, getter.gettersWithJsonIgnoreClassNames));
        }
        if (getters.size() > 1) {
            StringBuilder errorBuilder = new StringBuilder("Property getters are inconsistently marked with @JsonIgnore:");
            for (InconsistentlyIgnoredGetters getter : getters) {
                errorBuilder.append(String.format("%n  - Expected for property [%s] to be marked on all %s, found only on %s", getter.descriptor.getName(), getter.getterClassNames, getter.gettersWithJsonIgnoreClassNames));
            }
            throw new IllegalArgumentException(errorBuilder.toString());
        }
    }

    private static void throwForSettersWithJsonIgnore(List<IgnoredSetter> setters) {
        if (setters.size() == 1) {
            IgnoredSetter setter = setters.get(0);
            throw new IllegalArgumentException(String.format("Expected setter for property [%s] to not be marked with @JsonIgnore on %s", setter.descriptor.getName(), setter.settersWithJsonIgnoreClassNames));
        }
        if (setters.size() > 1) {
            StringBuilder builder = new StringBuilder("Found setters marked with @JsonIgnore:");
            for (IgnoredSetter setter : setters) {
                builder.append(String.format("%n  - Setter for property [%s] should not be marked with @JsonIgnore on %s", setter.descriptor.getName(), setter.settersWithJsonIgnoreClassNames));
            }
            throw new IllegalArgumentException(builder.toString());
        }
    }

    private static void throwForMissingBeanMethod(Class<? extends PipelineOptions> iface, List<MissingBeanMethod> missingBeanMethods) {
        if (missingBeanMethods.size() == 1) {
            MissingBeanMethod missingBeanMethod = missingBeanMethods.get(0);
            throw new IllegalArgumentException(String.format("Expected %s for property [%s] of type [%s] on [%s].", missingBeanMethod.methodType, missingBeanMethod.property.getName(), missingBeanMethod.property.getPropertyType().getName(), iface.getName()));
        }
        if (missingBeanMethods.size() > 1) {
            StringBuilder builder = new StringBuilder(String.format("Found missing property methods on [%s]:", iface.getName()));
            for (MissingBeanMethod method : missingBeanMethods) {
                builder.append(String.format("%n  - Expected %s for property [%s] of type [%s]", method.methodType, method.property.getName(), method.property.getPropertyType().getName()));
            }
            throw new IllegalArgumentException(builder.toString());
        }
    }

    private static ListMultimap<String, String> parseCommandLine(String[] args, boolean strictParsing) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (String arg : args) {
            if (Strings.isNullOrEmpty(arg)) continue;
            try {
                Preconditions.checkArgument(arg.startsWith("--"), "Argument '%s' does not begin with '--'", arg);
                int index = arg.indexOf("=");
                Preconditions.checkArgument(index != 2, "Argument '%s' starts with '--=', empty argument name not allowed", arg);
                if (index > 0) {
                    builder.put(arg.substring(2, index), arg.substring(index + 1, arg.length()));
                    continue;
                }
                builder.put(arg.substring(2), "true");
            }
            catch (IllegalArgumentException e) {
                if (strictParsing) {
                    throw e;
                }
                LOG.warn("Strict parsing is disabled, ignoring option '{}' because {}", (Object)arg, (Object)e.getMessage());
            }
        }
        return builder.build();
    }

    private static <T extends PipelineOptions> Map<String, Object> parseObjects(Class<T> klass, ListMultimap<String, String> options, boolean strictParsing) {
        HashMap<String, Method> propertyNamesToGetters = Maps.newHashMap();
        PipelineOptionsFactory.validateWellFormed(klass, REGISTERED_OPTIONS);
        List<PropertyDescriptor> propertyDescriptors = PipelineOptionsFactory.getPropertyDescriptors(FluentIterable.from(PipelineOptionsFactory.getRegisteredOptions()).append(klass).toSet());
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            propertyNamesToGetters.put(descriptor.getName(), descriptor.getReadMethod());
        }
        HashMap<String, Object> convertedOptions = Maps.newHashMap();
        for (final Map.Entry<String, Collection<String>> entry : options.asMap().entrySet()) {
            try {
                String value;
                if (!propertyNamesToGetters.containsKey(entry.getKey())) {
                    TreeSet<String> closestMatches = new TreeSet<String>(Sets.filter(propertyNamesToGetters.keySet(), new Predicate<String>(){

                        @Override
                        public boolean apply(@Nullable String input) {
                            return StringUtils.getLevenshteinDistance((String)entry.getKey(), input) <= 2;
                        }
                    }));
                    switch (closestMatches.size()) {
                        case 0: {
                            throw new IllegalArgumentException(String.format("Class %s missing a property named '%s'.", klass, entry.getKey()));
                        }
                        case 1: {
                            throw new IllegalArgumentException(String.format("Class %s missing a property named '%s'. Did you mean '%s'?", klass, entry.getKey(), Iterables.getOnlyElement(closestMatches)));
                        }
                    }
                    throw new IllegalArgumentException(String.format("Class %s missing a property named '%s'. Did you mean one of %s?", klass, entry.getKey(), closestMatches));
                }
                Method method = (Method)propertyNamesToGetters.get(entry.getKey());
                Class<?> returnType = method.getReturnType();
                JavaType type = MAPPER.getTypeFactory().constructType(method.getGenericReturnType());
                if ("runner".equals(entry.getKey())) {
                    String runner = (String)Iterables.getOnlyElement((Iterable)entry.getValue());
                    if (SUPPORTED_PIPELINE_RUNNERS.containsKey(runner)) {
                        convertedOptions.put("runner", SUPPORTED_PIPELINE_RUNNERS.get(runner));
                        continue;
                    }
                    try {
                        Class<?> runnerClass = Class.forName(runner);
                        Preconditions.checkArgument(PipelineRunner.class.isAssignableFrom(runnerClass), "Class '%s' does not implement PipelineRunner. Supported pipeline runners %s", runner, Sets.newTreeSet(SUPPORTED_PIPELINE_RUNNERS.keySet()));
                        convertedOptions.put("runner", runnerClass);
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        String msg = String.format("Unknown 'runner' specified '%s', supported pipeline runners %s", runner, Sets.newTreeSet(SUPPORTED_PIPELINE_RUNNERS.keySet()));
                        throw new IllegalArgumentException(msg, e);
                    }
                }
                if (returnType.isArray() && (SIMPLE_TYPES.contains(returnType.getComponentType()) || returnType.getComponentType().isEnum()) || Collection.class.isAssignableFrom(returnType)) {
                    ImmutableList<String> values = FluentIterable.from(entry.getValue()).transformAndConcat(new Function<String, Iterable<String>>(){

                        @Override
                        public Iterable<String> apply(String input) {
                            return Arrays.asList(input.split(","));
                        }
                    }).toList();
                    if (returnType.isArray() && !returnType.getComponentType().equals(String.class)) {
                        for (String value2 : values) {
                            Preconditions.checkArgument(!value2.isEmpty(), "Empty argument value is only allowed for String, String Array, and Collection, but received: " + returnType);
                        }
                    }
                    convertedOptions.put(entry.getKey(), MAPPER.convertValue(values, type));
                    continue;
                }
                if (SIMPLE_TYPES.contains(returnType) || returnType.isEnum()) {
                    value = (String)Iterables.getOnlyElement((Iterable)entry.getValue());
                    Preconditions.checkArgument(returnType.equals(String.class) || !value.isEmpty(), "Empty argument value is only allowed for String, String Array, and Collection, but received: " + returnType);
                    convertedOptions.put(entry.getKey(), MAPPER.convertValue((Object)value, type));
                    continue;
                }
                value = (String)Iterables.getOnlyElement((Iterable)entry.getValue());
                Preconditions.checkArgument(returnType.equals(String.class) || !value.isEmpty(), "Empty argument value is only allowed for String, String Array, and Collection, but received: " + returnType);
                try {
                    convertedOptions.put(entry.getKey(), MAPPER.readValue(value, type));
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Unable to parse JSON value " + value, e);
                }
            }
            catch (IllegalArgumentException e) {
                if (strictParsing) {
                    throw e;
                }
                LOG.warn("Strict parsing is disabled, ignoring option '{}' with value '{}' because {}", new Object[]{entry.getKey(), entry.getValue(), e.getMessage()});
            }
        }
        return convertedOptions;
    }

    static /* synthetic */ String access$100() {
        return PipelineOptionsFactory.findCallersClassName();
    }

    static {
        PIPELINE_OPTIONS_FACTORY_CLASSES = ImmutableSet.of(PipelineOptionsFactory.class.getName(), Builder.class.getName());
        NOT_SYNTHETIC_PREDICATE = new Predicate<Method>(){

            @Override
            public boolean apply(Method input) {
                return !input.isSynthetic();
            }
        };
        REGISTERED_OPTIONS = Sets.newConcurrentHashSet();
        INTERFACE_CACHE = Maps.newConcurrentMap();
        COMBINED_CACHE = Maps.newConcurrentMap();
        try {
            IGNORED_METHODS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(Object.class.getMethod("getClass", new Class[0]))).add(Object.class.getMethod("wait", new Class[0]))).add(Object.class.getMethod("wait", Long.TYPE))).add(Object.class.getMethod("wait", Long.TYPE, Integer.TYPE))).add(Object.class.getMethod("notify", new Class[0]))).add(Object.class.getMethod("notifyAll", new Class[0]))).add(Proxy.class.getMethod("getInvocationHandler", Object.class))).build();
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.error("Unable to find expected method", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
        CLASS_LOADER = PipelineOptionsFactory.findClassLoader();
        ImmutableMap.Builder<String, Class<? extends PipelineRunner<?>>> builder = ImmutableMap.builder();
        TreeSet<Object> pipelineRunnerRegistrars = Sets.newTreeSet(ObjectsClassComparator.INSTANCE);
        pipelineRunnerRegistrars.addAll(Lists.newArrayList(ServiceLoader.load(PipelineRunnerRegistrar.class, CLASS_LOADER)));
        for (PipelineRunnerRegistrar pipelineRunnerRegistrar : pipelineRunnerRegistrars) {
            for (Class<PipelineRunner<?>> klass : pipelineRunnerRegistrar.getPipelineRunners()) {
                builder.put(klass.getSimpleName(), klass);
            }
        }
        SUPPORTED_PIPELINE_RUNNERS = builder.build();
        PipelineOptionsFactory.initializeRegistry();
    }

    static class JsonIgnorePredicate
    implements Predicate<Method> {
        static final JsonIgnorePredicate INSTANCE = new JsonIgnorePredicate();

        JsonIgnorePredicate() {
        }

        @Override
        public boolean apply(Method input) {
            return input.isAnnotationPresent(JsonIgnore.class);
        }
    }

    private static class MethodToDeclaringClassFunction
    implements Function<Method, Class<?>> {
        static final MethodToDeclaringClassFunction INSTANCE = new MethodToDeclaringClassFunction();

        private MethodToDeclaringClassFunction() {
        }

        @Override
        public Class<?> apply(Method input) {
            return input.getDeclaringClass();
        }
    }

    private static class ReturnTypeFetchingFunction
    implements Function<Method, Class<?>> {
        static final ReturnTypeFetchingFunction INSTANCE = new ReturnTypeFetchingFunction();

        private ReturnTypeFetchingFunction() {
        }

        @Override
        public Class<?> apply(Method input) {
            return input.getReturnType();
        }
    }

    static class MethodNameComparator
    implements Comparator<Method> {
        static final MethodNameComparator INSTANCE = new MethodNameComparator();

        MethodNameComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class MethodComparator
    implements Comparator<Method> {
        static final MethodComparator INSTANCE = new MethodComparator();

        private MethodComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            return o1.toGenericString().compareTo(o2.toGenericString());
        }
    }

    private static class ObjectsClassComparator
    implements Comparator<Object> {
        static final ObjectsClassComparator INSTANCE = new ObjectsClassComparator();

        private ObjectsClassComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return o1.getClass().getCanonicalName().compareTo(o2.getClass().getCanonicalName());
        }
    }

    private static class ClassNameComparator
    implements Comparator<Class<?>> {
        static final ClassNameComparator INSTANCE = new ClassNameComparator();

        private ClassNameComparator() {
        }

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class MissingBeanMethod {
        String methodType;
        PropertyDescriptor property;

        private MissingBeanMethod() {
        }
    }

    private static class IgnoredSetter {
        PropertyDescriptor descriptor;
        Iterable<String> settersWithJsonIgnoreClassNames;

        private IgnoredSetter() {
        }
    }

    private static class InconsistentlyIgnoredGetters {
        PropertyDescriptor descriptor;
        Iterable<String> getterClassNames;
        Iterable<String> gettersWithJsonIgnoreClassNames;

        private InconsistentlyIgnoredGetters() {
        }
    }

    private static class MultipleDefinitions {
        private Method method;
        private SortedSet<Method> collidingMethods;

        private MultipleDefinitions() {
        }
    }

    private static class TypeMismatch {
        private String propertyName;
        private Class<?> getterPropertyType;
        private Class<?> setterPropertyType;

        private TypeMismatch() {
        }
    }

    static class Registration<T extends PipelineOptions> {
        private final Class<T> proxyClass;
        private final List<PropertyDescriptor> propertyDescriptors;

        public Registration(Class<T> proxyClass, List<PropertyDescriptor> beanInfo) {
            this.proxyClass = proxyClass;
            this.propertyDescriptors = beanInfo;
        }

        List<PropertyDescriptor> getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        Class<T> getProxyClass() {
            return this.proxyClass;
        }
    }

    public static class Builder {
        private final String defaultAppName = PipelineOptionsFactory.access$100();
        private final String[] args;
        private final boolean validation;
        private final boolean strictParsing;

        private Builder() {
            this(null, false, true);
        }

        private Builder(String[] args, boolean validation, boolean strictParsing) {
            this.args = args;
            this.validation = validation;
            this.strictParsing = strictParsing;
        }

        public Builder fromArgs(String[] args) {
            Preconditions.checkNotNull(args, "Arguments should not be null.");
            return new Builder(args, this.validation, this.strictParsing);
        }

        public Builder withValidation() {
            return new Builder(this.args, true, this.strictParsing);
        }

        public Builder withoutStrictParsing() {
            return new Builder(this.args, this.validation, false);
        }

        public PipelineOptions create() {
            return this.as(PipelineOptions.class);
        }

        public <T extends PipelineOptions> T as(Class<T> klass) {
            ProxyInvocationHandler handler;
            ApplicationNameOptions t;
            ApplicationNameOptions appNameOptions;
            Map<String, Object> initialOptions = Maps.newHashMap();
            if (this.args != null) {
                ListMultimap options = PipelineOptionsFactory.parseCommandLine(this.args, this.strictParsing);
                LOG.debug("Provided Arguments: {}", (Object)options);
                PipelineOptionsFactory.printHelpUsageAndExitIfNeeded(options, System.out, true);
                initialOptions = PipelineOptionsFactory.parseObjects(klass, options, this.strictParsing);
            }
            if ((appNameOptions = (t = (handler = new ProxyInvocationHandler(initialOptions)).as(klass)).as(ApplicationNameOptions.class)).getAppName() == null) {
                appNameOptions.setAppName(this.defaultAppName);
            }
            if (this.validation) {
                PipelineOptionsValidator.validate(klass, t);
            }
            return (T)t;
        }
    }
}

