/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.cloud.dataflow.sdk.options.ApplicationNameOptions;
import com.google.cloud.dataflow.sdk.options.Default;
import com.google.cloud.dataflow.sdk.options.DefaultValueFactory;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.GcpOptions;
import com.google.cloud.dataflow.sdk.options.Hidden;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.dataflow.sdk.util.AppEngineEnvironment;
import com.google.cloud.dataflow.sdk.util.GcsUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public interface GcsOptions
extends ApplicationNameOptions,
GcpOptions,
PipelineOptions {
    @JsonIgnore
    @Description(value="The GcsUtil instance that should be used to communicate with Google Cloud Storage.")
    @Default.InstanceFactory(value=GcsUtil.GcsUtilFactory.class)
    @Hidden
    public GcsUtil getGcsUtil();

    public void setGcsUtil(GcsUtil var1);

    @JsonIgnore
    @Description(value="The ExecutorService instance to use to create multiple threads. Can be overridden to specify an ExecutorService that is compatible with the users environment. If unset, the default is to create an ExecutorService with an unbounded number of threads; this is compatible with Google AppEngine.")
    @Default.InstanceFactory(value=ExecutorServiceFactory.class)
    @Hidden
    public ExecutorService getExecutorService();

    public void setExecutorService(ExecutorService var1);

    @JsonIgnore
    @Hidden
    @Description(value="The URL for the GCS API.")
    public String getGcsEndpoint();

    public void setGcsEndpoint(String var1);

    @Description(value="The buffer size (in bytes) to use when uploading files to GCS. Please see the documentation for AbstractGoogleAsyncWriteChannel.setUploadBufferSize for more information on the restrictions and performance implications of this value.\n\nhttps://github.com/GoogleCloudPlatform/bigdata-interop/blob/master/util/src/main/java/com/google/cloud/hadoop/util/AbstractGoogleAsyncWriteChannel.java")
    public Integer getGcsUploadBufferSizeBytes();

    public void setGcsUploadBufferSizeBytes(Integer var1);

    public static class ExecutorServiceFactory
    implements DefaultValueFactory<ExecutorService> {
        @Override
        public ExecutorService create(PipelineOptions options) {
            ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder();
            threadFactoryBuilder.setThreadFactory(MoreExecutors.platformThreadFactory());
            if (!AppEngineEnvironment.IS_APP_ENGINE) {
                threadFactoryBuilder.setDaemon(true);
            }
            return new ThreadPoolExecutor(0, Integer.MAX_VALUE, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new SynchronousQueue<Runnable>(), threadFactoryBuilder.build());
        }
    }
}

