/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.options;

import com.google.cloud.dataflow.sdk.options.ApplicationNameOptions;
import com.google.cloud.dataflow.sdk.options.BigQueryOptions;
import com.google.cloud.dataflow.sdk.options.CloudDebuggerOptions;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineDebugOptions;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineWorkerPoolOptions;
import com.google.cloud.dataflow.sdk.options.DataflowProfilingOptions;
import com.google.cloud.dataflow.sdk.options.DataflowWorkerLoggingOptions;
import com.google.cloud.dataflow.sdk.options.Default;
import com.google.cloud.dataflow.sdk.options.DefaultValueFactory;
import com.google.cloud.dataflow.sdk.options.Description;
import com.google.cloud.dataflow.sdk.options.GcpOptions;
import com.google.cloud.dataflow.sdk.options.GcsOptions;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.options.StreamingOptions;
import com.google.cloud.dataflow.sdk.options.Validation;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Description(value="Options that configure the Dataflow pipeline.")
public interface DataflowPipelineOptions
extends PipelineOptions,
GcpOptions,
ApplicationNameOptions,
DataflowPipelineDebugOptions,
DataflowPipelineWorkerPoolOptions,
BigQueryOptions,
GcsOptions,
StreamingOptions,
CloudDebuggerOptions,
DataflowWorkerLoggingOptions,
DataflowProfilingOptions {
    @Override
    @Description(value="Project id. Required when running a Dataflow in the cloud. See https://cloud.google.com/storage/docs/projects for further details.")
    @Validation.Required
    @Default.InstanceFactory(value=GcpOptions.DefaultProjectFactory.class)
    public String getProject();

    @Override
    public void setProject(String var1);

    @Description(value="GCS path for staging local files, e.g. \"gs://bucket/object\". Must be a valid Cloud Storage URL, beginning with the prefix \"gs://\". At least one of stagingLocation or tempLocation must be set. If stagingLocation is unset, defaults to using tempLocation.")
    public String getStagingLocation();

    public void setStagingLocation(String var1);

    @Description(value="The Dataflow job name is used as an idempotence key within the Dataflow service. For each running job in the same GCP project, jobs with the same name cannot be created unless the new job is an explicit update of the previous one. Defaults to using ApplicationName-UserName-Date. The job name must match the regular expression '[a-z]([-a-z0-9]{0,38}[a-z0-9])?'. The runner will automatically truncate the name of the job and convert to lower case.")
    @Default.InstanceFactory(value=JobNameFactory.class)
    public String getJobName();

    public void setJobName(String var1);

    @Override
    @Description(value="If set, replace the existing pipeline with the name specified by --jobName with this pipeline, preserving state.")
    public boolean getUpdate();

    @Override
    public void setUpdate(boolean var1);

    public static class JobNameFactory
    implements DefaultValueFactory<String> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormat.forPattern((String)"MMddHHmmss").withZone(DateTimeZone.UTC);

        @Override
        public String create(PipelineOptions options) {
            String appName = options.as(ApplicationNameOptions.class).getAppName();
            String normalizedAppName = appName == null || appName.length() == 0 ? "dataflow" : appName.toLowerCase().replaceAll("[^a-z0-9]", "0").replaceAll("^[^a-z]", "a");
            String userName = MoreObjects.firstNonNull(System.getProperty("user.name"), "");
            String normalizedUserName = userName.toLowerCase().replaceAll("[^a-z0-9]", "0");
            String datePart = FORMATTER.print(DateTimeUtils.currentTimeMillis());
            return normalizedAppName + "-" + normalizedUserName + "-" + datePart;
        }
    }
}

