/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.StringUtf8Coder;
import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.io.CompressedSource;
import com.google.cloud.dataflow.sdk.io.FileBasedSink;
import com.google.cloud.dataflow.sdk.io.FileBasedSource;
import com.google.cloud.dataflow.sdk.io.Read;
import com.google.cloud.dataflow.sdk.io.Write;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.util.IOChannelUtils;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PDone;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class TextIO {
    public static final Coder<String> DEFAULT_TEXT_CODER = StringUtf8Coder.of();
    private static final Pattern SHARD_OUTPUT_PATTERN = Pattern.compile("@([0-9]+|\\*)");

    private static void validateOutputComponent(String partialFilePattern) {
        Preconditions.checkArgument(!SHARD_OUTPUT_PATTERN.matcher(partialFilePattern).find(), "Output name components are not allowed to contain @* or @N patterns: " + partialFilePattern);
    }

    private TextIO() {
    }

    @VisibleForTesting
    static class TextSink<T>
    extends FileBasedSink<T> {
        private final Coder<T> coder;
        @Nullable
        private final String header;
        @Nullable
        private final String footer;

        @VisibleForTesting
        TextSink(String baseOutputFilename, String extension, @Nullable String header, @Nullable String footer, String fileNameTemplate, Coder<T> coder) {
            super(baseOutputFilename, extension, fileNameTemplate);
            this.coder = coder;
            this.header = header;
            this.footer = footer;
        }

        @Override
        public FileBasedSink.FileBasedWriteOperation<T> createWriteOperation(PipelineOptions options) {
            return new TextWriteOperation(this, this.coder, this.header, this.footer);
        }

        private static class TextWriter<T>
        extends FileBasedSink.FileBasedWriter<T> {
            private static final byte[] NEWLINE = "\n".getBytes(StandardCharsets.UTF_8);
            private final Coder<T> coder;
            @Nullable
            private final String header;
            @Nullable
            private final String footer;
            private OutputStream out;

            public TextWriter(FileBasedSink.FileBasedWriteOperation<T> writeOperation, Coder<T> coder, @Nullable String header, @Nullable String footer) {
                super(writeOperation);
                this.header = header;
                this.footer = footer;
                this.mimeType = "text/plain";
                this.coder = coder;
            }

            private void writeIfNotNull(@Nullable String value) throws IOException {
                if (value != null) {
                    this.out.write(value.getBytes(StandardCharsets.UTF_8));
                    this.out.write(NEWLINE);
                }
            }

            @Override
            protected void prepareWrite(WritableByteChannel channel) throws Exception {
                this.out = Channels.newOutputStream(channel);
            }

            @Override
            protected void writeHeader() throws Exception {
                this.writeIfNotNull(this.header);
            }

            @Override
            protected void writeFooter() throws Exception {
                this.writeIfNotNull(this.footer);
            }

            @Override
            public void write(T value) throws Exception {
                this.coder.encode(value, this.out, Coder.Context.OUTER);
                this.out.write(NEWLINE);
            }
        }

        private static class TextWriteOperation<T>
        extends FileBasedSink.FileBasedWriteOperation<T> {
            private final Coder<T> coder;
            @Nullable
            private final String header;
            @Nullable
            private final String footer;

            private TextWriteOperation(TextSink<T> sink, Coder<T> coder, @Nullable String header, @Nullable String footer) {
                super(sink);
                this.coder = coder;
                this.header = header;
                this.footer = footer;
            }

            @Override
            public FileBasedSink.FileBasedWriter<T> createWriter(PipelineOptions options) throws Exception {
                return new TextWriter<T>(this, this.coder, this.header, this.footer);
            }
        }
    }

    @VisibleForTesting
    static class TextSource<T>
    extends FileBasedSource<T> {
        private final Coder<T> coder;

        @VisibleForTesting
        TextSource(String fileSpec, Coder<T> coder) {
            super(fileSpec, 1L);
            this.coder = coder;
        }

        private TextSource(String fileName, long start, long end, Coder<T> coder) {
            super(fileName, 1L, start, end);
            this.coder = coder;
        }

        @Override
        protected FileBasedSource<T> createForSubrangeOfFile(String fileName, long start, long end) {
            return new TextSource<T>(fileName, start, end, this.coder);
        }

        @Override
        protected FileBasedSource.FileBasedReader<T> createSingleFileReader(PipelineOptions options) {
            return new TextBasedReader(this);
        }

        @Override
        public boolean producesSortedKeys(PipelineOptions options) throws Exception {
            return false;
        }

        @Override
        public Coder<T> getDefaultOutputCoder() {
            return this.coder;
        }

        @VisibleForTesting
        static class TextBasedReader<T>
        extends FileBasedSource.FileBasedReader<T> {
            private static final int READ_BUFFER_SIZE = 8192;
            private final Coder<T> coder;
            private final ByteBuffer readBuffer = ByteBuffer.allocate(8192);
            private ByteString buffer;
            private int startOfSeparatorInBuffer;
            private int endOfSeparatorInBuffer;
            private long startOfRecord;
            private volatile long startOfNextRecord;
            private volatile boolean eof;
            private volatile boolean elementIsPresent;
            private T currentValue;
            private ReadableByteChannel inChannel;

            private TextBasedReader(TextSource<T> source) {
                super(source);
                this.coder = ((TextSource)source).coder;
                this.buffer = ByteString.EMPTY;
            }

            @Override
            protected long getCurrentOffset() throws NoSuchElementException {
                if (!this.elementIsPresent) {
                    throw new NoSuchElementException();
                }
                return this.startOfRecord;
            }

            @Override
            public long getSplitPointsRemaining() {
                if (this.isStarted() && this.startOfNextRecord >= this.getCurrentSource().getEndOffset()) {
                    return this.isDone() ? 0L : 1L;
                }
                return super.getSplitPointsRemaining();
            }

            @Override
            public T getCurrent() throws NoSuchElementException {
                if (!this.elementIsPresent) {
                    throw new NoSuchElementException();
                }
                return this.currentValue;
            }

            @Override
            protected void startReading(ReadableByteChannel channel) throws IOException {
                this.inChannel = channel;
                if (this.getCurrentSource().getStartOffset() > 0L) {
                    Preconditions.checkState(channel instanceof SeekableByteChannel, "%s only supports reading from a SeekableByteChannel when given a start offset greater than 0.", TextSource.class.getSimpleName());
                    long requiredPosition = this.getCurrentSource().getStartOffset() - 1L;
                    ((SeekableByteChannel)channel).position(requiredPosition);
                    this.findSeparatorBounds();
                    this.buffer = this.buffer.substring(this.endOfSeparatorInBuffer);
                    this.startOfNextRecord = requiredPosition + (long)this.endOfSeparatorInBuffer;
                    this.endOfSeparatorInBuffer = 0;
                    this.startOfSeparatorInBuffer = 0;
                }
            }

            private void findSeparatorBounds() throws IOException {
                int bytePositionInBuffer = 0;
                while (true) {
                    if (!this.tryToEnsureNumberOfBytesInBuffer(bytePositionInBuffer + 1)) {
                        this.startOfSeparatorInBuffer = this.endOfSeparatorInBuffer = bytePositionInBuffer;
                        break;
                    }
                    byte currentByte = this.buffer.byteAt(bytePositionInBuffer);
                    if (currentByte == 10) {
                        this.startOfSeparatorInBuffer = bytePositionInBuffer;
                        this.endOfSeparatorInBuffer = this.startOfSeparatorInBuffer + 1;
                        break;
                    }
                    if (currentByte == 13) {
                        this.startOfSeparatorInBuffer = bytePositionInBuffer;
                        this.endOfSeparatorInBuffer = this.startOfSeparatorInBuffer + 1;
                        if (!this.tryToEnsureNumberOfBytesInBuffer(bytePositionInBuffer + 2) || (currentByte = this.buffer.byteAt(bytePositionInBuffer + 1)) != 10) break;
                        ++this.endOfSeparatorInBuffer;
                        break;
                    }
                    ++bytePositionInBuffer;
                }
            }

            @Override
            protected boolean readNextRecord() throws IOException {
                this.startOfRecord = this.startOfNextRecord;
                this.findSeparatorBounds();
                if (this.eof && this.buffer.size() == 0) {
                    this.elementIsPresent = false;
                    return false;
                }
                this.decodeCurrentElement();
                this.startOfNextRecord = this.startOfRecord + (long)this.endOfSeparatorInBuffer;
                return true;
            }

            private void decodeCurrentElement() throws IOException {
                ByteString dataToDecode = this.buffer.substring(0, this.startOfSeparatorInBuffer);
                this.currentValue = this.coder.decode(dataToDecode.newInput(), Coder.Context.OUTER);
                this.elementIsPresent = true;
                this.buffer = this.buffer.substring(this.endOfSeparatorInBuffer);
            }

            private boolean tryToEnsureNumberOfBytesInBuffer(int minCapacity) throws IOException {
                while (this.buffer.size() <= minCapacity && !this.eof) {
                    this.eof = this.inChannel.read(this.readBuffer) == -1;
                    this.readBuffer.flip();
                    this.buffer = this.buffer.concat(ByteString.copyFrom((ByteBuffer)this.readBuffer));
                    this.readBuffer.clear();
                }
                return this.buffer.size() >= minCapacity;
            }
        }
    }

    public static enum CompressionType {
        AUTO(""),
        UNCOMPRESSED(""),
        GZIP(".gz"),
        BZIP2(".bz2");

        private String filenameSuffix;

        private CompressionType(String suffix) {
            this.filenameSuffix = suffix;
        }

        public boolean matches(String filename) {
            return filename.toLowerCase().endsWith(this.filenameSuffix.toLowerCase());
        }
    }

    public static class Write {
        public static Bound<String> named(String name) {
            return new Bound<String>(DEFAULT_TEXT_CODER).named(name);
        }

        public static Bound<String> to(String prefix) {
            return new Bound<String>(DEFAULT_TEXT_CODER).to(prefix);
        }

        public static Bound<String> withSuffix(String nameExtension) {
            return new Bound<String>(DEFAULT_TEXT_CODER).withSuffix(nameExtension);
        }

        public static Bound<String> withNumShards(int numShards) {
            return new Bound<String>(DEFAULT_TEXT_CODER).withNumShards(numShards);
        }

        public static Bound<String> withShardNameTemplate(String shardTemplate) {
            return new Bound<String>(DEFAULT_TEXT_CODER).withShardNameTemplate(shardTemplate);
        }

        public static Bound<String> withoutSharding() {
            return new Bound<String>(DEFAULT_TEXT_CODER).withoutSharding();
        }

        public static <T> Bound<T> withCoder(Coder<T> coder) {
            return new Bound<T>(coder);
        }

        public static Bound<String> withoutValidation() {
            return new Bound<String>(DEFAULT_TEXT_CODER).withoutValidation();
        }

        public static Bound<String> withHeader(@Nullable String header) {
            return new Bound<String>(DEFAULT_TEXT_CODER).withHeader(header);
        }

        public static Bound<String> withFooter(@Nullable String footer) {
            return new Bound<String>(DEFAULT_TEXT_CODER).withFooter(footer);
        }

        public static class Bound<T>
        extends PTransform<PCollection<T>, PDone> {
            private static final String DEFAULT_SHARD_TEMPLATE = "-SSSSS-of-NNNNN";
            @Nullable
            private final String filenamePrefix;
            private final String filenameSuffix;
            @Nullable
            private final String header;
            @Nullable
            private final String footer;
            private final Coder<T> coder;
            private final int numShards;
            private final String shardTemplate;
            private final boolean validate;

            Bound(Coder<T> coder) {
                this(null, null, "", null, null, coder, 0, DEFAULT_SHARD_TEMPLATE, true);
            }

            private Bound(String name, String filenamePrefix, String filenameSuffix, @Nullable String header, @Nullable String footer, Coder<T> coder, int numShards, String shardTemplate, boolean validate) {
                super(name);
                this.header = header;
                this.footer = footer;
                this.coder = coder;
                this.filenamePrefix = filenamePrefix;
                this.filenameSuffix = filenameSuffix;
                this.numShards = numShards;
                this.shardTemplate = shardTemplate;
                this.validate = validate;
            }

            public Bound<T> named(String name) {
                return new Bound<T>(name, this.filenamePrefix, this.filenameSuffix, this.header, this.footer, this.coder, this.numShards, this.shardTemplate, this.validate);
            }

            public Bound<T> to(String filenamePrefix) {
                TextIO.validateOutputComponent(filenamePrefix);
                return new Bound<T>(this.name, filenamePrefix, this.filenameSuffix, this.header, this.footer, this.coder, this.numShards, this.shardTemplate, this.validate);
            }

            public Bound<T> withSuffix(String nameExtension) {
                TextIO.validateOutputComponent(nameExtension);
                return new Bound<T>(this.name, this.filenamePrefix, nameExtension, this.header, this.footer, this.coder, this.numShards, this.shardTemplate, this.validate);
            }

            public Bound<T> withNumShards(int numShards) {
                Preconditions.checkArgument(numShards >= 0);
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.header, this.footer, this.coder, numShards, this.shardTemplate, this.validate);
            }

            public Bound<T> withShardNameTemplate(String shardTemplate) {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.header, this.footer, this.coder, this.numShards, shardTemplate, this.validate);
            }

            public Bound<T> withoutSharding() {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.header, this.footer, this.coder, 1, "", this.validate);
            }

            public <X> Bound<X> withCoder(Coder<X> coder) {
                return new Bound<X>(this.name, this.filenamePrefix, this.filenameSuffix, this.header, this.footer, coder, this.numShards, this.shardTemplate, this.validate);
            }

            public Bound<T> withHeader(@Nullable String header) {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, header, this.footer, this.coder, this.numShards, this.shardTemplate, false);
            }

            public Bound<T> withFooter(@Nullable String footer) {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.header, footer, this.coder, this.numShards, this.shardTemplate, false);
            }

            public Bound<T> withoutValidation() {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.header, this.footer, this.coder, this.numShards, this.shardTemplate, false);
            }

            @Override
            public PDone apply(PCollection<T> input) {
                if (this.filenamePrefix == null) {
                    throw new IllegalStateException("need to set the filename prefix of a TextIO.Write transform");
                }
                Write.Bound<T> write = com.google.cloud.dataflow.sdk.io.Write.to(new TextSink<T>(this.filenamePrefix, this.filenameSuffix, this.header, this.footer, this.shardTemplate, this.coder));
                if (this.getNumShards() > 0) {
                    write = write.withNumShards(this.getNumShards());
                }
                return (PDone)input.apply("Write", write);
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.addIfNotNull(DisplayData.item("filePrefix", this.filenamePrefix).withLabel("Output File Prefix")).addIfNotDefault(DisplayData.item("fileSuffix", this.filenameSuffix).withLabel("Output Fix Suffix"), "").addIfNotDefault(DisplayData.item("shardNameTemplate", this.shardTemplate).withLabel("Output Shard Name Template"), DEFAULT_SHARD_TEMPLATE).addIfNotDefault(DisplayData.item("validation", this.validate).withLabel("Validation Enabled"), true).addIfNotDefault(DisplayData.item("numShards", this.numShards).withLabel("Maximum Output Shards"), 0).addIfNotNull(DisplayData.item("fileHeader", this.header).withLabel("File Header")).addIfNotNull(DisplayData.item("fileFooter", this.footer).withLabel("File Footer"));
            }

            public String getShardNameTemplate() {
                return this.shardTemplate;
            }

            @Override
            protected Coder<Void> getDefaultOutputCoder() {
                return VoidCoder.of();
            }

            public String getFilenamePrefix() {
                return this.filenamePrefix;
            }

            public String getShardTemplate() {
                return this.shardTemplate;
            }

            public int getNumShards() {
                return this.numShards;
            }

            public String getFilenameSuffix() {
                return this.filenameSuffix;
            }

            public Coder<T> getCoder() {
                return this.coder;
            }

            @Nullable
            public String getHeader() {
                return this.header;
            }

            @Nullable
            public String getFooter() {
                return this.footer;
            }

            public boolean needsValidation() {
                return this.validate;
            }
        }
    }

    public static class Read {
        public static Bound<String> named(String name) {
            return new Bound<String>(DEFAULT_TEXT_CODER).named(name);
        }

        public static Bound<String> from(String filepattern) {
            return new Bound<String>(DEFAULT_TEXT_CODER).from(filepattern);
        }

        public static <T> Bound<T> withCoder(Coder<T> coder) {
            return new Bound<T>(coder);
        }

        public static Bound<String> withoutValidation() {
            return new Bound<String>(DEFAULT_TEXT_CODER).withoutValidation();
        }

        public static Bound<String> withCompressionType(CompressionType compressionType) {
            return new Bound<String>(DEFAULT_TEXT_CODER).withCompressionType(compressionType);
        }

        private Read() {
        }

        public static class Bound<T>
        extends PTransform<PInput, PCollection<T>> {
            @Nullable
            private final String filepattern;
            private final Coder<T> coder;
            private final boolean validate;
            private final CompressionType compressionType;

            Bound(Coder<T> coder) {
                this(null, null, coder, true, CompressionType.AUTO);
            }

            private Bound(String name, String filepattern, Coder<T> coder, boolean validate, CompressionType compressionType) {
                super(name);
                this.coder = coder;
                this.filepattern = filepattern;
                this.validate = validate;
                this.compressionType = compressionType;
            }

            public Bound<T> named(String name) {
                return new Bound<T>(name, this.filepattern, this.coder, this.validate, this.compressionType);
            }

            public Bound<T> from(String filepattern) {
                return new Bound<T>(this.name, filepattern, this.coder, this.validate, this.compressionType);
            }

            public <X> Bound<X> withCoder(Coder<X> coder) {
                return new Bound<X>(this.name, this.filepattern, coder, this.validate, this.compressionType);
            }

            public Bound<T> withoutValidation() {
                return new Bound<T>(this.name, this.filepattern, this.coder, false, this.compressionType);
            }

            public Bound<T> withCompressionType(CompressionType compressionType) {
                return new Bound<T>(this.name, this.filepattern, this.coder, this.validate, compressionType);
            }

            @Override
            public PCollection<T> apply(PInput input) {
                Read.Bounded<T> read;
                if (this.filepattern == null) {
                    throw new IllegalStateException("need to set the filepattern of a TextIO.Read transform");
                }
                if (this.validate) {
                    try {
                        Preconditions.checkState(!IOChannelUtils.getFactory(this.filepattern).match(this.filepattern).isEmpty(), "Unable to find any files matching %s", this.filepattern);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("Failed to validate %s", this.filepattern), e);
                    }
                }
                switch (this.compressionType) {
                    case UNCOMPRESSED: {
                        read = com.google.cloud.dataflow.sdk.io.Read.from(new TextSource<T>(this.filepattern, this.coder));
                        break;
                    }
                    case AUTO: {
                        read = com.google.cloud.dataflow.sdk.io.Read.from(CompressedSource.from(new TextSource<T>(this.filepattern, this.coder)));
                        break;
                    }
                    case BZIP2: {
                        read = com.google.cloud.dataflow.sdk.io.Read.from(CompressedSource.from(new TextSource<T>(this.filepattern, this.coder)).withDecompression(CompressedSource.CompressionMode.BZIP2));
                        break;
                    }
                    case GZIP: {
                        read = com.google.cloud.dataflow.sdk.io.Read.from(CompressedSource.from(new TextSource<T>(this.filepattern, this.coder)).withDecompression(CompressedSource.CompressionMode.GZIP));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown compression mode: " + (Object)((Object)this.compressionType));
                    }
                }
                PCollection pcol = (PCollection)input.getPipeline().apply("Read", read);
                pcol.setCoder((Coder)this.getDefaultOutputCoder());
                return pcol;
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.add(DisplayData.item("compressionType", this.compressionType.toString()).withLabel("Compression Type")).addIfNotDefault(DisplayData.item("validation", this.validate).withLabel("Validation Enabled"), true).addIfNotNull(DisplayData.item("filePattern", this.filepattern).withLabel("File Pattern"));
            }

            @Override
            protected Coder<T> getDefaultOutputCoder() {
                return this.coder;
            }

            public String getFilepattern() {
                return this.filepattern;
            }

            public boolean needsValidation() {
                return this.validate;
            }

            public CompressionType getCompressionType() {
                return this.compressionType;
            }
        }
    }
}

