/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.io.FileBasedSource;
import com.google.cloud.dataflow.sdk.io.OffsetBasedSource;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public abstract class BlockBasedSource<T>
extends FileBasedSource<T> {
    public BlockBasedSource(String fileOrPatternSpec, long minBundleSize) {
        super(fileOrPatternSpec, minBundleSize);
    }

    public BlockBasedSource(String fileName, long minBundleSize, long startOffset, long endOffset) {
        super(fileName, minBundleSize, startOffset, endOffset);
    }

    @Override
    protected abstract BlockBasedSource<T> createForSubrangeOfFile(String var1, long var2, long var4);

    @Override
    protected abstract BlockBasedReader<T> createSingleFileReader(PipelineOptions var1);

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    protected static abstract class BlockBasedReader<T>
    extends FileBasedSource.FileBasedReader<T> {
        private boolean atSplitPoint;

        protected BlockBasedReader(BlockBasedSource<T> source) {
            super(source);
        }

        public abstract boolean readNextBlock() throws IOException;

        @Nullable
        public abstract Block<T> getCurrentBlock();

        public abstract long getCurrentBlockSize();

        public abstract long getCurrentBlockOffset();

        @Override
        public final T getCurrent() throws NoSuchElementException {
            Block<T> currentBlock = this.getCurrentBlock();
            if (currentBlock == null) {
                throw new NoSuchElementException("No block has been successfully read from " + this.getCurrentSource());
            }
            return currentBlock.getCurrentRecord();
        }

        @Override
        protected boolean isAtSplitPoint() {
            return this.atSplitPoint;
        }

        @Override
        protected final boolean readNextRecord() throws IOException {
            this.atSplitPoint = false;
            while (this.getCurrentBlock() == null || !this.getCurrentBlock().readNextRecord()) {
                if (!this.readNextBlock()) {
                    return false;
                }
                this.atSplitPoint = true;
            }
            return true;
        }

        @Override
        @Nullable
        public Double getFractionConsumed() {
            if (!this.isStarted()) {
                return 0.0;
            }
            if (this.isDone()) {
                return 1.0;
            }
            OffsetBasedSource source = this.getCurrentSource();
            if (source.getEndOffset() == Long.MAX_VALUE) {
                return null;
            }
            long currentBlockOffset = this.getCurrentBlockOffset();
            long startOffset = source.getStartOffset();
            long endOffset = source.getEndOffset();
            double fractionAtBlockStart = (double)(currentBlockOffset - startOffset) / (double)(endOffset - startOffset);
            double fractionAtBlockEnd = (double)(currentBlockOffset + this.getCurrentBlockSize() - startOffset) / (double)(endOffset - startOffset);
            double blockFraction = this.getCurrentBlock().getFractionOfBlockConsumed();
            return Math.min(1.0, fractionAtBlockStart + blockFraction * (fractionAtBlockEnd - fractionAtBlockStart));
        }

        @Override
        protected long getCurrentOffset() {
            return this.getCurrentBlockOffset();
        }
    }

    @Experimental(value=Experimental.Kind.SOURCE_SINK)
    protected static abstract class Block<T> {
        protected Block() {
        }

        public abstract T getCurrentRecord();

        public abstract boolean readNextRecord() throws IOException;

        public abstract double getFractionOfBlockConsumed();
    }
}

