/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.io;

import com.google.cloud.dataflow.sdk.coders.AvroCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.VoidCoder;
import com.google.cloud.dataflow.sdk.io.AvroSource;
import com.google.cloud.dataflow.sdk.io.FileBasedSink;
import com.google.cloud.dataflow.sdk.io.Read;
import com.google.cloud.dataflow.sdk.io.Write;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.display.DisplayData;
import com.google.cloud.dataflow.sdk.util.IOChannelUtils;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PDone;
import com.google.cloud.dataflow.sdk.values.PInput;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.ReflectData;

public class AvroIO {
    private static final Pattern SHARD_OUTPUT_PATTERN = Pattern.compile("@([0-9]+|\\*)");

    private static void validateOutputComponent(String partialFilePattern) {
        Preconditions.checkArgument(!SHARD_OUTPUT_PATTERN.matcher(partialFilePattern).find(), "Output name components are not allowed to contain @* or @N patterns: " + partialFilePattern);
    }

    private AvroIO() {
    }

    @VisibleForTesting
    static class AvroSink<T>
    extends FileBasedSink<T> {
        private final AvroCoder<T> coder;

        @VisibleForTesting
        AvroSink(String baseOutputFilename, String extension, String fileNameTemplate, AvroCoder<T> coder) {
            super(baseOutputFilename, extension, fileNameTemplate);
            this.coder = coder;
        }

        @Override
        public FileBasedSink.FileBasedWriteOperation<T> createWriteOperation(PipelineOptions options) {
            return new AvroWriteOperation(this, this.coder);
        }

        private static class AvroWriter<T>
        extends FileBasedSink.FileBasedWriter<T> {
            private final AvroCoder<T> coder;
            private DataFileWriter<T> dataFileWriter;

            public AvroWriter(FileBasedSink.FileBasedWriteOperation<T> writeOperation, AvroCoder<T> coder) {
                super(writeOperation);
                this.mimeType = "application/octet-stream";
                this.coder = coder;
            }

            @Override
            protected void prepareWrite(WritableByteChannel channel) throws Exception {
                this.dataFileWriter = new DataFileWriter(this.coder.createDatumWriter());
                this.dataFileWriter.create(this.coder.getSchema(), Channels.newOutputStream(channel));
            }

            @Override
            public void write(T value) throws Exception {
                this.dataFileWriter.append(value);
            }

            @Override
            protected void writeFooter() throws Exception {
                this.dataFileWriter.flush();
            }
        }

        private static class AvroWriteOperation<T>
        extends FileBasedSink.FileBasedWriteOperation<T> {
            private final AvroCoder<T> coder;

            private AvroWriteOperation(AvroSink<T> sink, AvroCoder<T> coder) {
                super(sink);
                this.coder = coder;
            }

            @Override
            public FileBasedSink.FileBasedWriter<T> createWriter(PipelineOptions options) throws Exception {
                return new AvroWriter<T>(this, this.coder);
            }
        }
    }

    public static class Write {
        public static Bound<GenericRecord> named(String name) {
            return new Bound<GenericRecord>(GenericRecord.class).named(name);
        }

        public static Bound<GenericRecord> to(String prefix) {
            return new Bound<GenericRecord>(GenericRecord.class).to(prefix);
        }

        public static Bound<GenericRecord> withSuffix(String filenameSuffix) {
            return new Bound<GenericRecord>(GenericRecord.class).withSuffix(filenameSuffix);
        }

        public static Bound<GenericRecord> withNumShards(int numShards) {
            return new Bound<GenericRecord>(GenericRecord.class).withNumShards(numShards);
        }

        public static Bound<GenericRecord> withShardNameTemplate(String shardTemplate) {
            return new Bound<GenericRecord>(GenericRecord.class).withShardNameTemplate(shardTemplate);
        }

        public static Bound<GenericRecord> withoutSharding() {
            return new Bound<GenericRecord>(GenericRecord.class).withoutSharding();
        }

        public static <T> Bound<T> withSchema(Class<T> type) {
            return new Bound<T>(type).withSchema(type);
        }

        public static Bound<GenericRecord> withSchema(Schema schema) {
            return new Bound<GenericRecord>(GenericRecord.class).withSchema(schema);
        }

        public static Bound<GenericRecord> withSchema(String schema) {
            return Write.withSchema(new Schema.Parser().parse(schema));
        }

        public static Bound<GenericRecord> withoutValidation() {
            return new Bound<GenericRecord>(GenericRecord.class).withoutValidation();
        }

        private Write() {
        }

        public static class Bound<T>
        extends PTransform<PCollection<T>, PDone> {
            private static final String DEFAULT_SHARD_TEMPLATE = "-SSSSS-of-NNNNN";
            @Nullable
            final String filenamePrefix;
            final String filenameSuffix;
            final int numShards;
            final String shardTemplate;
            final Class<T> type;
            @Nullable
            final Schema schema;
            final boolean validate;

            Bound(Class<T> type) {
                this(null, null, "", 0, DEFAULT_SHARD_TEMPLATE, type, null, true);
            }

            Bound(String name, String filenamePrefix, String filenameSuffix, int numShards, String shardTemplate, Class<T> type, Schema schema, boolean validate) {
                super(name);
                this.filenamePrefix = filenamePrefix;
                this.filenameSuffix = filenameSuffix;
                this.numShards = numShards;
                this.shardTemplate = shardTemplate;
                this.type = type;
                this.schema = schema;
                this.validate = validate;
            }

            public Bound<T> named(String name) {
                return new Bound<T>(name, this.filenamePrefix, this.filenameSuffix, this.numShards, this.shardTemplate, this.type, this.schema, this.validate);
            }

            public Bound<T> to(String filenamePrefix) {
                AvroIO.validateOutputComponent(filenamePrefix);
                return new Bound<T>(this.name, filenamePrefix, this.filenameSuffix, this.numShards, this.shardTemplate, this.type, this.schema, this.validate);
            }

            public Bound<T> withSuffix(String filenameSuffix) {
                AvroIO.validateOutputComponent(filenameSuffix);
                return new Bound<T>(this.name, this.filenamePrefix, filenameSuffix, this.numShards, this.shardTemplate, this.type, this.schema, this.validate);
            }

            public Bound<T> withNumShards(int numShards) {
                Preconditions.checkArgument(numShards >= 0);
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, numShards, this.shardTemplate, this.type, this.schema, this.validate);
            }

            public Bound<T> withShardNameTemplate(String shardTemplate) {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.numShards, shardTemplate, this.type, this.schema, this.validate);
            }

            public Bound<T> withoutSharding() {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, 1, "", this.type, this.schema, this.validate);
            }

            public <X> Bound<X> withSchema(Class<X> type) {
                return new Bound<X>(this.name, this.filenamePrefix, this.filenameSuffix, this.numShards, this.shardTemplate, type, ReflectData.get().getSchema(type), this.validate);
            }

            public Bound<GenericRecord> withSchema(Schema schema) {
                return new Bound<GenericRecord>(this.name, this.filenamePrefix, this.filenameSuffix, this.numShards, this.shardTemplate, GenericRecord.class, schema, this.validate);
            }

            public Bound<GenericRecord> withSchema(String schema) {
                return this.withSchema(new Schema.Parser().parse(schema));
            }

            public Bound<T> withoutValidation() {
                return new Bound<T>(this.name, this.filenamePrefix, this.filenameSuffix, this.numShards, this.shardTemplate, this.type, this.schema, false);
            }

            @Override
            public PDone apply(PCollection<T> input) {
                if (this.filenamePrefix == null) {
                    throw new IllegalStateException("need to set the filename prefix of an AvroIO.Write transform");
                }
                if (this.schema == null) {
                    throw new IllegalStateException("need to set the schema of an AvroIO.Write transform");
                }
                Write.Bound<T> write = com.google.cloud.dataflow.sdk.io.Write.to(new AvroSink<T>(this.filenamePrefix, this.filenameSuffix, this.shardTemplate, AvroCoder.of(this.type, this.schema)));
                if (this.getNumShards() > 0) {
                    write = write.withNumShards(this.getNumShards());
                }
                return (PDone)input.apply("Write", write);
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.add(DisplayData.item("schema", this.type).withLabel("Record Schema")).addIfNotNull(DisplayData.item("filePrefix", this.filenamePrefix).withLabel("Output File Prefix")).addIfNotDefault(DisplayData.item("shardNameTemplate", this.shardTemplate).withLabel("Output Shard Name Template"), DEFAULT_SHARD_TEMPLATE).addIfNotDefault(DisplayData.item("fileSuffix", this.filenameSuffix).withLabel("Output File Suffix"), "").addIfNotDefault(DisplayData.item("numShards", this.numShards).withLabel("Maximum Output Shards"), 0).addIfNotDefault(DisplayData.item("validation", this.validate).withLabel("Validation Enabled"), true);
            }

            public String getShardNameTemplate() {
                return this.shardTemplate;
            }

            @Override
            protected Coder<Void> getDefaultOutputCoder() {
                return VoidCoder.of();
            }

            public String getFilenamePrefix() {
                return this.filenamePrefix;
            }

            public String getShardTemplate() {
                return this.shardTemplate;
            }

            public int getNumShards() {
                return this.numShards;
            }

            public String getFilenameSuffix() {
                return this.filenameSuffix;
            }

            public Class<T> getType() {
                return this.type;
            }

            public Schema getSchema() {
                return this.schema;
            }

            public boolean needsValidation() {
                return this.validate;
            }
        }
    }

    public static class Read {
        public static Bound<GenericRecord> named(String name) {
            return new Bound<GenericRecord>(GenericRecord.class).named(name);
        }

        public static Bound<GenericRecord> from(String filepattern) {
            return new Bound<GenericRecord>(GenericRecord.class).from(filepattern);
        }

        public static <T> Bound<T> withSchema(Class<T> type) {
            return new Bound<T>(type).withSchema(type);
        }

        public static Bound<GenericRecord> withSchema(Schema schema) {
            return new Bound<GenericRecord>(GenericRecord.class).withSchema(schema);
        }

        public static Bound<GenericRecord> withSchema(String schema) {
            return Read.withSchema(new Schema.Parser().parse(schema));
        }

        public static Bound<GenericRecord> withoutValidation() {
            return new Bound<GenericRecord>(GenericRecord.class).withoutValidation();
        }

        private Read() {
        }

        public static class Bound<T>
        extends PTransform<PInput, PCollection<T>> {
            @Nullable
            final String filepattern;
            final Class<T> type;
            @Nullable
            final Schema schema;
            final boolean validate;

            Bound(Class<T> type) {
                this(null, null, type, null, true);
            }

            Bound(String name, String filepattern, Class<T> type, Schema schema, boolean validate) {
                super(name);
                this.filepattern = filepattern;
                this.type = type;
                this.schema = schema;
                this.validate = validate;
            }

            public Bound<T> named(String name) {
                return new Bound<T>(name, this.filepattern, this.type, this.schema, this.validate);
            }

            public Bound<T> from(String filepattern) {
                return new Bound<T>(this.name, filepattern, this.type, this.schema, this.validate);
            }

            public <X> Bound<X> withSchema(Class<X> type) {
                return new Bound<X>(this.name, this.filepattern, type, ReflectData.get().getSchema(type), this.validate);
            }

            public Bound<GenericRecord> withSchema(Schema schema) {
                return new Bound<GenericRecord>(this.name, this.filepattern, GenericRecord.class, schema, this.validate);
            }

            public Bound<GenericRecord> withSchema(String schema) {
                return this.withSchema(new Schema.Parser().parse(schema));
            }

            public Bound<T> withoutValidation() {
                return new Bound<T>(this.name, this.filepattern, this.type, this.schema, false);
            }

            @Override
            public PCollection<T> apply(PInput input) {
                if (this.filepattern == null) {
                    throw new IllegalStateException("need to set the filepattern of an AvroIO.Read transform");
                }
                if (this.schema == null) {
                    throw new IllegalStateException("need to set the schema of an AvroIO.Read transform");
                }
                if (this.validate) {
                    try {
                        Preconditions.checkState(!IOChannelUtils.getFactory(this.filepattern).match(this.filepattern).isEmpty(), "Unable to find any files matching %s", this.filepattern);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(String.format("Failed to validate %s", this.filepattern), e);
                    }
                }
                Read.Bounded<Object> read = this.type == GenericRecord.class ? com.google.cloud.dataflow.sdk.io.Read.from(AvroSource.from(this.filepattern).withSchema(this.schema)) : com.google.cloud.dataflow.sdk.io.Read.from(AvroSource.from(this.filepattern).withSchema(this.type));
                PCollection pcol = (PCollection)input.getPipeline().apply("Read", read);
                pcol.setCoder((Coder)this.getDefaultOutputCoder());
                return pcol;
            }

            @Override
            public void populateDisplayData(DisplayData.Builder builder) {
                super.populateDisplayData(builder);
                builder.addIfNotNull(DisplayData.item("filePattern", this.filepattern).withLabel("Input File Pattern")).addIfNotDefault(DisplayData.item("validation", this.validate).withLabel("Validation Enabled"), true);
            }

            @Override
            protected Coder<T> getDefaultOutputCoder() {
                return AvroCoder.of(this.type, this.schema);
            }

            public String getFilepattern() {
                return this.filepattern;
            }

            public Schema getSchema() {
                return this.schema;
            }

            public boolean needsValidation() {
                return this.validate;
            }
        }
    }
}

