/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.util.VarInt;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class VarLongCoder
extends AtomicCoder<Long> {
    private static final VarLongCoder INSTANCE = new VarLongCoder();

    @JsonCreator
    public static VarLongCoder of() {
        return INSTANCE;
    }

    private VarLongCoder() {
    }

    @Override
    public void encode(Long value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Long");
        }
        VarInt.encode(value, outStream);
    }

    @Override
    public Long decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        try {
            return VarInt.decodeLong(inStream);
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Long value, Coder.Context context) {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(Long value, Coder.Context context) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Long");
        }
        return VarInt.getLength(value);
    }
}

