/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.StructuralByteArray;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Lists;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.ByteStreams;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.CountingOutputStream;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class StandardCoder<T>
implements Coder<T> {
    protected StandardCoder() {
    }

    @Override
    public String getEncodingId() {
        return "";
    }

    @Override
    public Collection<String> getAllowedEncodings() {
        return Collections.emptyList();
    }

    public List<? extends Coder<?>> getComponents() {
        List<Coder<?>> coderArguments = this.getCoderArguments();
        if (coderArguments == null) {
            return Collections.emptyList();
        }
        return coderArguments;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandardCoder that = (StandardCoder)o;
        return this.getComponents().equals(that.getComponents());
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.getComponents().hashCode();
    }

    public String toString() {
        String s = this.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        List<Coder<?>> componentCoders = this.getComponents();
        if (!componentCoders.isEmpty()) {
            s = s + "(";
            boolean first = true;
            for (Coder<?> componentCoder : componentCoders) {
                if (first) {
                    first = false;
                } else {
                    s = s + ", ";
                }
                s = s + componentCoder.toString();
            }
            s = s + ")";
        }
        return s;
    }

    @Override
    public CloudObject asCloudObject() {
        Collection<String> allowedEncodings;
        CloudObject result = CloudObject.forClass(this.getClass());
        List<Coder<?>> components = this.getComponents();
        if (!components.isEmpty()) {
            ArrayList<CloudObject> cloudComponents = new ArrayList<CloudObject>(components.size());
            for (Coder<?> coder : components) {
                cloudComponents.add(coder.asCloudObject());
            }
            Structs.addList((Map<String, Object>)((Object)result), "component_encodings", cloudComponents);
        }
        String encodingId = this.getEncodingId();
        Preconditions.checkNotNull(encodingId, "Coder.getEncodingId() must not return null.");
        if (!encodingId.isEmpty()) {
            Structs.addString((Map<String, Object>)((Object)result), "encoding_id", encodingId);
        }
        if (!(allowedEncodings = this.getAllowedEncodings()).isEmpty()) {
            Structs.addStringList((Map<String, Object>)((Object)result), "allowed_encodings", Lists.newArrayList(allowedEncodings));
        }
        return result;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(T value, Coder.Context context) {
        return false;
    }

    protected long getEncodedElementByteSize(T value, Coder.Context context) throws Exception {
        try {
            CountingOutputStream os = new CountingOutputStream(ByteStreams.nullOutputStream());
            this.encode(value, os, context);
            return os.getCount();
        }
        catch (Exception exn) {
            throw new IllegalArgumentException("Unable to encode element '" + value + "' with coder '" + this + "'.", exn);
        }
    }

    @Override
    public void registerByteSizeObserver(T value, ElementByteSizeObserver observer, Coder.Context context) throws Exception {
        observer.update(this.getEncodedElementByteSize(value, context));
    }

    protected void verifyDeterministic(String message, Iterable<Coder<?>> coders) throws Coder.NonDeterministicException {
        for (Coder<?> coder : coders) {
            try {
                coder.verifyDeterministic();
            }
            catch (Coder.NonDeterministicException e) {
                throw new Coder.NonDeterministicException(this, message, e);
            }
        }
    }

    protected void verifyDeterministic(String message, Coder<?> ... coders) throws Coder.NonDeterministicException {
        this.verifyDeterministic(message, Arrays.asList(coders));
    }

    @Override
    public boolean consistentWithEquals() {
        return false;
    }

    @Override
    public Object structuralValue(T value) throws Exception {
        if (value != null && this.consistentWithEquals()) {
            return value;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.encode(value, os, Coder.Context.OUTER);
            return new StructuralByteArray(os.toByteArray());
        }
        catch (Exception exn) {
            throw new IllegalArgumentException("Unable to encode element '" + value + "' with coder '" + this + "'.", exn);
        }
    }
}

