/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DoubleCoder
extends AtomicCoder<Double> {
    private static final DoubleCoder INSTANCE = new DoubleCoder();

    @JsonCreator
    public static DoubleCoder of() {
        return INSTANCE;
    }

    private DoubleCoder() {
    }

    @Override
    public void encode(Double value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Double");
        }
        new DataOutputStream(outStream).writeDouble(value);
    }

    @Override
    public Double decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        try {
            return new DataInputStream(inStream).readDouble();
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "Floating point encodings are not guaranteed to be deterministic.");
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Double value, Coder.Context context) {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(Double value, Coder.Context context) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Double");
        }
        return 8L;
    }
}

