/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.io.ByteStreams;
import com.google.cloud.dataflow.sdk.util.VarInt;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteStringCoder
extends AtomicCoder<ByteString> {
    private static final ByteStringCoder INSTANCE = new ByteStringCoder();

    @JsonCreator
    public static ByteStringCoder of() {
        return INSTANCE;
    }

    private ByteStringCoder() {
    }

    @Override
    public void encode(ByteString value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null ByteString");
        }
        if (!context.isWholeStream) {
            VarInt.encode(value.size(), outStream);
        }
        value.writeTo(outStream);
    }

    @Override
    public ByteString decode(InputStream inStream, Coder.Context context) throws IOException {
        if (context.isWholeStream) {
            return ByteString.readFrom((InputStream)inStream);
        }
        int size = VarInt.decodeInt(inStream);
        return ByteString.readFrom((InputStream)ByteStreams.limit(inStream, size), (int)size);
    }

    @Override
    protected long getEncodedElementByteSize(ByteString value, Coder.Context context) throws Exception {
        int size = value.size();
        if (context.isWholeStream) {
            return size;
        }
        return VarInt.getLength(size) + size;
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(ByteString value, Coder.Context context) {
        return true;
    }
}

