/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class ByteCoder
extends AtomicCoder<Byte> {
    private static final ByteCoder INSTANCE = new ByteCoder();

    @JsonCreator
    public static ByteCoder of() {
        return INSTANCE;
    }

    private ByteCoder() {
    }

    @Override
    public void encode(Byte value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Byte");
        }
        outStream.write(value.byteValue());
    }

    @Override
    public Byte decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        try {
            int value = inStream.read();
            if (value == -1) {
                throw new EOFException("EOF encountered decoding 1 byte from input stream");
            }
            return (byte)value;
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Byte value, Coder.Context context) {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(Byte value, Coder.Context context) throws Exception {
        if (value == null) {
            throw new CoderException("cannot estimate size for unsupported null value");
        }
        return 1L;
    }
}

