/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.coders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.cloud.dataflow.sdk.coders.AtomicCoder;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class BigEndianIntegerCoder
extends AtomicCoder<Integer> {
    private static final BigEndianIntegerCoder INSTANCE = new BigEndianIntegerCoder();

    @JsonCreator
    public static BigEndianIntegerCoder of() {
        return INSTANCE;
    }

    private BigEndianIntegerCoder() {
    }

    @Override
    public void encode(Integer value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        new DataOutputStream(outStream).writeInt(value);
    }

    @Override
    public Integer decode(InputStream inStream, Coder.Context context) throws IOException, CoderException {
        try {
            return new DataInputStream(inStream).readInt();
        }
        catch (EOFException | UTFDataFormatException exn) {
            throw new CoderException(exn);
        }
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(Integer value, Coder.Context context) {
        return true;
    }

    @Override
    protected long getEncodedElementByteSize(Integer value, Coder.Context context) throws Exception {
        if (value == null) {
            throw new CoderException("cannot encode a null Integer");
        }
        return 4L;
    }
}

