/*
 * Decompiled with CFR 0.152.
 */
package com.github.lltyk.rhino17r1.optimizer;

import com.github.lltyk.rhino17r1.Kit;
import com.github.lltyk.rhino17r1.Node;
import com.github.lltyk.rhino17r1.NodeTransformer;
import com.github.lltyk.rhino17r1.ObjArray;
import com.github.lltyk.rhino17r1.ScriptOrFnNode;
import com.github.lltyk.rhino17r1.optimizer.OptFunctionNode;
import java.util.Hashtable;

class OptTransformer
extends NodeTransformer {
    private Hashtable possibleDirectCalls;
    private ObjArray directCallTargets;

    OptTransformer(Hashtable possibleDirectCalls, ObjArray directCallTargets) {
        this.possibleDirectCalls = possibleDirectCalls;
        this.directCallTargets = directCallTargets;
    }

    protected void visitNew(Node node, ScriptOrFnNode tree) {
        this.detectDirectCall(node, tree);
        super.visitNew(node, tree);
    }

    protected void visitCall(Node node, ScriptOrFnNode tree) {
        this.detectDirectCall(node, tree);
        super.visitCall(node, tree);
    }

    private void detectDirectCall(Node node, ScriptOrFnNode tree) {
        if (tree.getType() == 108) {
            Node left = node.getFirstChild();
            int argCount = 0;
            Node arg = left.getNext();
            while (arg != null) {
                arg = arg.getNext();
                ++argCount;
            }
            if (argCount == 0) {
                OptFunctionNode.get((ScriptOrFnNode)tree).itsContainsCalls0 = true;
            }
            if (this.possibleDirectCalls != null) {
                OptFunctionNode ofn;
                String targetName = null;
                if (left.getType() == 39) {
                    targetName = left.getString();
                } else if (left.getType() == 33) {
                    targetName = left.getFirstChild().getNext().getString();
                } else if (left.getType() == 34) {
                    throw Kit.codeBug();
                }
                if (targetName != null && (ofn = (OptFunctionNode)this.possibleDirectCalls.get(targetName)) != null && argCount == ofn.fnode.getParamCount() && !ofn.fnode.requiresActivation() && argCount <= 32) {
                    node.putProp(9, ofn);
                    if (!ofn.isTargetOfDirectCall()) {
                        int index = this.directCallTargets.size();
                        this.directCallTargets.add(ofn);
                        ofn.setDirectTargetIndex(index);
                    }
                }
            }
        }
    }
}

