/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.tag;

import com.github.dandelion.core.utils.EnumUtils;
import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.asset.ExtraJs;
import com.github.dandelion.datatables.core.asset.InsertMode;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.extension.feature.ExtraJsFeature;
import com.github.dandelion.datatables.jsp.tag.AbstractTableTag;
import com.github.dandelion.datatables.jsp.tag.TableTag;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;

public class ExtraJsTag
extends TagSupport {
    private static final long serialVersionUID = -287813095911386884L;
    private String bundles;
    private String insert;

    public int doStartTag() throws JspException {
        TableTag parent = (TableTag)ExtraJsTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent != null) {
            return 0;
        }
        throw new JspException("The tag 'extraJs' must be inside the 'table' tag.");
    }

    public int doEndTag() throws JspException {
        AbstractTableTag parent = (AbstractTableTag)ExtraJsTag.findAncestorWithClass((Tag)this, AbstractTableTag.class);
        if (parent.isFirstIteration()) {
            InsertMode mode = null;
            if (StringUtils.isNotBlank((String)this.insert)) {
                try {
                    mode = InsertMode.valueOf((String)this.insert.toUpperCase().trim());
                }
                catch (IllegalArgumentException e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("'");
                    sb.append(this.insert);
                    sb.append("' is not a valid insert mode. Possible values are: ");
                    sb.append(EnumUtils.printPossibleValuesOf(InsertMode.class));
                    throw new JspException(sb.toString());
                }
            } else {
                mode = InsertMode.BEFOREALL;
            }
            parent.getTable().getTableConfiguration().addExtraJs(new ExtraJs(new HashSet<String>(Arrays.asList(this.bundles.split(","))), mode));
            parent.getTable().getTableConfiguration().registerExtension((Extension)new ExtraJsFeature());
        }
        return 6;
    }

    public void setBundles(String bundles) {
        this.bundles = bundles;
    }

    public void setInsert(String insert) {
        this.insert = insert;
    }
}

