/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.tag;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.extension.feature.ExtraHtmlFeature;
import com.github.dandelion.datatables.core.html.ExtraHtml;
import com.github.dandelion.datatables.jsp.tag.TableTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;

public class ExtraHtmlTag
extends BodyTagSupport {
    private static final long serialVersionUID = -3060955123376442925L;
    private String uid;
    private String container;
    private String cssStyle;
    private String cssClass;
    private boolean escapeXml = true;

    public int doStartTag() throws JspException {
        TableTag parent = (TableTag)ExtraHtmlTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent != null) {
            return 2;
        }
        throw new JspException("The tag 'extraHtml' must be inside the 'table' tag.");
    }

    public int doEndTag() throws JspException {
        TableTag parent = (TableTag)ExtraHtmlTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent.isFirstIteration()) {
            ExtraHtml extraHtml = new ExtraHtml();
            extraHtml.setUid(this.uid);
            extraHtml.setContainer(StringUtils.isNotBlank((String)this.container) ? StringUtils.escape((boolean)this.escapeXml, (String)this.container) : "div");
            extraHtml.setCssStyle(this.cssStyle);
            extraHtml.setCssClass(this.cssClass);
            if (this.getBodyContent() != null) {
                extraHtml.setContent(this.getBodyContent().getString().replaceAll("[\n\r]", "").trim());
            }
            parent.getTable().getTableConfiguration().addExtraHtmlSnippet(extraHtml);
            parent.getTable().getTableConfiguration().registerExtension((Extension)new ExtraHtmlFeature());
        }
        return 6;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public void setEscapeXml(boolean escapeXml) {
        this.escapeXml = escapeXml;
    }
}

