/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.tag;

import com.github.dandelion.core.utils.EnumUtils;
import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.core.utils.UrlUtils;
import com.github.dandelion.datatables.core.export.ExportConf;
import com.github.dandelion.datatables.core.export.HttpMethod;
import com.github.dandelion.datatables.jsp.tag.AbstractTableTag;
import com.github.dandelion.datatables.jsp.tag.TableTag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTag
extends TagSupport {
    private static final long serialVersionUID = -3453884184847355817L;
    private static Logger logger = LoggerFactory.getLogger(ExportTag.class);
    private String fileName;
    private String fileExtension;
    private String type;
    private String label;
    private String cssStyle;
    private String cssClass;
    private Boolean includeHeader;
    private Boolean autoSize;
    private String url;
    private String method;
    private String orientation;
    private String mimeType;
    private boolean escapeXml = true;

    public int doStartTag() throws JspException {
        TableTag parent = (TableTag)ExportTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent != null) {
            return 0;
        }
        throw new JspException("The tag 'export' must be inside the 'table' tag.");
    }

    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        AbstractTableTag parent = (AbstractTableTag)ExportTag.findAncestorWithClass((Tag)this, AbstractTableTag.class);
        if (parent.isFirstIteration()) {
            String format = this.type.toLowerCase().trim();
            ExportConf conf = null;
            if (parent.getTable().getTableConfiguration().getExportConfiguration().get(format) != null) {
                conf = (ExportConf)parent.getTable().getTableConfiguration().getExportConfiguration().get(format);
            } else {
                conf = new ExportConf(format);
                parent.getTable().getTableConfiguration().getExportConfiguration().put(format, conf);
            }
            StringBuilder exportUrl = null;
            if (StringUtils.isBlank((String)this.url)) {
                exportUrl = UrlUtils.getCurrentUri((HttpServletRequest)request);
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtt", (Object)"f");
                conf.setHasCustomUrl(Boolean.valueOf(false));
            } else {
                exportUrl = new StringBuilder(this.url.trim());
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtt", (Object)"c");
                conf.setHasCustomUrl(Boolean.valueOf(true));
            }
            if (StringUtils.isNotBlank((String)this.fileName)) {
                conf.setFileName(this.fileName.trim());
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtn", (Object)this.fileName);
            }
            if (StringUtils.isNotBlank((String)this.fileExtension)) {
                conf.setFileExtension(this.fileExtension);
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dte", (Object)this.fileExtension);
            }
            if (StringUtils.isNotBlank((String)this.label)) {
                conf.setLabel(StringUtils.escape((boolean)this.escapeXml, (String)this.label.trim()));
            }
            if (StringUtils.isNotBlank((String)this.cssClass)) {
                conf.setCssClass(new StringBuilder(this.cssClass.trim()));
            }
            if (StringUtils.isNotBlank((String)this.cssStyle)) {
                conf.setCssStyle(new StringBuilder(this.cssStyle.trim()));
            }
            if (StringUtils.isNotBlank((String)this.method)) {
                HttpMethod httpMethod = null;
                try {
                    httpMethod = HttpMethod.valueOf((String)this.method.toUpperCase().trim());
                }
                catch (IllegalArgumentException e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("'");
                    sb.append(this.method);
                    sb.append("' is not a valid HTTP method. Possible values are: ");
                    sb.append(EnumUtils.printPossibleValuesOf(HttpMethod.class));
                    throw new JspException(sb.toString());
                }
                conf.setMethod(httpMethod);
            }
            if (StringUtils.isNotBlank((String)this.orientation)) {
                ExportConf.Orientation orientationEnum = null;
                try {
                    orientationEnum = ExportConf.Orientation.valueOf((String)this.orientation.toUpperCase().trim());
                }
                catch (IllegalArgumentException e) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("'");
                    sb.append(this.orientation);
                    sb.append("' is not a valid orientation. Possible values are: ");
                    sb.append(EnumUtils.printPossibleValuesOf(ExportConf.Orientation.class));
                    throw new JspException(sb.toString());
                }
                conf.setOrientation(orientationEnum);
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dto", (Object)this.orientation);
            }
            if (StringUtils.isNotBlank((String)this.mimeType)) {
                conf.setMimeType(this.mimeType.trim());
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtmt", (Object)this.mimeType.trim());
            }
            if (this.includeHeader != null) {
                conf.setIncludeHeader(this.includeHeader);
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dth", (Object)this.includeHeader);
            }
            if (this.autoSize != null) {
                conf.setAutoSize(this.autoSize);
                UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dts", (Object)this.autoSize);
            }
            UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dti", (Object)parent.getTable().getId());
            UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtf", (Object)format);
            UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dtp", (Object)"y");
            UrlUtils.addParameter((StringBuilder)exportUrl, (String)"dandelionAssetFilterState", (Object)false);
            conf.setUrl(UrlUtils.getProcessedUrl((StringBuilder)exportUrl, (HttpServletRequest)request, (HttpServletResponse)response));
            logger.debug("Export configuration for the type {} has been updated", (Object)format);
        }
        return 6;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setCssStyle(String cssStyle) {
        this.cssStyle = cssStyle;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public void setIncludeHeader(Boolean includeHeader) {
        this.includeHeader = includeHeader;
    }

    public void setAutoSize(Boolean autoSize) {
        this.autoSize = autoSize;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setEscapeXml(boolean escapeXml) {
        this.escapeXml = escapeXml;
    }
}

