/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.tag;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.ColumnConfig;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.jsp.extension.feature.FilteringFeature;
import com.github.dandelion.datatables.jsp.tag.AbstractColumnTag;
import com.github.dandelion.datatables.jsp.tag.TableTag;
import java.util.HashMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

public class ColumnTag
extends AbstractColumnTag {
    private static final long serialVersionUID = -8928415196287387948L;

    public ColumnTag() {
        this.stagingConf = new HashMap();
        this.stagingExtension = new HashMap();
    }

    public int doStartTag() throws JspException {
        TableTag parent = (TableTag)ColumnTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent != null) {
            if (parent.isFirstIteration()) {
                this.headerColumn = new HtmlColumn(Boolean.valueOf(true), null, this.dynamicAttributes, this.display);
            }
            if (StringUtils.isNotBlank((String)this.property)) {
                return 0;
            }
            return 2;
        }
        throw new JspException("The tag 'column' must be inside the 'table' tag.");
    }

    public int doEndTag() throws JspException {
        TableTag parent = (TableTag)ColumnTag.findAncestorWithClass((Tag)this, TableTag.class);
        if (parent.isFirstIteration()) {
            String columnTitle = StringUtils.escape((boolean)this.escapeXml, (String)this.title);
            if (columnTitle == null && this.titleKey != null) {
                if (parent.getTable().getTableConfiguration().getMessageResolver() != null) {
                    columnTitle = parent.getTable().getTableConfiguration().getMessageResolver().getResource(this.titleKey, StringUtils.escape((boolean)this.escapeXml, (String)this.property), new Object[]{this.pageContext});
                } else {
                    columnTitle = "???" + this.titleKey + "???";
                    logger.warn("You cannot use the 'titleKey' attribute if no message resolver is configured. Please take a look at the {} property in the configuration reference.", (Object)"i18n.message.resolver");
                }
            }
            if ("DOM".equals(parent.getDataSourceType())) {
                this.addDomHeaderColumn(columnTitle);
            } else if ("AJAX".equals(parent.getDataSourceType())) {
                this.addAjaxHeaderColumn(true, columnTitle);
                return 6;
            }
        }
        if (parent.getCurrentObject() != null) {
            String columnContent = null;
            if (StringUtils.isNotBlank((String)this.property)) {
                columnContent = this.getColumnContent();
            } else if (this.getBodyContent() != null) {
                columnContent = this.getBodyContent().getString().trim().replaceAll("[\n\r]", "");
            }
            this.addDomBodyColumn(columnContent);
        }
        return 6;
    }

    public void setTitle(String titleKey) {
        this.title = titleKey;
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public void setEscapeXml(boolean escapeXml) {
        this.escapeXml = escapeXml;
    }

    public void setName(String name) {
        this.stagingConf.put(ColumnConfig.NAME, name);
    }

    public void setProperty(String property) {
        this.property = property;
        this.stagingConf.put(ColumnConfig.PROPERTY, property);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setCssStyle(String cssStyle) {
        this.stagingConf.put(ColumnConfig.CSSSTYLE, cssStyle);
    }

    public void setCssClass(String cssClass) {
        this.stagingConf.put(ColumnConfig.CSSCLASS, cssClass);
    }

    public void setSortable(Boolean sortable) {
        this.stagingConf.put(ColumnConfig.SORTABLE, sortable);
    }

    public void setCssCellStyle(String cssCellStyle) {
        this.cssCellStyle = cssCellStyle;
        this.stagingConf.put(ColumnConfig.CSSCELLSTYLE, cssCellStyle);
    }

    public void setCssCellClass(String cssCellClass) {
        this.cssCellClass = cssCellClass;
        this.stagingConf.put(ColumnConfig.CSSCELLCLASS, cssCellClass);
    }

    public void setFilterable(Boolean filterable) {
        this.stagingConf.put(ColumnConfig.FILTERABLE, filterable);
        this.stagingExtension.put(ColumnConfig.FILTERABLE, new FilteringFeature());
    }

    public void setSearchable(Boolean searchable) {
        this.stagingConf.put(ColumnConfig.SEARCHABLE, searchable);
    }

    public void setVisible(Boolean visible) {
        this.stagingConf.put(ColumnConfig.VISIBLE, visible);
    }

    public void setFilterType(String filterType) {
        this.stagingConf.put(ColumnConfig.FILTERTYPE, filterType);
    }

    public void setFilterValues(String filterValues) {
        this.stagingConf.put(ColumnConfig.FILTERVALUES, filterValues);
    }

    public void setFilterCssClass(String filterCssClass) {
        this.stagingConf.put(ColumnConfig.FILTERCSSCLASS, filterCssClass);
    }

    public void setFilterPlaceholder(String filterPlaceholder) {
        this.stagingConf.put(ColumnConfig.FILTERPLACEHOLDER, filterPlaceholder);
    }

    public void setSortDirection(String sortDirection) {
        this.stagingConf.put(ColumnConfig.SORTDIRECTION, sortDirection);
    }

    public void setSortInitDirection(String sortInitDirection) {
        this.stagingConf.put(ColumnConfig.SORTINITDIRECTION, sortInitDirection);
    }

    public void setSortInitOrder(String sortInitOrder) {
        this.stagingConf.put(ColumnConfig.SORTINITORDER, sortInitOrder);
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
        this.stagingConf.put(ColumnConfig.DEFAULTVALUE, defaultValue);
    }

    public void setRenderFunction(String renderFunction) {
        this.stagingConf.put(ColumnConfig.RENDERFUNCTION, renderFunction);
    }

    public void setSelector(String selector) {
        this.stagingConf.put(ColumnConfig.SELECTOR, selector);
    }

    public void setSortType(String sortType) {
        this.stagingConf.put(ColumnConfig.SORTTYPE, sortType);
    }

    public void setFilterMinLength(Integer filterMinLength) {
        this.stagingConf.put(ColumnConfig.FILTERMINLENGTH, filterMinLength);
    }

    public void setFilterDateFormat(String filterDateFormat) {
        this.stagingConf.put(ColumnConfig.FILTERDATEFORMAT, filterDateFormat);
    }

    public void setId(String id) {
        this.stagingConf.put(ColumnConfig.ID, id);
    }
}

