/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.tag;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.core.web.AssetRequestContext;
import com.github.dandelion.datatables.core.asset.JsResource;
import com.github.dandelion.datatables.core.configuration.ConfigToken;
import com.github.dandelion.datatables.core.configuration.DatatableBundles;
import com.github.dandelion.datatables.core.configuration.DatatablesConfigurator;
import com.github.dandelion.datatables.core.configuration.TableConfig;
import com.github.dandelion.datatables.core.exception.ExportException;
import com.github.dandelion.datatables.core.export.ExportDelegate;
import com.github.dandelion.datatables.core.export.ExportUtils;
import com.github.dandelion.datatables.core.generator.WebResourceGenerator;
import com.github.dandelion.datatables.core.generator.javascript.JavascriptGenerator;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.jsp.tag.TableTag;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.DynamicAttributes;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableTag
extends BodyTagSupport
implements DynamicAttributes {
    private static final long serialVersionUID = 4788079931487986884L;
    protected static Logger logger = LoggerFactory.getLogger(TableTag.class);
    protected String id;
    protected Object data;
    protected String url;
    protected String row;
    protected String confGroup;
    protected String rowIdBase;
    protected String rowIdPrefix;
    protected String rowIdSuffix;
    protected boolean escapeXml = true;
    protected Map<ConfigToken<?>, Object> stagingConf;
    protected Integer iterationNumber;
    protected HtmlTable table;
    protected Iterator<Object> iterator;
    protected Object currentObject;
    protected String dataSourceType;
    protected Map<String, String> dynamicAttributes;
    protected HttpServletRequest request;
    protected HttpServletResponse response;

    protected int processIteration() throws JspException {
        if ("DOM".equals(this.dataSourceType)) {
            Integer retval = null;
            if (this.iterator != null && this.iterator.hasNext()) {
                String rowId;
                Object object = this.iterator.next();
                this.setCurrentObject(object);
                this.stagingConf.put(TableConfig.INTERNAL_OBJECTTYPE, object.getClass().getSimpleName());
                if (this.row != null) {
                    this.pageContext.setAttribute(this.row, object);
                    this.pageContext.setAttribute(this.row + "_rowIndex", (Object)this.iterationNumber);
                }
                if (StringUtils.isNotBlank((String)(rowId = this.getRowId()))) {
                    this.table.addRow(rowId);
                } else {
                    this.table.addRow();
                }
                retval = 2;
            } else {
                retval = 0;
            }
            if (this.isFirstIteration()) {
                retval = 2;
            }
            return retval;
        }
        return 0;
    }

    protected String getRowId() throws JspException {
        StringBuilder rowId = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.rowIdPrefix)) {
            rowId.append(StringUtils.escape((boolean)this.escapeXml, (String)this.rowIdPrefix));
        }
        if (StringUtils.isNotBlank((String)this.rowIdBase)) {
            try {
                Object propertyValue = PropertyUtils.getNestedProperty((Object)this.currentObject, (String)StringUtils.escape((boolean)this.escapeXml, (String)this.rowIdBase));
                rowId.append(propertyValue != null ? propertyValue : "");
            }
            catch (IllegalAccessException e) {
                throw new JspException("Unable to get the value for the given rowIdBase " + this.rowIdBase, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new JspException("Unable to get the value for the given rowIdBase " + this.rowIdBase, (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new JspException("Unable to get the value for the given rowIdBase " + this.rowIdBase, (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((String)this.rowIdSuffix)) {
            rowId.append(StringUtils.escape((boolean)this.escapeXml, (String)this.rowIdSuffix));
        }
        return rowId.toString();
    }

    protected int setupHtmlGeneration() throws JspException {
        JsResource jsResource = null;
        this.table.getTableConfiguration().setExporting(Boolean.valueOf(false));
        try {
            WebResourceGenerator contentGenerator = new WebResourceGenerator(this.table);
            jsResource = contentGenerator.generateWebResources();
            logger.debug("Web content generated successfully");
            AssetRequestContext.get((ServletRequest)this.request).addBundles(new Enum[]{DatatableBundles.DDL_DT}).addBundles(new Enum[]{DatatableBundles.DATATABLES}).addParameter("dandelion-datatables", "DELEGATED_CONTENT", (Object)DatatablesConfigurator.getJavascriptGenerator(), false);
            JavascriptGenerator javascriptGenerator = (JavascriptGenerator)AssetRequestContext.get((ServletRequest)this.request).getParameterValue("dandelion-datatables", "DELEGATED_CONTENT");
            javascriptGenerator.addResource(jsResource);
            this.pageContext.getOut().println((Object)this.table.toHtml());
        }
        catch (IOException e) {
            throw new JspException("Unable to generate the HTML markup for the table " + this.id, (Throwable)e);
        }
        return 6;
    }

    protected int setupExport() throws JspException {
        String currentExportType = ExportUtils.getCurrentExportType((HttpServletRequest)this.request);
        this.table.getTableConfiguration().setExporting(Boolean.valueOf(true));
        this.table.getTableConfiguration().setCurrentExportFormat(currentExportType);
        try {
            ExportDelegate exportDelegate = new ExportDelegate(this.table, this.request);
            exportDelegate.prepareExport();
        }
        catch (ExportException e) {
            logger.error("Something went wront with the Dandelion export configuration.");
            throw new JspException((Throwable)e);
        }
        this.response.reset();
        return 5;
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.validateDynamicAttribute(localName, value);
        if (this.dynamicAttributes == null) {
            this.dynamicAttributes = new HashMap<String, String>();
        }
        this.dynamicAttributes.put(localName, (String)value);
    }

    private void validateDynamicAttribute(String localName, Object value) {
        if (localName.equals("class")) {
            throw new IllegalArgumentException("The 'class' attribute is not allowed. Please use the 'cssClass' attribute instead.");
        }
        if (localName.equals("style")) {
            throw new IllegalArgumentException("The 'style' attribute is not allowed. Please use the 'cssStyle' attribute instead.");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("The attribute " + localName + " won't be added to the table. Only string values are accepted.");
        }
    }

    public HtmlTable getTable() {
        return this.table;
    }

    public boolean isFirstIteration() {
        return this.iterationNumber.equals(1);
    }

    public int getIterationNumber() {
        return this.iterationNumber;
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    public void setCurrentObject(Object currentObject) {
        this.currentObject = currentObject;
    }

    public String getDataSourceType() {
        return this.dataSourceType;
    }
}

