/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.tag;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.configuration.ColumnConfig;
import com.github.dandelion.datatables.core.configuration.ConfigToken;
import com.github.dandelion.datatables.core.extension.Extension;
import com.github.dandelion.datatables.core.html.HtmlColumn;
import com.github.dandelion.datatables.core.html.HtmlTable;
import com.github.dandelion.datatables.jsp.tag.AbstractTableTag;
import com.github.dandelion.datatables.jsp.tag.ColumnTag;
import com.github.dandelion.datatables.jsp.tag.TableTag;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.DynamicAttributes;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnTag
extends BodyTagSupport
implements DynamicAttributes {
    private static final long serialVersionUID = 1L;
    protected static Logger logger = LoggerFactory.getLogger(ColumnTag.class);
    protected Map<ConfigToken<?>, Object> stagingConf;
    protected Map<ConfigToken<?>, Extension> stagingExtension;
    protected String title;
    protected String titleKey;
    protected String property;
    protected String defaultValue;
    protected String cssCellStyle;
    protected String cssCellClass;
    protected String format;
    protected String display;
    protected boolean escapeXml = true;
    protected Map<String, String> dynamicAttributes;
    protected HtmlColumn headerColumn;

    protected void addDomHeaderColumn(String content) throws JspException {
        AbstractTableTag parent = (AbstractTableTag)AbstractColumnTag.findAncestorWithClass((Tag)this, AbstractTableTag.class);
        if (content != null) {
            this.headerColumn.setContent(new StringBuilder(content));
        }
        ColumnConfig.applyConfiguration(this.stagingConf, this.stagingExtension, (HtmlColumn)this.headerColumn);
        ColumnConfig.processConfiguration((HtmlColumn)this.headerColumn, (HtmlTable)parent.getTable());
        parent.getTable().getLastHeaderRow().addColumn(this.headerColumn);
    }

    protected void addDomBodyColumn(String content) throws JspException {
        AbstractTableTag parent = (AbstractTableTag)AbstractColumnTag.findAncestorWithClass((Tag)this, AbstractTableTag.class);
        HtmlColumn bodyColumn = new HtmlColumn(Boolean.valueOf(false), content, this.dynamicAttributes, this.display);
        if (StringUtils.isNotBlank((String)this.cssCellClass)) {
            bodyColumn.addCssCellClass(this.cssCellClass);
        }
        if (StringUtils.isNotBlank((String)this.cssCellStyle)) {
            bodyColumn.addCssCellStyle(this.cssCellStyle);
        }
        parent.getTable().getLastBodyRow().addColumn(bodyColumn);
    }

    protected void addAjaxHeaderColumn(Boolean isHeader, String content) throws JspException {
        AbstractTableTag parent = (AbstractTableTag)AbstractColumnTag.findAncestorWithClass((Tag)this, AbstractTableTag.class);
        if (content != null) {
            this.headerColumn.setContent(new StringBuilder(content));
        }
        ColumnConfig.DEFAULTVALUE.setIn(this.headerColumn.getColumnConfiguration(), (Object)(StringUtils.isNotBlank((String)this.defaultValue) ? this.defaultValue : ""));
        ColumnConfig.applyConfiguration(this.stagingConf, this.stagingExtension, (HtmlColumn)this.headerColumn);
        ColumnConfig.processConfiguration((HtmlColumn)this.headerColumn, (HtmlTable)parent.getTable());
        parent.getTable().getLastHeaderRow().addColumn(this.headerColumn);
    }

    protected String getColumnContent() throws JspException {
        block11: {
            TableTag parent = (TableTag)AbstractColumnTag.findAncestorWithClass((Tag)this, TableTag.class);
            if (StringUtils.isNotBlank((String)this.property) && parent.getCurrentObject() != null) {
                Object propertyValue = null;
                try {
                    propertyValue = PropertyUtils.getNestedProperty((Object)parent.getCurrentObject(), (String)this.property.trim());
                    if (StringUtils.isNotBlank((String)this.format) && propertyValue != null) {
                        MessageFormat messageFormat = new MessageFormat(this.format);
                        return messageFormat.format(new Object[]{propertyValue});
                    }
                    if (StringUtils.isBlank((String)this.format) && propertyValue != null) {
                        return propertyValue.toString();
                    }
                    if (StringUtils.isNotBlank((String)this.defaultValue)) {
                        return this.defaultValue.trim();
                    }
                    break block11;
                }
                catch (NestedNullException e) {
                    if (StringUtils.isNotBlank((String)this.defaultValue)) {
                        return this.defaultValue.trim();
                    }
                    break block11;
                }
                catch (IllegalAccessException e) {
                    logger.error("Unable to get the value for the given property {}", (Object)this.property);
                    throw new JspException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    logger.error("Unable to get the value for the given property {}", (Object)this.property);
                    throw new JspException((Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    logger.error("Unable to get the value for the given property {}", (Object)this.property);
                    throw new JspException((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    logger.error("Wrong MessageFormat pattern : {}", (Object)this.format);
                    return propertyValue.toString();
                }
            }
            return "";
        }
        return "";
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.validateDynamicAttribute(localName, value);
        if (this.dynamicAttributes == null) {
            this.dynamicAttributes = new HashMap<String, String>();
        }
        this.dynamicAttributes.put(localName, (String)value);
    }

    private void validateDynamicAttribute(String localName, Object value) {
        if (localName.equals("class")) {
            throw new IllegalArgumentException("The 'class' attribute is not allowed. Please use the 'cssClass' or the 'cssCellClass' attribute instead.");
        }
        if (localName.equals("style")) {
            throw new IllegalArgumentException("The 'style' attribute is not allowed. Please use the 'cssStyle' or the 'cssCellStyle' attribute instead.");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("The attribute " + localName + " won't be added to the table. Only string values are accepted.");
        }
    }

    protected HtmlColumn getHeaderColumn() {
        return this.headerColumn;
    }

    protected Map<ConfigToken<?>, Object> getStagingConf() {
        return this.stagingConf;
    }
}

