/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.datatables.jsp.i18n;

import com.github.dandelion.core.utils.StringUtils;
import com.github.dandelion.datatables.core.i18n.AbstractMessageResolver;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.apache.taglibs.standard.tag.common.fmt.BundleSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JstlMessageResolver
extends AbstractMessageResolver {
    private static Logger logger = LoggerFactory.getLogger(JstlMessageResolver.class);

    public JstlMessageResolver(HttpServletRequest request) {
        super(request);
    }

    public String getResource(String messageKey, String defaultValue, Object ... params) {
        PageContext pageContext = (PageContext)params[0];
        String message = null;
        ResourceBundle bundle = null;
        LocalizationContext localizationContext = BundleSupport.getLocalizationContext((PageContext)pageContext);
        if (localizationContext != null) {
            bundle = localizationContext.getResourceBundle();
        }
        if (bundle != null) {
            if (messageKey == null || StringUtils.isBlank((String)messageKey) && StringUtils.isNotBlank((String)defaultValue)) {
                message = StringUtils.capitalize((String)defaultValue);
            } else {
                try {
                    message = bundle.getString(messageKey);
                }
                catch (MissingResourceException e) {
                    logger.warn("No message found with the key The message key {} and locale {}.", (Object)messageKey, (Object)localizationContext.getLocale());
                    message = "???" + messageKey + "???";
                }
            }
        } else {
            logger.warn("The bundle hasn't been retrieved. Please check your i18n configuration.");
            message = "???" + messageKey + "???";
        }
        return message;
    }
}

