/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.NettyClientConfig;
import com.facebook.nifty.client.NiftyClientChannel;
import com.facebook.nifty.client.NiftyClientChannelPipelineFactory;
import com.facebook.nifty.client.NiftyClientConnector;
import com.facebook.nifty.client.TNiftyClientTransport;
import com.facebook.nifty.client.socks.Socks4ClientBootstrap;
import com.facebook.nifty.core.ShutdownUtil;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioClientBossPool;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;

public class NiftyClient
implements Closeable {
    public static final Duration DEFAULT_CONNECT_TIMEOUT = new Duration(2.0, TimeUnit.SECONDS);
    public static final Duration DEFAULT_RECEIVE_TIMEOUT = new Duration(2.0, TimeUnit.SECONDS);
    public static final Duration DEFAULT_READ_TIMEOUT = new Duration(2.0, TimeUnit.SECONDS);
    private static final Duration DEFAULT_SEND_TIMEOUT = new Duration(2.0, TimeUnit.SECONDS);
    private static final int DEFAULT_MAX_FRAME_SIZE = 0x1000000;
    private final NettyClientConfig nettyClientConfig;
    private final ExecutorService bossExecutor;
    private final ExecutorService workerExecutor;
    private final NioClientSocketChannelFactory channelFactory;
    private final HostAndPort defaultSocksProxyAddress;
    private final ChannelGroup allChannels = new DefaultChannelGroup();
    private final Timer timer;

    public NiftyClient() {
        this(NettyClientConfig.newBuilder().build());
    }

    public NiftyClient(NettyClientConfig nettyClientConfig) {
        this.nettyClientConfig = nettyClientConfig;
        this.timer = nettyClientConfig.getTimer();
        this.bossExecutor = nettyClientConfig.getBossExecutor();
        this.workerExecutor = nettyClientConfig.getWorkerExecutor();
        this.defaultSocksProxyAddress = nettyClientConfig.getDefaultSocksProxyAddress();
        int bossThreadCount = nettyClientConfig.getBossThreadCount();
        int workerThreadCount = nettyClientConfig.getWorkerThreadCount();
        NioWorkerPool workerPool = new NioWorkerPool((Executor)this.workerExecutor, workerThreadCount, ThreadNameDeterminer.CURRENT);
        NioClientBossPool bossPool = new NioClientBossPool((Executor)this.bossExecutor, bossThreadCount, this.timer, ThreadNameDeterminer.CURRENT);
        this.channelFactory = new NioClientSocketChannelFactory((BossPool)bossPool, (WorkerPool)workerPool);
    }

    public <T extends NiftyClientChannel> ListenableFuture<T> connectAsync(NiftyClientConnector<T> clientChannelConnector) {
        return this.connectAsync(clientChannelConnector, DEFAULT_CONNECT_TIMEOUT, DEFAULT_RECEIVE_TIMEOUT, DEFAULT_READ_TIMEOUT, DEFAULT_SEND_TIMEOUT, 0x1000000, this.defaultSocksProxyAddress);
    }

    public HostAndPort getDefaultSocksProxyAddress() {
        return this.defaultSocksProxyAddress;
    }

    @Deprecated
    public <T extends NiftyClientChannel> ListenableFuture<T> connectAsync(NiftyClientConnector<T> clientChannelConnector, @Nullable Duration connectTimeout, @Nullable Duration receiveTimeout, @Nullable Duration sendTimeout, int maxFrameSize) {
        return this.connectAsync(clientChannelConnector, connectTimeout, receiveTimeout, receiveTimeout, sendTimeout, maxFrameSize);
    }

    public <T extends NiftyClientChannel> ListenableFuture<T> connectAsync(NiftyClientConnector<T> clientChannelConnector, @Nullable Duration connectTimeout, @Nullable Duration receiveTimeout, @Nullable Duration readTimeout, @Nullable Duration sendTimeout, int maxFrameSize) {
        return this.connectAsync(clientChannelConnector, connectTimeout, receiveTimeout, readTimeout, sendTimeout, maxFrameSize, this.defaultSocksProxyAddress);
    }

    @Deprecated
    public <T extends NiftyClientChannel> ListenableFuture<T> connectAsync(NiftyClientConnector<T> clientChannelConnector, @Nullable Duration connectTimeout, @Nullable Duration receiveTimeout, @Nullable Duration sendTimeout, int maxFrameSize, @Nullable HostAndPort socksProxyAddress) {
        return this.connectAsync(clientChannelConnector, connectTimeout, receiveTimeout, receiveTimeout, sendTimeout, maxFrameSize, socksProxyAddress);
    }

    public <T extends NiftyClientChannel> ListenableFuture<T> connectAsync(NiftyClientConnector<T> clientChannelConnector, @Nullable Duration connectTimeout, @Nullable Duration receiveTimeout, @Nullable Duration readTimeout, @Nullable Duration sendTimeout, int maxFrameSize, @Nullable HostAndPort socksProxyAddress) {
        Preconditions.checkNotNull(clientChannelConnector, (Object)"clientChannelConnector is null");
        ClientBootstrap bootstrap = this.createClientBootstrap(socksProxyAddress);
        bootstrap.setOptions(this.nettyClientConfig.getBootstrapOptions());
        if (connectTimeout != null) {
            bootstrap.setOption("connectTimeoutMillis", (Object)connectTimeout.toMillis());
        }
        bootstrap.setPipelineFactory(clientChannelConnector.newChannelPipelineFactory(maxFrameSize));
        ChannelFuture nettyChannelFuture = clientChannelConnector.connect(bootstrap);
        nettyChannelFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                Channel channel = future.getChannel();
                if (channel != null && channel.isOpen()) {
                    NiftyClient.this.allChannels.add((Object)channel);
                }
            }
        });
        return new TNiftyFuture(clientChannelConnector, receiveTimeout, readTimeout, sendTimeout, nettyChannelFuture);
    }

    public TNiftyClientTransport connectSync(InetSocketAddress addr) throws TTransportException, InterruptedException {
        return this.connectSync(addr, DEFAULT_CONNECT_TIMEOUT, DEFAULT_RECEIVE_TIMEOUT, DEFAULT_SEND_TIMEOUT, 0x1000000);
    }

    public TNiftyClientTransport connectSync(InetSocketAddress addr, @Nullable Duration connectTimeout, @Nullable Duration receiveTimeout, @Nullable Duration sendTimeout, int maxFrameSize) throws TTransportException, InterruptedException {
        return this.connectSync(addr, connectTimeout, receiveTimeout, sendTimeout, maxFrameSize, this.defaultSocksProxyAddress);
    }

    public TNiftyClientTransport connectSync(InetSocketAddress addr, @Nullable Duration connectTimeout, @Nullable Duration receiveTimeout, @Nullable Duration sendTimeout, int maxFrameSize, @Nullable HostAndPort socksProxyAddress) throws TTransportException, InterruptedException {
        ClientBootstrap bootstrap = this.createClientBootstrap(socksProxyAddress);
        bootstrap.setOptions(this.nettyClientConfig.getBootstrapOptions());
        if (connectTimeout != null) {
            bootstrap.setOption("connectTimeoutMillis", (Object)connectTimeout.toMillis());
        }
        bootstrap.setPipelineFactory((ChannelPipelineFactory)new NiftyClientChannelPipelineFactory(maxFrameSize));
        ChannelFuture f = bootstrap.connect((SocketAddress)addr);
        f.await();
        Channel channel = f.getChannel();
        if (f.getCause() != null) {
            String message = String.format("unable to connect to %s:%d %s", addr.getHostName(), addr.getPort(), socksProxyAddress == null ? "" : "via socks proxy at " + socksProxyAddress);
            throw new TTransportException(message, f.getCause());
        }
        if (f.isSuccess() && channel != null) {
            if (channel.isOpen()) {
                this.allChannels.add((Object)channel);
            }
            TNiftyClientTransport transport = new TNiftyClientTransport(channel, receiveTimeout);
            channel.getPipeline().addLast("thrift", (ChannelHandler)transport);
            return transport;
        }
        throw new TTransportException(String.format("unknown error connecting to %s:%d %s", addr.getHostName(), addr.getPort(), socksProxyAddress == null ? "" : "via socks proxy at " + socksProxyAddress));
    }

    @Override
    public void close() {
        this.timer.stop();
        ShutdownUtil.shutdownChannelFactory((ChannelFactory)this.channelFactory, (ExecutorService)this.bossExecutor, (ExecutorService)this.workerExecutor, (ChannelGroup)this.allChannels);
    }

    private ClientBootstrap createClientBootstrap(@Nullable HostAndPort socksProxyAddress) {
        if (socksProxyAddress != null) {
            return new Socks4ClientBootstrap((ChannelFactory)this.channelFactory, NiftyClient.toInetAddress(socksProxyAddress));
        }
        return new ClientBootstrap((ChannelFactory)this.channelFactory);
    }

    private static InetSocketAddress toInetAddress(HostAndPort hostAndPort) {
        return hostAndPort == null ? null : new InetSocketAddress(hostAndPort.getHostText(), hostAndPort.getPort());
    }

    private class TNiftyFuture<T extends NiftyClientChannel>
    extends AbstractFuture<T> {
        private TNiftyFuture(final @Nullable NiftyClientConnector<T> clientChannelConnector, final @Nullable Duration receiveTimeout, final @Nullable Duration readTimeout, final Duration sendTimeout, ChannelFuture channelFuture) {
            channelFuture.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    block5: {
                        try {
                            if (future.isSuccess()) {
                                Channel nettyChannel = future.getChannel();
                                Object channel = clientChannelConnector.newThriftClientChannel(nettyChannel, NiftyClient.this.timer);
                                channel.setReceiveTimeout(receiveTimeout);
                                channel.setReadTimeout(readTimeout);
                                channel.setSendTimeout(sendTimeout);
                                TNiftyFuture.this.set(channel);
                                break block5;
                            }
                            if (future.isCancelled()) {
                                if (!TNiftyFuture.this.cancel(true)) {
                                    TNiftyFuture.this.setException((Throwable)new TTransportException("Unable to cancel client channel connection"));
                                }
                                break block5;
                            }
                            throw future.getCause();
                        }
                        catch (Throwable t) {
                            TNiftyFuture.this.setException((Throwable)new TTransportException("Failed to connect client channel", t));
                        }
                    }
                }
            });
        }
    }
}

