/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.AbstractClientConnector;
import com.facebook.nifty.client.HttpClientChannel;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpClientCodec;
import org.jboss.netty.util.Timer;

public class HttpClientConnector
extends AbstractClientConnector<HttpClientChannel> {
    private final URI endpointUri;

    public HttpClientConnector(String hostNameAndPort, String servicePath) throws URISyntaxException {
        this(hostNameAndPort, servicePath, HttpClientConnector.defaultProtocolFactory());
    }

    public HttpClientConnector(URI uri) {
        this(uri, HttpClientConnector.defaultProtocolFactory());
    }

    public HttpClientConnector(String hostNameAndPort, String servicePath, TDuplexProtocolFactory protocolFactory) throws URISyntaxException {
        super(new InetSocketAddress(HostAndPort.fromString((String)hostNameAndPort).getHostText(), HostAndPort.fromString((String)hostNameAndPort).getPortOrDefault(80)), protocolFactory);
        this.endpointUri = new URI("http", hostNameAndPort, servicePath, null, null);
    }

    public HttpClientConnector(URI uri, TDuplexProtocolFactory protocolFactory) {
        super(HttpClientConnector.toSocketAddress(HostAndPort.fromParts((String)((URI)Preconditions.checkNotNull((Object)uri)).getHost(), (int)HttpClientConnector.getPortFromURI(uri))), HttpClientConnector.defaultProtocolFactory());
        Preconditions.checkArgument((uri.isAbsolute() && !uri.isOpaque() ? 1 : 0) != 0, (Object)"HttpClientConnector requires an absolute URI with a path");
        this.endpointUri = uri;
    }

    @Override
    public HttpClientChannel newThriftClientChannel(Channel nettyChannel, Timer timer) {
        HttpClientChannel channel = new HttpClientChannel(nettyChannel, timer, this.getProtocolFactory(), this.endpointUri.getHost(), this.endpointUri.getPath());
        channel.getNettyChannel().getPipeline().addLast("thriftHandler", (ChannelHandler)channel);
        return channel;
    }

    @Override
    public ChannelPipelineFactory newChannelPipelineFactory(final int maxFrameSize) {
        return new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline cp = Channels.pipeline();
                cp.addLast("httpClientCodec", (ChannelHandler)new HttpClientCodec());
                cp.addLast("chunkAggregator", (ChannelHandler)new HttpChunkAggregator(maxFrameSize));
                return cp;
            }
        };
    }

    @Override
    public String toString() {
        return this.endpointUri.toString();
    }

    private static int getPortFromURI(URI uri) {
        URI uriNN = (URI)Preconditions.checkNotNull((Object)uri);
        if (uri.getScheme().toLowerCase().equals("http")) {
            return uriNN.getPort() == -1 ? 80 : uriNN.getPort();
        }
        if (uri.getScheme().toLowerCase().equals("https")) {
            return uriNN.getPort() == -1 ? 443 : uriNN.getPort();
        }
        throw new IllegalArgumentException("HttpClientConnector only connects to HTTP/HTTPS URIs");
    }
}

