/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.nifty.client;

import com.facebook.nifty.client.NiftyClientChannel;
import com.facebook.nifty.client.TimeoutHandler;
import com.facebook.nifty.core.TChannelBufferInputTransport;
import com.facebook.nifty.duplex.TDuplexProtocolFactory;
import io.airlift.units.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioSocketChannel;
import org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.jboss.netty.handler.timeout.WriteTimeoutException;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractClientChannel
extends SimpleChannelHandler
implements NiftyClientChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClientChannel.class);
    private final Channel nettyChannel;
    private Duration sendTimeout = null;
    private Duration receiveTimeout = null;
    private Duration readTimeout = null;
    private final Map<Integer, Request> requestMap = new HashMap<Integer, Request>();
    private volatile TException channelError;
    private final Timer timer;
    private final TDuplexProtocolFactory protocolFactory;

    protected AbstractClientChannel(Channel nettyChannel, Timer timer, TDuplexProtocolFactory protocolFactory) {
        this.nettyChannel = nettyChannel;
        this.timer = timer;
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Channel getNettyChannel() {
        return this.nettyChannel;
    }

    @Override
    public TDuplexProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    protected abstract ChannelBuffer extractResponse(Object var1) throws TTransportException;

    protected int extractSequenceId(ChannelBuffer messageBuffer) throws TTransportException {
        try {
            messageBuffer.markReaderIndex();
            TChannelBufferInputTransport inputTransport = new TChannelBufferInputTransport(messageBuffer);
            TProtocol inputProtocol = this.getProtocolFactory().getInputProtocolFactory().getProtocol((TTransport)inputTransport);
            TMessage message = inputProtocol.readMessageBegin();
            messageBuffer.resetReaderIndex();
            return message.seqid;
        }
        catch (Throwable t) {
            throw new TTransportException("Could not find sequenceId in Thrift message");
        }
    }

    protected abstract ChannelFuture writeRequest(ChannelBuffer var1);

    @Override
    public void close() {
        this.getNettyChannel().close();
    }

    @Override
    public void setSendTimeout(@Nullable Duration sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    @Override
    public Duration getSendTimeout() {
        return this.sendTimeout;
    }

    @Override
    public void setReceiveTimeout(@Nullable Duration receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    @Override
    public Duration getReceiveTimeout() {
        return this.receiveTimeout;
    }

    @Override
    public void setReadTimeout(@Nullable Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public boolean hasError() {
        return this.channelError != null;
    }

    @Override
    public TException getError() {
        return this.channelError;
    }

    @Override
    public void executeInIoThread(Runnable runnable) {
        NioSocketChannel nioSocketChannel = (NioSocketChannel)this.getNettyChannel();
        nioSocketChannel.getWorker().executeInIoThread(runnable, true);
    }

    @Override
    public void sendAsynchronousRequest(final ChannelBuffer message, final boolean oneway, final NiftyClientChannel.Listener listener) throws TException {
        final int sequenceId = this.extractSequenceId(message);
        this.executeInIoThread(new Runnable(){

            @Override
            public void run() {
                try {
                    final Request request = AbstractClientChannel.this.makeRequest(sequenceId, listener);
                    if (!AbstractClientChannel.this.nettyChannel.isConnected()) {
                        AbstractClientChannel.this.onError((Throwable)new TTransportException("Channel closed"));
                        return;
                    }
                    ChannelFuture sendFuture = AbstractClientChannel.this.writeRequest(message);
                    AbstractClientChannel.this.queueSendTimeout(request);
                    sendFuture.addListener(new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            AbstractClientChannel.this.messageSent(future, request, oneway);
                        }
                    });
                }
                catch (Throwable t) {
                    AbstractClientChannel.this.requestMap.remove(sequenceId);
                    AbstractClientChannel.this.fireChannelErrorCallback(listener, t);
                    AbstractClientChannel.this.onError(t);
                }
            }
        });
    }

    private void messageSent(ChannelFuture future, Request request, boolean oneway) {
        try {
            if (future.isSuccess()) {
                this.cancelRequestTimeouts(request);
                this.fireRequestSentCallback(request.getListener());
                if (oneway) {
                    this.retireRequest(request);
                } else {
                    this.queueReceiveAndReadTimeout(request);
                }
            } else {
                TTransportException transportException = new TTransportException("Sending request failed", future.getCause());
                this.onError((Throwable)transportException);
            }
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        try {
            ChannelBuffer response = this.extractResponse(e.getMessage());
            if (response != null) {
                int sequenceId = this.extractSequenceId(response);
                this.onResponseReceived(sequenceId, response);
            } else {
                ctx.sendUpstream((ChannelEvent)e);
            }
        }
        catch (Throwable t) {
            this.onError(t);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) throws Exception {
        Throwable t = event.getCause();
        ctx.getChannel().close();
        this.onError(t);
    }

    private Request makeRequest(int sequenceId, NiftyClientChannel.Listener listener) {
        Request request = new Request(listener);
        this.requestMap.put(sequenceId, request);
        return request;
    }

    private void retireRequest(Request request) {
        this.cancelRequestTimeouts(request);
    }

    private void cancelRequestTimeouts(Request request) {
        Timeout readTimeout;
        Timeout receiveTimeout;
        Timeout sendTimeout = request.getSendTimeout();
        if (sendTimeout != null && !sendTimeout.isCancelled()) {
            sendTimeout.cancel();
        }
        if ((receiveTimeout = request.getReceiveTimeout()) != null && !receiveTimeout.isCancelled()) {
            receiveTimeout.cancel();
        }
        if ((readTimeout = request.getReadTimeout()) != null && !readTimeout.isCancelled()) {
            readTimeout.cancel();
        }
    }

    private void cancelAllTimeouts() {
        for (Request request : this.requestMap.values()) {
            this.cancelRequestTimeouts(request);
        }
    }

    private void onResponseReceived(int sequenceId, ChannelBuffer response) {
        Request request = this.requestMap.remove(sequenceId);
        if (request == null) {
            this.onError((Throwable)new TTransportException("Bad sequence id in response: " + sequenceId));
        } else {
            this.retireRequest(request);
            this.fireResponseReceivedCallback(request.getListener(), response);
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.onError((Throwable)new TTransportException("Client was disconnected by server"));
    }

    protected void onError(Throwable t) {
        TException wrappedException = this.wrapException(t);
        if (this.channelError == null) {
            this.channelError = wrappedException;
        }
        this.cancelAllTimeouts();
        ArrayList<Request> requests = new ArrayList<Request>();
        requests.addAll(this.requestMap.values());
        this.requestMap.clear();
        for (Request request : requests) {
            this.fireChannelErrorCallback(request.getListener(), wrappedException);
        }
    }

    protected TException wrapException(Throwable t) {
        if (t instanceof TException) {
            return (TException)t;
        }
        return new TTransportException(t);
    }

    private void fireRequestSentCallback(NiftyClientChannel.Listener listener) {
        try {
            listener.onRequestSent();
        }
        catch (Throwable t) {
            LOGGER.warn("Request sent listener callback triggered an exception: {}", t);
        }
    }

    private void fireResponseReceivedCallback(NiftyClientChannel.Listener listener, ChannelBuffer response) {
        try {
            listener.onResponseReceived(response);
        }
        catch (Throwable t) {
            LOGGER.warn("Response received listener callback triggered an exception: {}", t);
        }
    }

    private void fireChannelErrorCallback(NiftyClientChannel.Listener listener, TException exception) {
        try {
            listener.onChannelError(exception);
        }
        catch (Throwable t) {
            LOGGER.warn("Channel error listener callback triggered an exception: {}", t);
        }
    }

    private void fireChannelErrorCallback(NiftyClientChannel.Listener listener, Throwable throwable) {
        this.fireChannelErrorCallback(listener, this.wrapException(throwable));
    }

    private void onSendTimeoutFired(Request request) {
        this.cancelAllTimeouts();
        WriteTimeoutException timeoutException = new WriteTimeoutException("Timed out waiting " + this.getSendTimeout() + " to send data to server");
        this.fireChannelErrorCallback(request.getListener(), (Throwable)timeoutException);
    }

    private void onReceiveTimeoutFired(Request request) {
        this.cancelAllTimeouts();
        ReadTimeoutException timeoutException = new ReadTimeoutException("Timed out waiting " + this.getReceiveTimeout() + " to receive response");
        this.fireChannelErrorCallback(request.getListener(), (Throwable)timeoutException);
    }

    private void onReadTimeoutFired(Request request) {
        this.cancelAllTimeouts();
        ReadTimeoutException timeoutException = new ReadTimeoutException("Timed out waiting " + this.getReadTimeout() + " to read data from server");
        this.fireChannelErrorCallback(request.getListener(), (Throwable)timeoutException);
    }

    private void queueSendTimeout(final Request request) throws TTransportException {
        long sendTimeoutMs;
        if (this.sendTimeout != null && (sendTimeoutMs = this.sendTimeout.toMillis()) > 0L) {
            Timeout sendTimeout;
            IoThreadBoundTimerTask sendTimeoutTask = new IoThreadBoundTimerTask(this, new TimerTask(){

                public void run(Timeout timeout) {
                    AbstractClientChannel.this.onSendTimeoutFired(request);
                }
            });
            try {
                sendTimeout = this.timer.newTimeout((TimerTask)sendTimeoutTask, sendTimeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (IllegalStateException e) {
                throw new TTransportException("Unable to schedule send timeout");
            }
            request.setSendTimeout(sendTimeout);
        }
    }

    private void queueReceiveAndReadTimeout(final Request request) throws TTransportException {
        long readTimeoutNanos;
        Timeout timeout;
        long receiveTimeoutMs;
        if (this.receiveTimeout != null && (receiveTimeoutMs = this.receiveTimeout.toMillis()) > 0L) {
            IoThreadBoundTimerTask receiveTimeoutTask = new IoThreadBoundTimerTask(this, new TimerTask(){

                public void run(Timeout timeout) {
                    AbstractClientChannel.this.onReceiveTimeoutFired(request);
                }
            });
            try {
                timeout = this.timer.newTimeout((TimerTask)receiveTimeoutTask, receiveTimeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (IllegalStateException e) {
                throw new TTransportException("Unable to schedule request timeout");
            }
            request.setReceiveTimeout(timeout);
        }
        if (this.readTimeout != null && (readTimeoutNanos = this.readTimeout.roundTo(TimeUnit.NANOSECONDS)) > 0L) {
            IoThreadBoundTimerTask readTimeoutTask = new IoThreadBoundTimerTask(this, new ReadTimeoutTask(readTimeoutNanos, request));
            try {
                timeout = this.timer.newTimeout((TimerTask)readTimeoutTask, readTimeoutNanos, TimeUnit.NANOSECONDS);
            }
            catch (IllegalStateException e) {
                throw new TTransportException("Unable to schedule read timeout");
            }
            request.setReadTimeout(timeout);
        }
    }

    private final class ReadTimeoutTask
    implements TimerTask {
        private final TimeoutHandler timeoutHandler;
        private final long timeoutNanos;
        private final Request request;

        ReadTimeoutTask(long timeoutNanos, Request request) {
            this.timeoutHandler = TimeoutHandler.findTimeoutHandler(AbstractClientChannel.this.getNettyChannel().getPipeline());
            this.timeoutNanos = timeoutNanos;
            this.request = request;
        }

        public void run(Timeout timeout) throws Exception {
            if (this.timeoutHandler == null) {
                return;
            }
            if (timeout.isCancelled()) {
                return;
            }
            if (!AbstractClientChannel.this.getNettyChannel().isOpen()) {
                return;
            }
            long currentTimeNanos = System.nanoTime();
            long timePassed = currentTimeNanos - this.timeoutHandler.getLastMessageReceivedNanos();
            long nextDelayNanos = this.timeoutNanos - timePassed;
            if (nextDelayNanos <= 0L) {
                AbstractClientChannel.this.onReadTimeoutFired(this.request);
            } else {
                this.request.setReadTimeout(AbstractClientChannel.this.timer.newTimeout((TimerTask)this, nextDelayNanos, TimeUnit.NANOSECONDS));
            }
        }
    }

    private static class Request {
        private final NiftyClientChannel.Listener listener;
        private Timeout sendTimeout;
        private Timeout receiveTimeout;
        private volatile Timeout readTimeout;

        public Request(NiftyClientChannel.Listener listener) {
            this.listener = listener;
        }

        public NiftyClientChannel.Listener getListener() {
            return this.listener;
        }

        public Timeout getReceiveTimeout() {
            return this.receiveTimeout;
        }

        public void setReceiveTimeout(Timeout receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        public Timeout getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Timeout readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Timeout getSendTimeout() {
            return this.sendTimeout;
        }

        public void setSendTimeout(Timeout sendTimeout) {
            this.sendTimeout = sendTimeout;
        }
    }

    private static class IoThreadBoundTimerTask
    implements TimerTask {
        private final NiftyClientChannel channel;
        private final TimerTask timerTask;

        public IoThreadBoundTimerTask(NiftyClientChannel channel, TimerTask timerTask) {
            this.channel = channel;
            this.timerTask = timerTask;
        }

        public void run(final Timeout timeout) throws Exception {
            this.channel.executeInIoThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        IoThreadBoundTimerTask.this.timerTask.run(timeout);
                    }
                    catch (Exception e) {
                        Channels.fireExceptionCaught((Channel)IoThreadBoundTimerTask.this.channel.getNettyChannel(), (Throwable)e);
                    }
                }
            });
        }
    }
}

