/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.BufferBoundsException;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.SuppressWarnings;
import java.io.IOException;

public class ByteArrayReader
extends RandomAccessReader {
    @NotNull
    private final byte[] _buffer;

    @SuppressWarnings(value="EI_EXPOSE_REP2", justification="Design intent")
    public ByteArrayReader(@NotNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException();
        }
        this._buffer = buffer;
    }

    public long getLength() {
        return this._buffer.length;
    }

    protected byte getByte(int index) throws IOException {
        return this._buffer[index];
    }

    protected void validateIndex(int index, int bytesRequested) throws IOException {
        if (!this.isValidIndex(index, bytesRequested)) {
            throw new BufferBoundsException(index, bytesRequested, this._buffer.length);
        }
    }

    protected boolean isValidIndex(int index, int bytesRequested) throws IOException {
        return bytesRequested >= 0 && index >= 0 && (long)index + (long)bytesRequested - 1L < (long)this._buffer.length;
    }

    @NotNull
    public byte[] getBytes(int index, int count) throws IOException {
        this.validateIndex(index, count);
        byte[] bytes = new byte[count];
        System.arraycopy(this._buffer, index, bytes, 0, count);
        return bytes;
    }
}

