/*
 * Decompiled with CFR 0.152.
 */
package com.daedafusion.jetcd.impl;

import com.daedafusion.jetcd.EtcdClient;
import com.daedafusion.jetcd.EtcdClientException;
import com.daedafusion.jetcd.EtcdNode;
import com.daedafusion.jetcd.EtcdResult;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class EtcdClientImpl
implements EtcdClient {
    private static final Logger log = Logger.getLogger(EtcdClientImpl.class);
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final CloseableHttpAsyncClient client = HttpAsyncClients.createDefault();
    private static final String ROOT_PREFIX = "v2/keys";
    private URI baseUri;

    public EtcdClientImpl(String uri) {
        this.client.start();
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        this.baseUri = URI.create(uri);
    }

    @Override
    public EtcdResult get(String key) throws EtcdClientException {
        URI uri = this.buildUri(ROOT_PREFIX, key, "");
        HttpGet request = new HttpGet(uri);
        EtcdResult result = this.syncExecute((HttpUriRequest)request, new int[]{200, 404}, 100);
        if (result.getErrorCode() != null && result.getErrorCode() == 100) {
            return null;
        }
        return result;
    }

    @Override
    public EtcdResult delete(String key) throws EtcdClientException {
        URI uri = this.buildUri(ROOT_PREFIX, key, "");
        HttpDelete request = new HttpDelete(uri);
        return this.syncExecute((HttpUriRequest)request, new int[]{200, 404}, new int[0]);
    }

    @Override
    public EtcdResult set(String key, String value) throws EtcdClientException {
        return this.set(key, value, null);
    }

    @Override
    public EtcdResult set(String key, String value, Integer ttl) throws EtcdClientException {
        ArrayList data = Lists.newArrayList();
        data.add(new BasicNameValuePair("value", value));
        if (ttl != null) {
            data.add(new BasicNameValuePair("ttl", Integer.toString(ttl)));
        }
        return this.set0(key, "", data, new int[]{200, 201}, new int[0]);
    }

    @Override
    public EtcdResult refreshDirectory(String key, Integer ttl) throws EtcdClientException {
        ArrayList data = Lists.newArrayList();
        data.add(new BasicNameValuePair("dir", "true"));
        data.add(new BasicNameValuePair("prevExist", "true"));
        if (ttl != null) {
            data.add(new BasicNameValuePair("ttl", Integer.toString(ttl)));
        }
        return this.set0(key, "", data, new int[]{200, 201}, new int[0]);
    }

    @Override
    public EtcdResult createDirectory(String key) throws EtcdClientException {
        return this.createDirectory(key, null);
    }

    @Override
    public EtcdResult createDirectory(String key, Integer ttl) throws EtcdClientException {
        ArrayList data = Lists.newArrayList();
        data.add(new BasicNameValuePair("dir", "true"));
        if (ttl != null) {
            data.add(new BasicNameValuePair("ttl", Integer.toString(ttl)));
        }
        return this.set0(key, "", data, new int[]{200, 201}, new int[0]);
    }

    @Override
    public List<EtcdNode> listDirectory(String key) throws EtcdClientException {
        EtcdResult result = this.get(key.endsWith("/") ? key : key + "/");
        if (result == null || result.getNode() == null || result.getNode().getNodes() == null) {
            return new ArrayList<EtcdNode>();
        }
        return result.getNode().getNodes();
    }

    @Override
    public EtcdResult deleteDirectory(String key) throws EtcdClientException {
        URI uri = this.buildUri(ROOT_PREFIX, key, "?dir=true");
        HttpDelete request = new HttpDelete(uri);
        return this.syncExecute((HttpUriRequest)request, new int[]{202, 200}, new int[0]);
    }

    @Override
    public EtcdResult deleteDirectoryRecursive(String key) throws EtcdClientException {
        URI uri = this.buildUri(ROOT_PREFIX, key, "?recursive=true");
        HttpDelete request = new HttpDelete(uri);
        return this.syncExecute((HttpUriRequest)request, new int[]{202, 200}, new int[0]);
    }

    @Override
    public EtcdResult compareAndSet(String key, String prevValue, String value) throws EtcdClientException {
        ArrayList data = Lists.newArrayList();
        data.add(new BasicNameValuePair("value", value));
        data.add(new BasicNameValuePair("prevValue", prevValue));
        return this.set0(key, "", data, new int[]{200, 412}, 101);
    }

    @Override
    public EtcdResult compareAndSet(String key, Integer prevIndex, String value) throws EtcdClientException {
        ArrayList data = Lists.newArrayList();
        data.add(new BasicNameValuePair("value", value));
        data.add(new BasicNameValuePair("prevIndex", prevIndex.toString()));
        return this.set0(key, "", data, new int[]{200, 412}, 101);
    }

    @Override
    public EtcdResult compareAndDelete(String key, String prevValue) throws EtcdClientException {
        URI uri = this.buildUri(ROOT_PREFIX, key, String.format("?prevValue=%s", this.urlEscape(prevValue)));
        HttpDelete request = new HttpDelete(uri);
        return this.syncExecute((HttpUriRequest)request, new int[]{200, 412}, 101);
    }

    @Override
    public EtcdResult compareAndDelete(String key, Integer prevIndex) throws EtcdClientException {
        URI uri = this.buildUri(ROOT_PREFIX, key, String.format("?prevIndex=%d", prevIndex));
        HttpDelete request = new HttpDelete(uri);
        return this.syncExecute((HttpUriRequest)request, new int[]{200, 412}, 101);
    }

    @Override
    public ListenableFuture<EtcdResult> watch(String key) throws EtcdClientException {
        return this.watch(key, null, false);
    }

    @Override
    public ListenableFuture<EtcdResult> watch(String key, boolean recursive) throws EtcdClientException {
        return this.watch(key, null, recursive);
    }

    @Override
    public ListenableFuture<EtcdResult> watch(String key, Long index, boolean recursive) throws EtcdClientException {
        String suffix = "?wait=true";
        if (index != null) {
            suffix = suffix + String.format("&waitIndex=%d", index.intValue());
        }
        if (recursive) {
            suffix = suffix + "&recursive=true";
        }
        URI uri = this.buildUri(ROOT_PREFIX, key, suffix);
        HttpGet request = new HttpGet(uri);
        return this.asyncExecute((HttpUriRequest)request, new int[]{200}, new int[0]);
    }

    @Override
    public EtcdResult queue(String key, String value) throws EtcdClientException {
        URI uri = this.buildUri(ROOT_PREFIX, key, "");
        HttpPost request = new HttpPost(uri);
        ArrayList data = Lists.newArrayList();
        data.add(new BasicNameValuePair("value", value));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity((Iterable)data, Charsets.UTF_8);
        request.setEntity((HttpEntity)entity);
        return this.syncExecute((HttpUriRequest)request, new int[]{200}, new int[0]);
    }

    @Override
    public EtcdResult getQueue(String key) throws EtcdClientException {
        URI uri = this.buildUri(ROOT_PREFIX, key, "?recursive=true&sorted=true");
        HttpGet request = new HttpGet(uri);
        return this.syncExecute((HttpUriRequest)request, new int[]{200}, new int[0]);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    protected EtcdResult set0(String key, String suffix, List<BasicNameValuePair> data, int[] httpErrorCodes, int ... expectedErrorCodes) throws EtcdClientException {
        URI uri = this.buildUri(ROOT_PREFIX, key, suffix);
        HttpPut request = new HttpPut(uri);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(data, Charsets.UTF_8);
        request.setEntity((HttpEntity)entity);
        return this.syncExecute((HttpUriRequest)request, httpErrorCodes, expectedErrorCodes);
    }

    protected URI buildUri(String prefix, String key, String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (key.startsWith("/")) {
            key = key.substring(1);
        }
        for (String token : Splitter.on((char)'/').split((CharSequence)key)) {
            sb.append("/");
            sb.append(this.urlEscape(token));
        }
        sb.append(suffix);
        return this.baseUri.resolve(sb.toString());
    }

    protected String urlEscape(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)"URLEncoder Error", (Throwable)e);
            return s;
        }
    }

    protected EtcdResult syncExecute(HttpUriRequest request, int[] expectedHttpStatusCodes, int ... expectedErrorCodes) throws EtcdClientException {
        try {
            return (EtcdResult)this.asyncExecute(request, expectedHttpStatusCodes, expectedErrorCodes).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new EtcdClientException("Request Interrupted", e);
        }
        catch (ExecutionException e) {
            throw this.unwrap(e);
        }
    }

    protected ListenableFuture<EtcdResult> asyncExecute(HttpUriRequest request, int[] expectedHttpStatusCodes, final int ... expectedErrorCodes) {
        ListenableFuture<JsonResponse> jsonFuture = this.asyncExecuteJson(request, expectedHttpStatusCodes);
        return Futures.transform(jsonFuture, (AsyncFunction)new AsyncFunction<JsonResponse, EtcdResult>(){

            public ListenableFuture<EtcdResult> apply(JsonResponse jsonResponse) throws Exception {
                EtcdResult result = EtcdClientImpl.this.jsonToEtcdResult(jsonResponse, expectedErrorCodes);
                return Futures.immediateFuture((Object)result);
            }
        });
    }

    protected ListenableFuture<JsonResponse> asyncExecuteJson(HttpUriRequest request, final int[] expectedHttpStatusCodes) {
        ListenableFuture<HttpResponse> response = this.asyncExecuteHttp(request);
        return Futures.transform(response, (AsyncFunction)new AsyncFunction<HttpResponse, JsonResponse>(){

            public ListenableFuture<JsonResponse> apply(HttpResponse httpResponse) throws Exception {
                JsonResponse json = EtcdClientImpl.this.extractJsonResponse(httpResponse, expectedHttpStatusCodes);
                return Futures.immediateFuture((Object)json);
            }
        });
    }

    protected ListenableFuture<HttpResponse> asyncExecuteHttp(HttpUriRequest request) {
        final SettableFuture future = SettableFuture.create();
        this.client.execute(request, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse result) {
                future.set((Object)result);
            }

            public void failed(Exception e) {
                future.setException((Throwable)e);
            }

            public void cancelled() {
                future.setException((Throwable)new InterruptedException());
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JsonResponse extractJsonResponse(HttpResponse response, int[] expectedHttpStatusCodes) throws EtcdClientException {
        try {
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            String json = null;
            if (response.getEntity() != null) {
                try {
                    json = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException e) {
                    throw new EtcdClientException("Error extracting response entity", e);
                }
            }
            if (!(this.contains(expectedHttpStatusCodes, statusCode) || statusCode == 400 && json != null)) {
                throw new EtcdClientException(String.format("etcd error :: %s", statusLine.getReasonPhrase()), statusCode);
            }
            JsonResponse jsonResponse = new JsonResponse(json, statusCode);
            return jsonResponse;
        }
        finally {
            HttpEntity entity;
            if (response != null && (entity = response.getEntity()) != null) {
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
    }

    protected EtcdResult jsonToEtcdResult(JsonResponse response, int ... expectedErrorCodes) throws EtcdClientException {
        if (response == null || response.json == null) {
            return null;
        }
        EtcdResult result = this.parseEtcdResult(response.json);
        if (result.getErrorCode() != null && !this.contains(expectedErrorCodes, result.getErrorCode())) {
            throw new EtcdClientException(result.getMessage(), result);
        }
        return result;
    }

    protected EtcdResult parseEtcdResult(String json) throws EtcdClientException {
        EtcdResult result;
        try {
            result = (EtcdResult)this.mapper.readValue(json, EtcdResult.class);
        }
        catch (IOException e) {
            throw new EtcdClientException("Error parsing etcd response", e);
        }
        return result;
    }

    protected boolean contains(int[] haystack, int needle) {
        for (int i : haystack) {
            if (i != needle) continue;
            return true;
        }
        return false;
    }

    protected EtcdClientException unwrap(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof EtcdClientException) {
            return (EtcdClientException)cause;
        }
        return new EtcdClientException("Error executing request", e);
    }

    private static class JsonResponse {
        private final String json;
        private final int statusCode;

        public JsonResponse(String json, int statusCode) {
            this.json = json;
            this.statusCode = statusCode;
        }

        public String getJson() {
            return this.json;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

