/*
 * Decompiled with CFR 0.152.
 */
package com.daedafusion.jetcd;

import com.daedafusion.jetcd.EtcdResult;
import java.io.IOException;
import org.apache.log4j.Logger;

public class EtcdClientException
extends IOException {
    private static final Logger log = Logger.getLogger(EtcdClientException.class);
    private final Integer statusCode;
    private final EtcdResult result;

    public EtcdClientException(String message, Throwable cause) {
        super(message, cause);
        this.statusCode = null;
        this.result = null;
    }

    public EtcdClientException(String message, int httpStatusCode) {
        super(String.format("%s (%d)", message, httpStatusCode));
        this.statusCode = httpStatusCode;
        this.result = null;
    }

    public EtcdClientException(String message, EtcdResult result) {
        super(message);
        this.statusCode = null;
        this.result = result;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public EtcdResult getResult() {
        return this.result;
    }

    public boolean isHttpError(int statusCode) {
        return this.statusCode != null && this.statusCode == statusCode;
    }

    public boolean isEtcdError(int etcdCode) {
        return this.result != null && this.result.getErrorCode() != null && this.result.getErrorCode() == etcdCode;
    }
}

