/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.server.netty;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.server.CanalServer;
import com.alibaba.otter.canal.server.embedded.CanalServerWithEmbedded;
import com.alibaba.otter.canal.server.netty.handler.ClientAuthenticationHandler;
import com.alibaba.otter.canal.server.netty.handler.FixedHeaderFrameDecoder;
import com.alibaba.otter.canal.server.netty.handler.HandshakeInitializationHandler;
import com.alibaba.otter.canal.server.netty.handler.SessionHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class CanalServerWithNetty
extends AbstractCanalLifeCycle
implements CanalServer {
    private CanalServerWithEmbedded embeddedServer = CanalServerWithEmbedded.instance();
    private String ip;
    private int port;
    private Channel serverChannel = null;
    private ServerBootstrap bootstrap = null;

    private CanalServerWithNetty() {
    }

    public static CanalServerWithNetty instance() {
        return SingletonHolder.CANAL_SERVER_WITH_NETTY;
    }

    @Override
    public void start() {
        super.start();
        if (!this.embeddedServer.isStart()) {
            this.embeddedServer.start();
        }
        this.bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipelines = Channels.pipeline();
                pipelines.addLast(FixedHeaderFrameDecoder.class.getName(), (ChannelHandler)new FixedHeaderFrameDecoder());
                pipelines.addLast(HandshakeInitializationHandler.class.getName(), (ChannelHandler)new HandshakeInitializationHandler());
                pipelines.addLast(ClientAuthenticationHandler.class.getName(), (ChannelHandler)new ClientAuthenticationHandler(CanalServerWithNetty.this.embeddedServer));
                SessionHandler sessionHandler = new SessionHandler(CanalServerWithNetty.this.embeddedServer);
                pipelines.addLast(SessionHandler.class.getName(), (ChannelHandler)sessionHandler);
                return pipelines;
            }
        });
        this.serverChannel = StringUtils.isNotEmpty((String)this.ip) ? this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.ip, this.port)) : this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
    }

    @Override
    public void stop() {
        super.stop();
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly(1000L);
        }
        if (this.bootstrap != null) {
            this.bootstrap.releaseExternalResources();
        }
        if (this.embeddedServer.isStart()) {
            this.embeddedServer.stop();
        }
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setEmbeddedServer(CanalServerWithEmbedded embeddedServer) {
        this.embeddedServer = embeddedServer;
    }

    private static class SingletonHolder {
        private static final CanalServerWithNetty CANAL_SERVER_WITH_NETTY = new CanalServerWithNetty();

        private SingletonHolder() {
        }
    }
}

