/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.support.ibatis;

import com.alibaba.druid.stat.JdbcSqlStat;
import com.alibaba.druid.support.ibatis.IbatisUtils;
import com.alibaba.druid.support.ibatis.SqlMapSessionWrapper;
import com.ibatis.common.util.PaginatedList;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import com.ibatis.sqlmap.engine.execution.BatchException;
import com.ibatis.sqlmap.engine.impl.ExtendedSqlMapClient;
import com.ibatis.sqlmap.engine.impl.SqlMapClientImpl;
import com.ibatis.sqlmap.engine.impl.SqlMapSessionImpl;
import com.ibatis.sqlmap.engine.mapping.statement.MappedStatement;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SqlMapClientImplWrapper
extends SqlMapClientImpl {
    private SqlMapClientImpl raw;
    private static Method getLocalSqlMapSessionMethod = null;
    private ConcurrentMap<String, IbatisStatementInfo> statementInfoMap = new ConcurrentHashMap<String, IbatisStatementInfo>();

    public SqlMapClientImplWrapper(SqlMapClientImpl raw) {
        super(raw.getDelegate());
        this.raw = raw;
    }

    public void setLocal(String id, SqlMapExecutor executor) {
        IbatisStatementInfo stmtInfo = (IbatisStatementInfo)this.statementInfoMap.get(id);
        if (stmtInfo != null) {
            JdbcSqlStat.setContextSqlName(stmtInfo.getId());
            JdbcSqlStat.setContextSqlFile(stmtInfo.getResource());
            return;
        }
        MappedStatement statement = null;
        if (executor instanceof SqlMapSessionImpl) {
            statement = ((SqlMapSessionImpl)executor).getMappedStatement(id);
        }
        if (executor instanceof SqlMapClientImpl) {
            statement = ((SqlMapClientImpl)executor).getMappedStatement(id);
        }
        if (statement == null) {
            return;
        }
        String stmtId = IbatisUtils.getId(statement);
        String stmtResource = IbatisUtils.getResource(statement);
        stmtInfo = new IbatisStatementInfo(stmtId, stmtResource);
        this.statementInfoMap.putIfAbsent(id, stmtInfo);
        JdbcSqlStat.setContextSqlName(stmtId);
        JdbcSqlStat.setContextSqlFile(stmtResource);
    }

    protected SqlMapSessionWrapper getLocalSqlMapSessionWrapper() {
        try {
            if (getLocalSqlMapSessionMethod == null) {
                getLocalSqlMapSessionMethod = this.raw.getClass().getDeclaredMethod("getLocalSqlMapSession", new Class[0]);
                getLocalSqlMapSessionMethod.setAccessible(true);
            }
            SqlMapSessionImpl sessionImpl = (SqlMapSessionImpl)getLocalSqlMapSessionMethod.invoke((Object)this.raw, new Object[0]);
            IbatisUtils.set(sessionImpl, this);
            return new SqlMapSessionWrapper((ExtendedSqlMapClient)this.raw, (SqlMapSession)sessionImpl);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public SqlMapSession openSession(Connection conn) {
        SqlMapSession session = this.raw.openSession(conn);
        IbatisUtils.setClientImpl((SqlMapExecutor)session, this);
        return new SqlMapSessionWrapper((ExtendedSqlMapClient)this.raw, session);
    }

    public SqlMapSession getSession() {
        SqlMapSession session = this.raw.getSession();
        IbatisUtils.setClientImpl((SqlMapExecutor)session, this);
        return new SqlMapSessionWrapper((ExtendedSqlMapClient)this.raw, session);
    }

    public Object insert(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().insert(id, param);
    }

    public Object insert(String id) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().insert(id);
    }

    public int update(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().update(id, param);
    }

    public int update(String id) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().update(id);
    }

    public int delete(String id, Object param) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().delete(id, param);
    }

    public int delete(String id) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().delete(id);
    }

    public Object queryForObject(String id, Object paramObject) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().queryForObject(id, paramObject);
    }

    public Object queryForObject(String id) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().queryForObject(id);
    }

    public Object queryForObject(String id, Object paramObject, Object resultObject) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().queryForObject(id, paramObject, resultObject);
    }

    public List queryForList(String id, Object paramObject) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().queryForList(id, paramObject);
    }

    public List queryForList(String id) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().queryForList(id);
    }

    public List queryForList(String id, Object paramObject, int skip, int max) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().queryForList(id, paramObject, skip, max);
    }

    public List queryForList(String id, int skip, int max) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().queryForList(id, skip, max);
    }

    public PaginatedList queryForPaginatedList(String id, Object paramObject, int pageSize) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().queryForPaginatedList(id, paramObject, pageSize);
    }

    public PaginatedList queryForPaginatedList(String id, int pageSize) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().queryForPaginatedList(id, pageSize);
    }

    public Map queryForMap(String id, Object paramObject, String keyProp) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().queryForMap(id, paramObject, keyProp);
    }

    public Map queryForMap(String id, Object paramObject, String keyProp, String valueProp) throws SQLException {
        return this.getLocalSqlMapSessionWrapper().queryForMap(id, paramObject, keyProp, valueProp);
    }

    public void queryWithRowHandler(String id, Object paramObject, RowHandler rowHandler) throws SQLException {
        this.getLocalSqlMapSessionWrapper().queryWithRowHandler(id, paramObject, rowHandler);
    }

    public void queryWithRowHandler(String id, RowHandler rowHandler) throws SQLException {
        this.getLocalSqlMapSessionWrapper().queryWithRowHandler(id, rowHandler);
    }

    public void startTransaction() throws SQLException {
        this.getLocalSqlMapSessionWrapper().startTransaction();
    }

    public void startTransaction(int transactionIsolation) throws SQLException {
        this.getLocalSqlMapSessionWrapper().startTransaction(transactionIsolation);
    }

    public void commitTransaction() throws SQLException {
        this.getLocalSqlMapSessionWrapper().commitTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() throws SQLException {
        try {
            this.getLocalSqlMapSessionWrapper().endTransaction();
        }
        finally {
            this.getLocalSqlMapSessionWrapper().close();
        }
    }

    public void startBatch() throws SQLException {
        this.getLocalSqlMapSessionWrapper().startBatch();
    }

    public int executeBatch() throws SQLException {
        return this.getLocalSqlMapSessionWrapper().executeBatch();
    }

    public List executeBatchDetailed() throws SQLException, BatchException {
        return this.getLocalSqlMapSessionWrapper().executeBatchDetailed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserConnection(Connection connection) throws SQLException {
        try {
            this.getLocalSqlMapSessionWrapper().setUserConnection(connection);
        }
        finally {
            if (connection == null) {
                this.getLocalSqlMapSessionWrapper().close();
            }
        }
    }

    public static class IbatisStatementInfo {
        private final String id;
        private final String resource;

        public IbatisStatementInfo(String id, String resource) {
            this.id = id;
            this.resource = resource;
        }

        public String getId() {
            return this.id;
        }

        public String getResource() {
            return this.resource;
        }
    }
}

