/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.postgresql.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGWithClause;
import com.alibaba.druid.sql.dialect.postgresql.ast.PGWithQuery;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGAnalytic;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGParameter;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGDeleteStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGFunctionTableSource;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGInsertStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectQueryBlock;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGSelectStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGTruncateStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;

public class PGOutputVisitor
extends SQLASTOutputVisitor
implements PGASTVisitor {
    public PGOutputVisitor(Appendable appender) {
        super(appender);
    }

    @Override
    public void endVisit(PGSelectQueryBlock.WindowClause x) {
    }

    @Override
    public boolean visit(PGSelectQueryBlock.WindowClause x) {
        this.print("WINDOW ");
        x.getName().accept(this);
        this.print(" AS ");
        for (int i = 0; i < x.getDefinition().size(); ++i) {
            if (i != 0) {
                this.println(", ");
            }
            this.print("(");
            x.getDefinition().get(i).accept(this);
            this.print(")");
        }
        return false;
    }

    @Override
    public void endVisit(PGSelectQueryBlock.FetchClause x) {
    }

    @Override
    public boolean visit(PGSelectQueryBlock.FetchClause x) {
        this.print("FETCH ");
        if (PGSelectQueryBlock.FetchClause.Option.FIRST.equals((Object)x.getOption())) {
            this.print("FIRST ");
        } else if (PGSelectQueryBlock.FetchClause.Option.NEXT.equals((Object)x.getOption())) {
            this.print("NEXT ");
        }
        x.getCount().accept(this);
        this.print(" ROWS ONLY");
        return false;
    }

    @Override
    public void endVisit(PGSelectQueryBlock.ForClause x) {
    }

    @Override
    public boolean visit(PGSelectQueryBlock.ForClause x) {
        this.print("FOR ");
        if (PGSelectQueryBlock.ForClause.Option.UPDATE.equals((Object)x.getOption())) {
            this.print("UPDATE ");
        } else if (PGSelectQueryBlock.ForClause.Option.SHARE.equals((Object)x.getOption())) {
            this.print("SHARE ");
        }
        if (x.getOf().size() > 0) {
            for (int i = 0; i < x.getOf().size(); ++i) {
                if (i != 0) {
                    this.println(", ");
                }
                x.getOf().get(i).accept(this);
            }
        }
        if (x.isNoWait()) {
            this.print(" NOWAIT");
        }
        return false;
    }

    @Override
    public void endVisit(PGWithQuery x) {
    }

    @Override
    public boolean visit(PGWithQuery x) {
        x.getName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(")");
        }
        this.println();
        this.print("AS");
        this.println();
        this.print("(");
        this.incrementIndent();
        this.println();
        x.getQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(PGWithClause x) {
    }

    @Override
    public boolean visit(PGWithClause x) {
        this.print("WITH");
        this.incrementIndent();
        this.println();
        this.printlnAndAccept(x.getWithQuery(), ", ");
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(PGSelectQueryBlock x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
            this.println();
        }
        this.print("SELECT ");
        if (1 == x.getDistionOption()) {
            this.print("ALL ");
        } else if (2 == x.getDistionOption()) {
            this.print("DISTINCT ");
            if (x.getDistinctOn() != null) {
                this.print("ON ");
                this.printAndAccept(x.getDistinctOn(), ", ");
            }
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            if (x.getIntoOption() != null) {
                this.print(x.getIntoOption().name());
                this.print(" ");
            }
            x.getInto().accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print("FROM ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        if (x.getWindow() != null) {
            this.println();
            x.getWindow().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        if (x.getLimit() != null) {
            this.println();
            this.print("LIMIT ");
            x.getLimit().accept(this);
        }
        if (x.getOffset() != null) {
            this.println();
            this.print("OFFSET ");
            x.getOffset().accept(this);
            this.print(" ROWS");
        }
        if (x.getFetch() != null) {
            this.println();
            x.getFetch().accept(this);
        }
        if (x.getForClause() != null) {
            this.println();
            x.getForClause().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(PGTruncateStatement x) {
    }

    @Override
    public boolean visit(PGTruncateStatement x) {
        this.print("TRUNCATE TABLE ");
        if (x.isOnly()) {
            this.print("ONLY ");
        }
        this.printlnAndAccept(x.getTableSources(), ", ");
        if (x.getRestartIdentity() != null) {
            if (x.getRestartIdentity().booleanValue()) {
                this.print(" RESTART IDENTITY");
            } else {
                this.print(" CONTINUE IDENTITY");
            }
        }
        if (x.getCascade() != null) {
            if (x.getCascade().booleanValue()) {
                this.print(" CASCADE");
            } else {
                this.print(" RESTRICT");
            }
        }
        return false;
    }

    @Override
    public void endVisit(PGDeleteStatement x) {
    }

    @Override
    public boolean visit(PGDeleteStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
            this.println();
        }
        this.print("DELETE FROM ");
        if (x.isOnly()) {
            this.print("ONLY ");
        }
        x.getTableName().accept(this);
        if (x.getAlias() != null) {
            this.print(" AS ");
            this.print(x.getAlias());
        }
        if (x.getUsing().size() > 0) {
            this.println();
            this.print("USING ");
            this.printAndAccept(x.getUsing(), ", ");
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.isReturning()) {
            this.println();
            this.print("RETURNING *");
        }
        return false;
    }

    @Override
    public void endVisit(PGInsertStatement x) {
    }

    @Override
    public boolean visit(PGInsertStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
            this.println();
        }
        this.print("INSERT INTO ");
        x.getTableName().accept(this);
        if (x.getColumns().size() > 0) {
            this.incrementIndent();
            this.println();
            this.print("(");
            int size = x.getColumns().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
            this.decrementIndent();
        }
        if (x.getValues() != null) {
            this.println();
            this.print("VALUES ");
            this.printlnAndAccept(x.getValuesList(), ", ");
        } else if (x.getQuery() != null) {
            this.println();
            x.getQuery().accept(this);
        }
        if (x.getReturning() != null) {
            this.println();
            this.print("RETURNING ");
            x.getReturning().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(PGSelectStatement x) {
    }

    @Override
    public boolean visit(PGSelectStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
            this.println();
        }
        return this.visit((SQLSelectStatement)x);
    }

    @Override
    public void endVisit(PGUpdateStatement x) {
    }

    @Override
    public boolean visit(PGUpdateStatement x) {
        if (x.getWith() != null) {
            x.getWith().accept(this);
            this.println();
        }
        this.print("UPDATE ");
        if (x.isOnly()) {
            this.print("ONLY ");
        }
        x.getTableSource().accept(this);
        this.println();
        this.print("SET ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getFrom() != null) {
            this.println();
            this.print("FROM ");
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getReturning().size() > 0) {
            this.println();
            this.print("RETURNING ");
            this.printAndAccept(x.getReturning(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(PGSelectQueryBlock x) {
    }

    @Override
    public void endVisit(PGAnalytic x) {
    }

    @Override
    public boolean visit(PGAnalytic x) {
        this.print(" OVER (");
        if (x.getPartitionBy().size() > 0) {
            int mark = 0;
            for (SQLExpr e : x.getPartitionBy()) {
                if (mark++ != 0) {
                    this.print(", ");
                }
                e.accept(this);
            }
        }
        if (x.getOrderBy() != null) {
            x.getOrderBy().accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(PGParameter x) {
    }

    @Override
    public boolean visit(PGParameter x) {
        x.getName().accept(this);
        this.print(" ");
        x.getDataType().accept(this);
        return false;
    }

    @Override
    public boolean visit(PGFunctionTableSource x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null) {
            this.print(" AS ");
            this.print(x.getAlias());
        }
        if (x.getParameters().size() > 0) {
            this.print('(');
            this.printAndAccept(x.getParameters(), ", ");
            this.print(')');
        }
        return false;
    }

    @Override
    public void endVisit(PGFunctionTableSource x) {
    }
}

