/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.visitor;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLObjectCreateExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLCharactorDataType;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeIntervalDay;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeIntervalYear;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeTimestamp;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleOrderBy;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.CycleClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.FlashbackQueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.GroupingSetExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.ModelClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleErrorLoggingClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleParameter;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OraclePartitionByRangeClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleRangeValuesClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleReturningClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleWithSubqueryEntry;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.PartitionExtensionClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SampleClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SearchClause;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAggregateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalytic;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalyticWindowing;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleArgumentExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleBinaryDoubleExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleBinaryFloatExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleCursorExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDatetimeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDbLinkExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleExtractExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIntervalExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIsSetExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleOuterExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleRangeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleSizeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleSysdateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleTimestampExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterIndexStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterProcedureStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterSessionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterSynonymStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableAddConstaint;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableDropPartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableModify;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableMoveTablespace;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableRenameTo;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableSplitPartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableTruncatePartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTablespaceAddDataFile;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTablespaceStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTriggerStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterViewStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleBlockStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCommitStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleConstraintState;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateDatabaseDbLinkStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateIndexStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateProcedureStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateSequenceStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDropDatabaseLinkStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDropSequenceStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExceptionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExitStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExplainStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExprStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleFetchStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleFileSpecification;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleGotoStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleGrantStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleIfStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleLabelStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleLockTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleLoopStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMergeStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleOrderByItem;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePLSQLCommitStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePrimaryKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSavePointStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelect;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectForUpdate;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectHierachicalQueryClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectJoin;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectRestriction;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectUnPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSetTransactionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleTableExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleTruncateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateSetListClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateSetListMultiColumnItem;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateSetListSingleColumnItem;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateSetValueClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import java.util.List;

public class OracleOutputVisitor
extends SQLASTOutputVisitor
implements OracleASTVisitor {
    private final boolean printPostSemi;

    public OracleOutputVisitor(Appendable appender) {
        this(appender, true);
    }

    public OracleOutputVisitor(Appendable appender, boolean printPostSemi) {
        super(appender);
        this.printPostSemi = printPostSemi;
    }

    public boolean isPrintPostSemi() {
        return this.printPostSemi;
    }

    @Override
    public void postVisit(SQLObject x) {
        if (!this.printPostSemi) {
            return;
        }
        if (x instanceof SQLStatement) {
            if (x instanceof OraclePLSQLCommitStatement) {
                return;
            }
            if (x.getParent() instanceof OracleCreateProcedureStatement) {
                return;
            }
            if (this.isPrettyFormat()) {
                if (x.getParent() != null) {
                    this.print(";");
                } else {
                    this.println(";");
                }
            }
        }
    }

    private void printHints(List<SQLHint> hints) {
        if (hints.size() > 0) {
            this.print("/*+ ");
            this.printAndAccept(hints, ", ");
            this.print(" */");
        }
    }

    @Override
    public boolean visit(OracleAggregateExpr expr) {
        this.print(expr.getMethodName());
        this.print("(");
        if (expr.getOption() != null) {
            this.print(expr.getOption().toString());
            this.print(' ');
        }
        this.printAndAccept(expr.getArguments(), ", ");
        this.print(")");
        if (expr.getOver() != null) {
            this.print(" OVER (");
            expr.getOver().accept(this);
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(SQLAllColumnExpr x) {
        this.print("*");
        return false;
    }

    @Override
    public boolean visit(OracleAnalytic x) {
        boolean space = false;
        if (x.getPartitionBy().size() > 0) {
            this.print("PARTITION BY ");
            this.printAndAccept(x.getPartitionBy(), ", ");
            space = true;
        }
        if (x.getOrderBy() != null) {
            if (space) {
                this.print(" ");
            }
            x.getOrderBy().accept(this);
            space = true;
        }
        if (x.getWindowing() != null) {
            if (space) {
                this.print(" ");
            }
            x.getWindowing().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleAnalyticWindowing x) {
        this.print(x.getType().name().toUpperCase());
        this.print(" ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public boolean visit(OracleDateExpr x) {
        this.print("DATE '");
        this.print(x.getLiteral());
        this.print('\'');
        return false;
    }

    @Override
    public boolean visit(OracleDbLinkExpr x) {
        x.getExpr().accept(this);
        this.print("@");
        this.print(x.getDbLink());
        return false;
    }

    @Override
    public boolean visit(OracleDeleteStatement x) {
        if (x.getTableName() != null) {
            this.print("DELETE ");
            this.printHints(x.getHints());
            this.print("FROM ");
            if (x.isOnly()) {
                this.print("ONLY (");
                x.getTableName().accept(this);
                this.print(")");
            } else {
                x.getTableName().accept(this);
            }
            this.printAlias(x.getAlias());
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getReturning() != null) {
            this.println();
            x.getReturning().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleExtractExpr x) {
        this.print("EXTRACT(");
        this.print(x.getUnit().name());
        this.print(" FROM ");
        x.getFrom().accept(this);
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(OracleIntervalExpr x) {
        if (x.getValue() instanceof SQLLiteralExpr) {
            this.print("INTERVAL ");
            x.getValue().accept(this);
            this.print(" ");
        } else {
            this.print('(');
            x.getValue().accept(this);
            this.print(") ");
        }
        this.print(x.getType().name());
        if (x.getPrecision() != null) {
            this.print("(");
            this.print(x.getPrecision());
            if (x.getFactionalSecondsPrecision() != null) {
                this.print(", ");
                this.print(x.getFactionalSecondsPrecision());
            }
            this.print(")");
        }
        if (x.getToType() != null) {
            this.print(" TO ");
            this.print(x.getToType().name());
            if (x.getToFactionalSecondsPrecision() != null) {
                this.print("(");
                this.print(x.getToFactionalSecondsPrecision());
                this.print(")");
            }
        }
        return false;
    }

    @Override
    public boolean visit(OracleOrderBy x) {
        if (x.getItems().size() > 0) {
            this.print("ORDER ");
            if (x.isSibings()) {
                this.print("SIBLINGS ");
            }
            this.print("BY ");
            this.printAndAccept(x.getItems(), ", ");
        }
        return false;
    }

    @Override
    public boolean visit(OracleOuterExpr x) {
        x.getExpr().accept(this);
        this.print("(+)");
        return false;
    }

    @Override
    public boolean visit(OraclePLSQLCommitStatement astNode) {
        this.print("/");
        this.println();
        return false;
    }

    @Override
    public boolean visit(SQLSelect x) {
        if (x instanceof OracleSelect) {
            return this.visit((OracleSelect)x);
        }
        return super.visit(x);
    }

    @Override
    public boolean visit(OracleSelect x) {
        if (x.getWithSubQuery() != null) {
            x.getWithSubQuery().accept(this);
            this.println();
        }
        x.getQuery().accept(this);
        if (x.getRestriction() != null) {
            this.print(" ");
            x.getRestriction().accept(this);
        }
        if (x.getForUpdate() != null) {
            this.println();
            x.getForUpdate().accept(this);
        }
        if (x.getOrderBy() != null) {
            this.println();
            x.getOrderBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectForUpdate x) {
        this.print("FOR UPDATE");
        if (x.getOf().size() > 0) {
            this.print("(");
            this.printAndAccept(x.getOf(), ", ");
            this.print(")");
        }
        if (x.isNotWait()) {
            this.print(" NOWAIT");
        } else if (x.isSkipLocked()) {
            this.print(" SKIP LOCKED");
        } else if (x.getWait() != null) {
            this.print(" WAIT ");
            x.getWait().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectHierachicalQueryClause x) {
        if (x.getStartWith() != null) {
            this.print("START WITH ");
            x.getStartWith().accept(this);
            this.println();
        }
        this.print("CONNECT BY ");
        if (x.isNoCycle()) {
            this.print("NOCYCLE ");
        }
        if (x.isPrior()) {
            this.print("PRIOR ");
        }
        x.getConnectBy().accept(this);
        return false;
    }

    @Override
    public boolean visit(OracleSelectJoin x) {
        x.getLeft().accept(this);
        if (x.getJoinType() == SQLJoinTableSource.JoinType.COMMA) {
            this.print(", ");
            x.getRight().accept(this);
        } else {
            boolean isRoot = x.getParent() instanceof SQLSelectQueryBlock;
            if (isRoot) {
                this.incrementIndent();
            }
            this.println();
            this.print(SQLJoinTableSource.JoinType.toString(x.getJoinType()));
            this.print(" ");
            x.getRight().accept(this);
            if (isRoot) {
                this.decrementIndent();
            }
            if (x.getCondition() != null) {
                this.print(" ON ");
                x.getCondition().accept(this);
                this.print(" ");
            }
            if (x.getUsing().size() > 0) {
                this.print(" USING (");
                this.printAndAccept(x.getUsing(), ", ");
                this.print(")");
            }
            if (x.getFlashback() != null) {
                this.println();
                x.getFlashback().accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(OracleOrderByItem x) {
        x.getExpr().accept(this);
        if (x.getType() != null) {
            this.print(" ");
            this.print(x.getType().name().toUpperCase());
        }
        if (x.getNullsOrderType() != null) {
            this.print(" ");
            this.print(x.getNullsOrderType().toFormalString());
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectPivot x) {
        this.print("PIVOT");
        if (x.isXml()) {
            this.print(" XML");
        }
        this.print(" (");
        this.printAndAccept(x.getItems(), ", ");
        if (x.getPivotFor().size() > 0) {
            this.print(" FOR ");
            if (x.getPivotFor().size() == 1) {
                x.getPivotFor().get(0).accept(this);
            } else {
                this.print("(");
                this.printAndAccept(x.getPivotFor(), ", ");
                this.print(")");
            }
        }
        if (x.getPivotIn().size() > 0) {
            this.print(" IN (");
            this.printAndAccept(x.getPivotIn(), ", ");
            this.print(")");
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(OracleSelectPivot.Item x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null && x.getAlias().length() > 0) {
            this.print(" AS ");
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(SQLSelectQueryBlock select) {
        if (select instanceof OracleSelectQueryBlock) {
            return this.visit((OracleSelectQueryBlock)select);
        }
        return super.visit(select);
    }

    @Override
    public boolean visit(OracleSelectQueryBlock x) {
        this.print("SELECT ");
        if (1 == x.getDistionOption()) {
            this.print("ALL ");
        } else if (2 == x.getDistionOption()) {
            this.print("DISTINCT ");
        } else if (3 == x.getDistionOption()) {
            this.print("UNIQUE ");
        }
        if (x.getHints().size() > 0) {
            this.print("/*+");
            this.printAndAccept(x.getHints(), ", ");
            this.print("*/ ");
        }
        this.printSelectList(x.getSelectList());
        if (x.getInto() != null) {
            this.println();
            this.print("INTO ");
            x.getInto().accept(this);
        }
        this.println();
        this.print("FROM ");
        if (x.getFrom() == null) {
            this.print("DUAL");
        } else {
            x.getFrom().setParent(x);
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getHierachicalQueryClause() != null) {
            this.println();
            x.getHierachicalQueryClause().accept(this);
        }
        if (x.getGroupBy() != null) {
            this.println();
            x.getGroupBy().accept(this);
        }
        if (x.getModelClause() != null) {
            this.println();
            x.getModelClause().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectRestriction.CheckOption x) {
        this.print("CHECK OPTION");
        if (x.getConstraint() != null) {
            this.print(" ");
            x.getConstraint().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectRestriction.ReadOnly x) {
        this.print("READ ONLY");
        return false;
    }

    @Override
    public boolean visit(OracleSelectSubqueryTableSource x) {
        this.print("(");
        this.incrementIndent();
        this.println();
        x.getSelect().accept(this);
        this.decrementIndent();
        this.println();
        this.print(")");
        if (x.getPivot() != null) {
            this.println();
            x.getPivot().accept(this);
        }
        if (x.getFlashback() != null) {
            this.println();
            x.getFlashback().accept(this);
        }
        if (x.getAlias() != null && x.getAlias().length() != 0) {
            this.print(" ");
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectTableReference x) {
        if (x.isOnly()) {
            this.print("ONLY (");
            x.getExpr().accept(this);
            if (x.getPartition() != null) {
                this.print(" ");
                x.getPartition().accept(this);
            }
            this.print(")");
        } else {
            x.getExpr().accept(this);
            if (x.getPartition() != null) {
                this.print(" ");
                x.getPartition().accept(this);
            }
        }
        if (x.getHints().size() > 0) {
            this.printHints(x.getHints());
        }
        if (x.getSampleClause() != null) {
            this.print(" ");
            x.getSampleClause().accept(this);
        }
        if (x.getPivot() != null) {
            this.println();
            x.getPivot().accept(this);
        }
        if (x.getFlashback() != null) {
            this.println();
            x.getFlashback().accept(this);
        }
        this.printAlias(x.getAlias());
        return false;
    }

    @Override
    public boolean visit(OracleSelectUnPivot x) {
        this.print("UNPIVOT");
        if (x.getNullsIncludeType() != null) {
            this.print(" ");
            this.print(OracleSelectUnPivot.NullsIncludeType.toString(x.getNullsIncludeType()));
        }
        this.print(" (");
        if (x.getItems().size() == 1) {
            x.getItems().get(0).accept(this);
        } else {
            this.print(" (");
            this.printAndAccept(x.getItems(), ", ");
            this.print(")");
        }
        if (x.getPivotFor().size() > 0) {
            this.print(" FOR ");
            if (x.getPivotFor().size() == 1) {
                x.getPivotFor().get(0).accept(this);
            } else {
                this.print("(");
                this.printAndAccept(x.getPivotFor(), ", ");
                this.print(")");
            }
        }
        if (x.getPivotIn().size() > 0) {
            this.print(" IN (");
            this.printAndAccept(x.getPivotIn(), ", ");
            this.print(")");
        }
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(OracleTableExpr x) {
        x.getTable().accept(this);
        if (x.getPartition() != null) {
            this.print(" PARTITION (");
            x.getPartition().accept(this);
            this.print(")");
        } else if (x.getPartitionFor().size() > 0) {
            this.print(" PARTITION FOR (");
            int size = x.getPartitionFor().size();
            for (int i = 0; i < size; ++i) {
                x.getPartitionFor().get(i).accept(this);
            }
            this.print(")");
        } else if (x.getSubPartition() != null) {
            this.print(" SUBPARTITION (");
            x.getSubPartition().accept(this);
            this.print(")");
        } else if (x.getSubPartitionFor().size() > 0) {
            this.print(" SUBPARTITION FOR (");
            int size = x.getSubPartitionFor().size();
            for (int i = 0; i < size; ++i) {
                x.getSubPartitionFor().get(i).accept(this);
            }
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(OracleTimestampExpr x) {
        this.print("TIMESTAMP '");
        this.print(x.getLiteral());
        this.print('\'');
        if (x.getTimeZone() != null) {
            this.print(" AT TIME ZONE '");
            this.print(x.getTimeZone());
            this.print('\'');
        }
        return false;
    }

    @Override
    public boolean visit(OracleUpdateSetListClause x) {
        this.print("SET ");
        this.printAndAccept(x.getItems(), ", ");
        return false;
    }

    @Override
    public boolean visit(OracleUpdateSetListMultiColumnItem x) {
        this.print("(");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(") = (");
        x.getSubQuery().accept(this);
        this.print(")");
        return false;
    }

    @Override
    public boolean visit(OracleUpdateSetListSingleColumnItem x) {
        x.getColumn().accept(this);
        this.print(" = ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public boolean visit(OracleUpdateSetValueClause x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean visit(OracleUpdateStatement x) {
        this.print("UPDATE ");
        this.printHints(x.getHints());
        if (x.isOnly()) {
            this.print("ONLY (");
            x.getTableSource().accept(this);
            this.print(")");
        } else {
            x.getTableSource().accept(this);
        }
        this.printAlias(x.getAlias());
        this.println();
        this.print("SET ");
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            x.getItems().get(i).accept(this);
        }
        if (x.getWhere() != null) {
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
        }
        if (x.getReturning().size() > 0) {
            this.println();
            this.print("RETURNING ");
            this.printAndAccept(x.getReturning(), ", ");
            this.print(" INTO ");
            this.printAndAccept(x.getReturningInto(), ", ");
        }
        return false;
    }

    @Override
    public void endVisit(OracleAggregateExpr astNode) {
    }

    @Override
    public void endVisit(OracleConstraintState astNode) {
    }

    @Override
    public void endVisit(OraclePLSQLCommitStatement astNode) {
    }

    @Override
    public void endVisit(OracleAnalytic x) {
    }

    @Override
    public void endVisit(OracleAnalyticWindowing x) {
    }

    @Override
    public void endVisit(OracleDateExpr x) {
    }

    @Override
    public void endVisit(OracleDbLinkExpr x) {
    }

    @Override
    public void endVisit(OracleDeleteStatement x) {
    }

    @Override
    public void endVisit(OracleExtractExpr x) {
    }

    @Override
    public void endVisit(OracleIntervalExpr x) {
    }

    @Override
    public void endVisit(SQLMethodInvokeExpr x) {
    }

    @Override
    public void endVisit(SQLObjectCreateExpr x) {
    }

    @Override
    public void endVisit(OracleOrderBy x) {
    }

    @Override
    public void endVisit(OracleOuterExpr x) {
    }

    @Override
    public void endVisit(OracleSelectForUpdate x) {
    }

    @Override
    public void endVisit(OracleSelectHierachicalQueryClause x) {
    }

    @Override
    public void endVisit(OracleSelectJoin x) {
    }

    @Override
    public void endVisit(OracleOrderByItem x) {
    }

    @Override
    public void endVisit(OracleSelectPivot x) {
    }

    @Override
    public void endVisit(OracleSelectPivot.Item x) {
    }

    @Override
    public void endVisit(OracleSelectRestriction.CheckOption x) {
    }

    @Override
    public void endVisit(OracleSelectRestriction.ReadOnly x) {
    }

    @Override
    public void endVisit(OracleSelectSubqueryTableSource x) {
    }

    @Override
    public void endVisit(OracleSelectUnPivot x) {
    }

    @Override
    public void endVisit(OracleTableExpr x) {
    }

    @Override
    public void endVisit(OracleTimestampExpr x) {
    }

    @Override
    public void endVisit(OracleUpdateSetListClause x) {
    }

    @Override
    public void endVisit(OracleUpdateSetListMultiColumnItem x) {
    }

    @Override
    public void endVisit(OracleUpdateSetListSingleColumnItem x) {
    }

    @Override
    public void endVisit(OracleUpdateSetValueClause x) {
    }

    @Override
    public void endVisit(OracleUpdateStatement x) {
    }

    @Override
    public boolean visit(SampleClause x) {
        this.print("SAMPLE ");
        if (x.isBlock()) {
            this.print("BLOCK ");
        }
        this.print("(");
        this.printAndAccept(x.getPercent(), ", ");
        this.print(")");
        if (x.getSeedValue() != null) {
            this.print(" SEED (");
            x.getSeedValue().accept(this);
            this.print(")");
        }
        return false;
    }

    @Override
    public void endVisit(SampleClause x) {
    }

    @Override
    public void endVisit(OracleSelectTableReference x) {
    }

    @Override
    public boolean visit(PartitionExtensionClause x) {
        if (x.isSubPartition()) {
            this.print("SUBPARTITION ");
        } else {
            this.print("PARTITION ");
        }
        if (x.getPartition() != null) {
            this.print("(");
            x.getPartition().accept(this);
            this.print(")");
        } else {
            this.print("FOR (");
            this.printAndAccept(x.getFor(), ",");
            this.print(")");
        }
        return false;
    }

    @Override
    public void endVisit(PartitionExtensionClause x) {
    }

    @Override
    public boolean visit(FlashbackQueryClause.VersionsFlashbackQueryClause x) {
        this.print("VERSIONS BETWEEN ");
        this.print(x.getType().name());
        this.print(" ");
        x.getBegin().accept(this);
        this.print(" AND ");
        x.getEnd().accept(this);
        return false;
    }

    @Override
    public void endVisit(FlashbackQueryClause.VersionsFlashbackQueryClause x) {
    }

    @Override
    public boolean visit(FlashbackQueryClause.AsOfFlashbackQueryClause x) {
        this.print("AS OF ");
        this.print(x.getType().name());
        this.print(" (");
        x.getExpr().accept(this);
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(FlashbackQueryClause.AsOfFlashbackQueryClause x) {
    }

    @Override
    public boolean visit(GroupingSetExpr x) {
        this.print("GROUPING SETS");
        this.print(" (");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(GroupingSetExpr x) {
    }

    @Override
    public boolean visit(OracleWithSubqueryEntry x) {
        x.getName().accept(this);
        if (x.getColumns().size() > 0) {
            this.print(" (");
            this.printAndAccept(x.getColumns(), ", ");
            this.print(")");
        }
        this.println();
        this.print("AS");
        this.println();
        this.print("(");
        this.incrementIndent();
        this.println();
        x.getSubQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(")");
        if (x.getSearchClause() != null) {
            this.println();
            x.getSearchClause().accept(this);
        }
        if (x.getCycleClause() != null) {
            this.println();
            x.getCycleClause().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleWithSubqueryEntry x) {
    }

    @Override
    public boolean visit(SearchClause x) {
        this.print("SEARCH ");
        this.print(x.getType().name());
        this.print(" FIRST BY ");
        this.printAndAccept(x.getItems(), ", ");
        this.print(" SET ");
        x.getOrderingColumn().accept(this);
        return false;
    }

    @Override
    public void endVisit(SearchClause x) {
    }

    @Override
    public boolean visit(CycleClause x) {
        this.print("CYCLE ");
        this.printAndAccept(x.getAliases(), ", ");
        this.print(" SET ");
        x.getMark().accept(this);
        this.print(" TO ");
        x.getValue().accept(this);
        this.print(" DEFAULT ");
        x.getDefaultValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(CycleClause x) {
    }

    @Override
    public boolean visit(OracleBinaryFloatExpr x) {
        this.print(x.getValue().toString());
        this.print('F');
        return false;
    }

    @Override
    public void endVisit(OracleBinaryFloatExpr x) {
    }

    @Override
    public boolean visit(OracleBinaryDoubleExpr x) {
        this.print(x.getValue().toString());
        this.print('D');
        return false;
    }

    @Override
    public void endVisit(OracleBinaryDoubleExpr x) {
    }

    @Override
    public void endVisit(OracleSelect x) {
    }

    @Override
    public boolean visit(OracleConstraintState x) {
        this.printlnAndAccept(x.getStates(), " ");
        return false;
    }

    @Override
    public boolean visit(OracleCursorExpr x) {
        this.print("CURSOR(");
        this.incrementIndent();
        this.println();
        x.getQuery().accept(this);
        this.decrementIndent();
        this.println();
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(OracleCursorExpr x) {
    }

    @Override
    public boolean visit(OracleIsSetExpr x) {
        x.getNestedTable().accept(this);
        this.print(" IS A SET");
        return false;
    }

    @Override
    public void endVisit(OracleIsSetExpr x) {
    }

    @Override
    public boolean visit(ModelClause.ReturnRowsClause x) {
        if (x.isAll()) {
            this.print("RETURN ALL ROWS");
        } else {
            this.print("RETURN UPDATED ROWS");
        }
        return false;
    }

    @Override
    public void endVisit(ModelClause.ReturnRowsClause x) {
    }

    @Override
    public boolean visit(ModelClause x) {
        this.print("MODEL");
        this.incrementIndent();
        for (ModelClause.CellReferenceOption opt : x.getCellReferenceOptions()) {
            this.print(' ');
            this.print(opt.name);
        }
        if (x.getReturnRowsClause() != null) {
            this.print(' ');
            x.getReturnRowsClause().accept(this);
        }
        for (ModelClause.ReferenceModelClause item : x.getReferenceModelClauses()) {
            this.print(' ');
            item.accept(this);
        }
        x.getMainModel().accept(this);
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(ModelClause x) {
    }

    @Override
    public boolean visit(ModelClause.MainModelClause x) {
        if (x.getMainModelName() != null) {
            this.print(" MAIN ");
            x.getMainModelName().accept(this);
        }
        this.println();
        x.getModelColumnClause().accept(this);
        for (ModelClause.CellReferenceOption opt : x.getCellReferenceOptions()) {
            this.println();
            this.print(opt.name);
        }
        this.println();
        x.getModelRulesClause().accept(this);
        return false;
    }

    @Override
    public void endVisit(ModelClause.MainModelClause x) {
    }

    @Override
    public boolean visit(ModelClause.ModelColumnClause x) {
        if (x.getQueryPartitionClause() != null) {
            x.getQueryPartitionClause().accept(this);
            this.println();
        }
        this.print("DIMENSION BY (");
        this.printAndAccept(x.getDimensionByColumns(), ", ");
        this.print(")");
        this.println();
        this.print("MEASURES (");
        this.printAndAccept(x.getMeasuresColumns(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(ModelClause.ModelColumnClause x) {
    }

    @Override
    public boolean visit(ModelClause.QueryPartitionClause x) {
        this.print("PARTITION BY (");
        this.printAndAccept(x.getExprList(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(ModelClause.QueryPartitionClause x) {
    }

    @Override
    public boolean visit(ModelClause.ModelColumn x) {
        x.getExpr().accept(this);
        if (x.getAlias() != null) {
            this.print(" ");
            this.print(x.getAlias());
        }
        return false;
    }

    @Override
    public void endVisit(ModelClause.ModelColumn x) {
    }

    @Override
    public boolean visit(ModelClause.ModelRulesClause x) {
        if (x.getOptions().size() > 0) {
            this.print("RULES");
            for (ModelClause.ModelRuleOption opt : x.getOptions()) {
                this.print(" ");
                this.print(opt.name);
            }
        }
        if (x.getIterate() != null) {
            this.print(" ITERATE (");
            x.getIterate().accept(this);
            this.print(")");
            if (x.getUntil() != null) {
                this.print(" UNTIL (");
                x.getUntil().accept(this);
                this.print(")");
            }
        }
        this.print(" (");
        this.printAndAccept(x.getCellAssignmentItems(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(ModelClause.ModelRulesClause x) {
    }

    @Override
    public boolean visit(ModelClause.CellAssignmentItem x) {
        if (x.getOption() != null) {
            this.print(x.getOption().name);
            this.print(" ");
        }
        x.getCellAssignment().accept(this);
        if (x.getOrderBy() != null) {
            this.print(" ");
            x.getOrderBy().accept(this);
        }
        this.print(" = ");
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(ModelClause.CellAssignmentItem x) {
    }

    @Override
    public boolean visit(ModelClause.CellAssignment x) {
        x.getMeasureColumn().accept(this);
        this.print("[");
        this.printAndAccept(x.getConditions(), ", ");
        this.print("]");
        return false;
    }

    @Override
    public void endVisit(ModelClause.CellAssignment x) {
    }

    @Override
    public boolean visit(OracleMergeStatement x) {
        this.print("MERGE ");
        if (x.getHints().size() > 0) {
            this.printAndAccept(x.getHints(), ", ");
            this.print(" ");
        }
        this.print("INTO ");
        x.getInto().accept(this);
        if (x.getAlias() != null) {
            this.print(" ");
            this.print(x.getAlias());
        }
        this.println();
        this.print("USING ");
        x.getUsing().accept(this);
        this.print(" ON ");
        x.getOn().accept(this);
        if (x.getUpdateClause() != null) {
            this.println();
            x.getUpdateClause().accept(this);
        }
        if (x.getInsertClause() != null) {
            this.println();
            x.getInsertClause().accept(this);
        }
        if (x.getErrorLoggingClause() != null) {
            this.println();
            x.getErrorLoggingClause().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleMergeStatement x) {
    }

    @Override
    public boolean visit(OracleMergeStatement.MergeUpdateClause x) {
        this.print("WHEN MATCHED THEN UPDATE SET ");
        this.printAndAccept(x.getItems(), ", ");
        if (x.getWhere() != null) {
            this.incrementIndent();
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        if (x.getDeleteWhere() != null) {
            this.incrementIndent();
            this.println();
            this.print("DELETE WHERE ");
            x.getDeleteWhere().setParent(x);
            x.getDeleteWhere().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public void endVisit(OracleMergeStatement.MergeUpdateClause x) {
    }

    @Override
    public boolean visit(OracleMergeStatement.MergeInsertClause x) {
        this.print("WHEN NOT MATCHED THEN INSERT");
        if (x.getColumns().size() > 0) {
            this.print(" ");
            this.printAndAccept(x.getColumns(), ", ");
        }
        this.print(" VALUES (");
        this.printAndAccept(x.getValues(), ", ");
        this.print(")");
        if (x.getWhere() != null) {
            this.incrementIndent();
            this.println();
            this.print("WHERE ");
            x.getWhere().setParent(x);
            x.getWhere().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public void endVisit(OracleMergeStatement.MergeInsertClause x) {
    }

    @Override
    public boolean visit(OracleErrorLoggingClause x) {
        this.print("LOG ERRORS ");
        if (x.getInto() != null) {
            this.print("INTO ");
            x.getInto().accept(this);
            this.print(" ");
        }
        if (x.getSimpleExpression() != null) {
            this.print("(");
            x.getSimpleExpression().accept(this);
            this.print(")");
        }
        if (x.getLimit() != null) {
            this.print(" REJECT LIMIT ");
            x.getLimit().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleErrorLoggingClause x) {
    }

    @Override
    public boolean visit(OracleReturningClause x) {
        this.print("RETURNING ");
        this.printAndAccept(x.getItems(), ", ");
        this.print(" INTO ");
        this.printAndAccept(x.getValues(), ", ");
        return false;
    }

    @Override
    public void endVisit(OracleReturningClause x) {
    }

    @Override
    public boolean visit(OracleInsertStatement x) {
        this.visit((SQLInsertStatement)x);
        if (x.getReturning() != null) {
            this.println();
            x.getReturning().accept(this);
        }
        if (x.getErrorLogging() != null) {
            this.println();
            x.getErrorLogging().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleInsertStatement x) {
        this.endVisit((SQLInsertStatement)x);
    }

    @Override
    public boolean visit(OracleMultiInsertStatement.InsertIntoClause x) {
        this.print("INTO ");
        x.getTableName().accept(this);
        if (x.getColumns().size() > 0) {
            this.incrementIndent();
            this.println();
            this.print("(");
            int size = x.getColumns().size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    if (i % 5 == 0) {
                        this.println();
                    }
                    this.print(", ");
                }
                x.getColumns().get(i).accept(this);
            }
            this.print(")");
            this.decrementIndent();
        }
        if (x.getValues() != null) {
            this.println();
            this.print("VALUES ");
            x.getValues().accept(this);
        } else if (x.getQuery() != null) {
            this.println();
            x.getQuery().setParent(x);
            x.getQuery().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleMultiInsertStatement.InsertIntoClause x) {
    }

    @Override
    public boolean visit(OracleMultiInsertStatement x) {
        this.print("INSERT ");
        if (x.getHints().size() > 0) {
            this.printHints(x.getHints());
        }
        if (x.getOption() != null) {
            this.print(x.getOption().name());
            this.print(" ");
        }
        int size = x.getEntries().size();
        for (int i = 0; i < size; ++i) {
            this.incrementIndent();
            this.println();
            x.getEntries().get(i).accept(this);
            this.decrementIndent();
        }
        this.println();
        x.getSubQuery().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleMultiInsertStatement x) {
    }

    @Override
    public boolean visit(OracleMultiInsertStatement.ConditionalInsertClause x) {
        int size = x.getItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            OracleMultiInsertStatement.ConditionalInsertClauseItem item = x.getItems().get(i);
            item.accept(this);
        }
        if (x.getElseItem() != null) {
            this.println();
            this.print("ELSE");
            this.incrementIndent();
            this.println();
            x.getElseItem().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public void endVisit(OracleMultiInsertStatement.ConditionalInsertClause x) {
    }

    @Override
    public boolean visit(OracleMultiInsertStatement.ConditionalInsertClauseItem x) {
        this.print("WHEN ");
        x.getWhen().accept(this);
        this.print(" THEN");
        this.incrementIndent();
        this.println();
        x.getThen().accept(this);
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(OracleMultiInsertStatement.ConditionalInsertClauseItem x) {
    }

    @Override
    public void endVisit(OracleSelectQueryBlock x) {
    }

    @Override
    public boolean visit(OracleBlockStatement x) {
        int i;
        int size;
        if (x.getParameters().size() != 0) {
            this.print("DECLARE");
            this.incrementIndent();
            this.println();
            size = x.getParameters().size();
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    this.println();
                }
                OracleParameter param = x.getParameters().get(i);
                param.accept(this);
                this.print(";");
            }
            this.decrementIndent();
            this.println();
        }
        this.print("BEGIN");
        this.incrementIndent();
        this.println();
        size = x.getStatementList().size();
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement stmt = x.getStatementList().get(i);
            stmt.setParent(x);
            stmt.accept(this);
        }
        this.decrementIndent();
        this.println();
        this.print("END");
        return false;
    }

    @Override
    public void endVisit(OracleBlockStatement x) {
    }

    @Override
    public boolean visit(OracleLockTableStatement x) {
        this.print("LOCK TABLE ");
        x.getTable().accept(this);
        this.print(" IN ");
        this.print(x.getLockMode().name());
        this.print(" MODE ");
        if (x.isNoWait()) {
            this.print("NOWAIT");
        } else if (x.getWait() != null) {
            this.print("WAIT ");
            x.getWait().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleLockTableStatement x) {
    }

    @Override
    public boolean visit(OracleAlterSessionStatement x) {
        this.print("ALTER SESSION SET ");
        this.printAndAccept(x.getItems(), ", ");
        return false;
    }

    @Override
    public void endVisit(OracleAlterSessionStatement x) {
    }

    @Override
    public boolean visit(OracleExprStatement x) {
        x.getExpr().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleExprStatement x) {
    }

    @Override
    public boolean visit(OracleDatetimeExpr x) {
        x.getExpr().accept(this);
        SQLExpr timeZone = x.getTimeZone();
        if (timeZone instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)timeZone).getName().equalsIgnoreCase("LOCAL")) {
            this.print(" AT LOCAL");
            return false;
        }
        this.print(" AT TIME ZONE ");
        timeZone.accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleDatetimeExpr x) {
    }

    @Override
    public boolean visit(OracleSysdateExpr x) {
        this.print("SYSDATE");
        if (x.getOption() != null) {
            this.print("@");
            this.print(x.getOption());
        }
        return false;
    }

    @Override
    public void endVisit(OracleSysdateExpr x) {
    }

    @Override
    public void endVisit(OracleExceptionStatement.Item x) {
    }

    @Override
    public boolean visit(OracleExceptionStatement.Item x) {
        this.print("WHEN ");
        x.getWhen().accept(this);
        this.incrementIndent();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            this.println();
            SQLStatement stmt = x.getStatements().get(i);
            stmt.setParent(x);
            stmt.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(OracleExceptionStatement x) {
        this.print("EXCEPTION");
        this.incrementIndent();
        for (OracleExceptionStatement.Item item : x.getItems()) {
            this.println();
            item.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(OracleExceptionStatement x) {
    }

    @Override
    public boolean visit(OracleArgumentExpr x) {
        this.print(x.getArgumentName());
        this.print(" => ");
        x.getValue().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleArgumentExpr x) {
    }

    @Override
    public boolean visit(OracleSetTransactionStatement x) {
        if (x.isReadOnly()) {
            this.print("SET TRANSACTION READ ONLY NAME ");
        } else {
            this.print("SET TRANSACTION NAME ");
        }
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleSetTransactionStatement x) {
    }

    @Override
    public boolean visit(OracleGrantStatement x) {
        this.print("GRANT ");
        int size = x.getPrivileges().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.print(x.getPrivileges().get(i));
        }
        if (x.getOn() != null) {
            this.print(" ON ");
            x.getOn().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleGrantStatement x) {
    }

    @Override
    public boolean visit(OracleExplainStatement x) {
        this.print("EXPLAIN PLAN");
        this.incrementIndent();
        this.println();
        if (x.getStatementId() != null) {
            this.print("SET STATEMENT_ID = ");
            x.getStatementId().accept(this);
            this.println();
        }
        if (x.getInto() != null) {
            this.print("INTO ");
            x.getInto().accept(this);
            this.println();
        }
        this.print("FRO");
        this.println();
        x.getForStatement().accept(this);
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(OracleExplainStatement x) {
    }

    @Override
    public boolean visit(OracleAlterProcedureStatement x) {
        this.print("ALTER PROCEDURE ");
        x.getName().accept(this);
        if (x.isCompile()) {
            this.print(" COMPILE");
        }
        if (x.isReuseSettings()) {
            this.print(" REUSE SETTINGS");
        }
        return false;
    }

    @Override
    public void endVisit(OracleAlterProcedureStatement x) {
    }

    @Override
    public boolean visit(OracleAlterTableDropPartition x) {
        this.print("DROP PARTITION ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleAlterTableDropPartition x) {
    }

    @Override
    public boolean visit(OracleAlterTableStatement x) {
        this.print("ALTER TABLE ");
        x.getName().accept(this);
        this.incrementIndent();
        for (SQLAlterTableItem item : x.getItems()) {
            this.println();
            item.accept(this);
        }
        if (x.isUpdateGlobalIndexes()) {
            this.println();
            this.print("UPDATE GLOABL INDEXES");
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(OracleAlterTableStatement x) {
    }

    @Override
    public boolean visit(OracleAlterTableTruncatePartition x) {
        this.print("TRUNCATE PARTITION ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleAlterTableTruncatePartition x) {
    }

    @Override
    public boolean visit(OracleAlterTableSplitPartition.TableSpaceItem x) {
        this.print("TABLESPACE ");
        x.getTablespace().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleAlterTableSplitPartition.TableSpaceItem x) {
    }

    @Override
    public boolean visit(OracleAlterTableSplitPartition.UpdateIndexesClause x) {
        this.print("UPDATE INDEXES");
        if (x.getItems().size() > 0) {
            this.print("(");
            this.printAndAccept(x.getItems(), ", ");
            this.print(")");
        }
        return false;
    }

    @Override
    public void endVisit(OracleAlterTableSplitPartition.UpdateIndexesClause x) {
    }

    @Override
    public boolean visit(OracleAlterTableSplitPartition x) {
        this.print("SPLIT PARTITION ");
        x.getName().accept(this);
        if (x.getAt().size() > 0) {
            this.incrementIndent();
            this.println();
            this.print("AT (");
            this.printAndAccept(x.getAt(), ", ");
            this.print(")");
            this.decrementIndent();
        }
        if (x.getInto().size() > 0) {
            this.println();
            this.incrementIndent();
            this.print("INTO (");
            this.printAndAccept(x.getInto(), ", ");
            this.print(")");
            this.decrementIndent();
        }
        if (x.getUpdateIndexes() != null) {
            this.println();
            this.incrementIndent();
            x.getUpdateIndexes().accept(this);
            this.decrementIndent();
        }
        return false;
    }

    @Override
    public void endVisit(OracleAlterTableSplitPartition x) {
    }

    @Override
    public boolean visit(OracleAlterTableSplitPartition.NestedTablePartitionSpec x) {
        this.print("PARTITION ");
        x.getPartition().accept(this);
        for (SQLObject item : x.getSegmentAttributeItems()) {
            this.print(" ");
            item.accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleAlterTableSplitPartition.NestedTablePartitionSpec x) {
    }

    @Override
    public boolean visit(OracleAlterTableModify x) {
        this.print("MODIFY (");
        this.incrementIndent();
        int size = x.getColumns().size();
        for (int i = 0; i < size; ++i) {
            this.println();
            SQLColumnDefinition column = x.getColumns().get(i);
            column.accept(this);
            if (i == size - 1) continue;
            this.print(", ");
        }
        this.decrementIndent();
        this.println();
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(OracleAlterTableModify x) {
    }

    @Override
    public boolean visit(OracleCreateIndexStatement x) {
        this.print("CREATE ");
        if (x.getType() != null) {
            this.print(x.getType());
            this.print(" ");
        }
        this.print("INDEX ");
        x.getName().accept(this);
        this.print(" ON ");
        x.getTable().accept(this);
        this.print("(");
        this.printAndAccept(x.getItems(), ", ");
        this.print(")");
        if (x.isIndexOnlyTopLevel()) {
            this.print(" INDEX ONLY TOPLEVEL");
        }
        if (x.getTablespace() != null) {
            this.print(" TABLESPACE ");
            x.getTablespace().accept(this);
        }
        if (x.isOnline()) {
            this.print(" ONLINE");
        }
        if (x.isNoParallel()) {
            this.print(" NOPARALLEL");
        } else if (x.getParallel() != null) {
            this.print(" PARALLEL ");
            x.getParallel().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleCreateIndexStatement x) {
    }

    @Override
    public boolean visit(OracleAlterIndexStatement x) {
        this.print("ALTER INDEX ");
        x.getName().accept(this);
        if (x.getRenameTo() != null) {
            this.print(" RENAME TO ");
            x.getRenameTo().accept(this);
        }
        if (x.getMonitoringUsage() != null) {
            this.print(" MONITORING USAGE");
        }
        if (x.getRebuild() != null) {
            this.print(" ");
            x.getRebuild().accept(this);
        }
        if (x.getParallel() != null) {
            this.print(" PARALLEL");
            x.getParallel().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleAlterIndexStatement x) {
    }

    @Override
    public boolean visit(OracleAlterIndexStatement.Rebuild x) {
        this.print("REBUILD");
        if (x.getOption() != null) {
            this.print(" ");
            x.getOption().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleAlterIndexStatement.Rebuild x) {
    }

    @Override
    public boolean visit(OracleForStatement x) {
        this.print("FOR ");
        x.getIndex().accept(this);
        this.print(" IN ");
        x.getRange().accept(this);
        this.println();
        this.print("LOOP");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.decrementIndent();
        this.println();
        this.print("END LOOP");
        return false;
    }

    @Override
    public void endVisit(OracleForStatement x) {
    }

    @Override
    public boolean visit(OracleIfStatement.Else x) {
        this.print("ELSE");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public boolean visit(OracleIfStatement.ElseIf x) {
        this.print("ELSE IF ");
        x.getCondition().accept(this);
        this.print(" THEN");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.println();
            }
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(OracleIfStatement.ElseIf x) {
    }

    @Override
    public void endVisit(OracleIfStatement.Else x) {
    }

    @Override
    public boolean visit(OracleIfStatement x) {
        this.print("IF ");
        x.getCondition().accept(this);
        this.print(" THEN");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.decrementIndent();
        for (OracleIfStatement.ElseIf elseIf : x.getElseIfList()) {
            this.println();
            elseIf.accept(this);
        }
        if (x.getElseItem() != null) {
            this.println();
            x.getElseItem().accept(this);
        }
        this.println();
        this.print("END IF");
        return false;
    }

    @Override
    public void endVisit(OracleIfStatement x) {
    }

    @Override
    public boolean visit(OracleRangeExpr x) {
        x.getLowBound().accept(this);
        this.print("..");
        x.getUpBound().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleRangeExpr x) {
    }

    @Override
    protected void visitColumnDefault(SQLColumnDefinition x) {
        if (x.getParent() instanceof OracleBlockStatement) {
            this.print(" := ");
        } else {
            this.print(" DEFAULT ");
        }
        x.getDefaultExpr().accept(this);
    }

    @Override
    public boolean visit(OracleAlterTableAddConstaint x) {
        this.print("ADD ");
        x.getConstraint().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleAlterTableAddConstaint x) {
    }

    @Override
    public boolean visit(OraclePrimaryKey x) {
        if (x.getName() != null) {
            this.print("CONSTRAINT ");
            x.getName().accept(this);
            this.print(" ");
        }
        this.print("PRIMARY KEY (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(")");
        if (x.getUsingIndex() != null) {
            this.print(" USING INDEX ");
            x.getUsingIndex().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OraclePrimaryKey x) {
    }

    @Override
    public boolean visit(OracleCreateTableStatement x) {
        this.visit((SQLCreateTableStatement)x);
        this.incrementIndent();
        if (x.isOrganizationIndex()) {
            this.print(" ORGANIZATION INDEX");
        }
        if (x.getTablespace() != null) {
            this.print(" TABLESPACE ");
            x.getTablespace().accept(this);
        }
        if (x.isInMemoryMetadata()) {
            this.print(" IN_MEMORY_METADATA");
        }
        if (x.isCursorSpecificSegment()) {
            this.print(" CURSOR_SPECIFIC_SEGMENT");
        }
        if (x.getParallel() == Boolean.TRUE) {
            this.print(" PARALLEL");
        } else if (x.getParallel() == Boolean.FALSE) {
            this.print(" NOPARALLEL");
        }
        if (x.getCache() == Boolean.TRUE) {
            this.print(" CACHE");
        } else if (x.getCache() == Boolean.FALSE) {
            this.print(" NOCACHE");
        }
        if (x.getCompress() == Boolean.TRUE) {
            this.print(" COMPRESS");
        } else if (x.getCompress() == Boolean.FALSE) {
            this.print(" NOCOMPRESS");
        }
        if (x.getLogging() == Boolean.TRUE) {
            this.print(" LOGGING");
        } else if (x.getLogging() == Boolean.FALSE) {
            this.print(" NOLOGGING");
        }
        if (x.getStorage() != null) {
            this.print(" ");
            x.getStorage().accept(this);
        }
        if (x.isOnCommit()) {
            this.print(" ON COMMIT");
        }
        if (x.isPreserveRows()) {
            this.print(" PRESERVE ROWS");
        }
        if (x.getPartitioning() != null) {
            this.println();
            x.getPartitioning().accept(this);
        }
        if (x.getSelect() != null) {
            this.println();
            this.print("AS");
            this.println();
            x.getSelect().accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(OracleCreateTableStatement x) {
    }

    @Override
    public boolean visit(OracleAlterTableRenameTo x) {
        this.print("RENAME TO ");
        x.getTo().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleAlterTableRenameTo x) {
    }

    @Override
    public boolean visit(OracleStorageClause x) {
        this.print("STORAGE (");
        if (x.getInitial() != null) {
            this.print(" INITIAL ");
            x.getInitial().accept(this);
        }
        if (x.getFreeLists() != null) {
            this.print(" FREELISTS ");
            x.getFreeLists().accept(this);
        }
        if (x.getFreeListGroups() != null) {
            this.print(" FREELIST GROUPS ");
            x.getFreeListGroups().accept(this);
        }
        if (x.getBufferPool() != null) {
            this.print(" BUFFER_POOL ");
            x.getBufferPool().accept(this);
        }
        if (x.getObjno() != null) {
            this.print(" OBJNO ");
            x.getObjno().accept(this);
        }
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(OracleStorageClause x) {
    }

    @Override
    public boolean visit(OracleGotoStatement x) {
        this.print("GOTO ");
        x.getLabel().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleGotoStatement x) {
    }

    @Override
    public boolean visit(OracleLabelStatement x) {
        this.print("<<");
        x.getLabel().accept(this);
        this.print(">>");
        return false;
    }

    @Override
    public void endVisit(OracleLabelStatement x) {
    }

    @Override
    public boolean visit(OracleParameter x) {
        if (x.getDataType().getName().equalsIgnoreCase("CURSOR")) {
            this.print("CURSOR ");
            x.getName().accept(this);
            this.print(" IS");
            this.incrementIndent();
            this.println();
            SQLSelect select = ((SQLQueryExpr)x.getDefaultValue()).getSubQuery();
            select.accept(this);
            this.decrementIndent();
        } else {
            x.getName().accept(this);
            this.print(" ");
            x.getDataType().accept(this);
            if (x.getDefaultValue() != null) {
                this.print(" := ");
                x.getDefaultValue().accept(this);
            }
        }
        return false;
    }

    @Override
    public void endVisit(OracleParameter x) {
    }

    @Override
    public boolean visit(OracleCommitStatement x) {
        this.print("COMMIT");
        if (x.isWrite()) {
            this.print(" WRITE");
            if (x.getWait() != null) {
                if (x.getWait().booleanValue()) {
                    this.print(" WAIT");
                } else {
                    this.print(" NOWAIT");
                }
            }
            if (x.getImmediate() != null) {
                if (x.getImmediate().booleanValue()) {
                    this.print(" IMMEDIATE");
                } else {
                    this.print(" BATCH");
                }
            }
        }
        return false;
    }

    @Override
    public void endVisit(OracleCommitStatement x) {
    }

    @Override
    public boolean visit(OracleAlterTriggerStatement x) {
        this.print("ALTER TRIGGER ");
        x.getName().accept(this);
        if (x.isCompile()) {
            this.print(" COMPILE");
        }
        if (x.getEnable() != null) {
            if (x.getEnable().booleanValue()) {
                this.print("ENABLE");
            } else {
                this.print("DISABLE");
            }
        }
        return false;
    }

    @Override
    public void endVisit(OracleAlterTriggerStatement x) {
    }

    @Override
    public boolean visit(OracleAlterSynonymStatement x) {
        this.print("ALTER SYNONYM ");
        x.getName().accept(this);
        if (x.isCompile()) {
            this.print(" COMPILE");
        }
        if (x.getEnable() != null) {
            if (x.getEnable().booleanValue()) {
                this.print("ENABLE");
            } else {
                this.print("DISABLE");
            }
        }
        return false;
    }

    @Override
    public void endVisit(OracleAlterSynonymStatement x) {
    }

    @Override
    public boolean visit(FlashbackQueryClause.AsOfSnapshotClause x) {
        this.print("AS OF SNAPSHOT(");
        x.getExpr().accept(this);
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(FlashbackQueryClause.AsOfSnapshotClause x) {
    }

    @Override
    public boolean visit(OracleAlterViewStatement x) {
        this.print("ALTER VIEW ");
        x.getName().accept(this);
        if (x.isCompile()) {
            this.print(" COMPILE");
        }
        if (x.getEnable() != null) {
            if (x.getEnable().booleanValue()) {
                this.print("ENABLE");
            } else {
                this.print("DISABLE");
            }
        }
        return false;
    }

    @Override
    public void endVisit(OracleAlterViewStatement x) {
    }

    @Override
    public boolean visit(OracleAlterTableMoveTablespace x) {
        this.print(" MOVE TABLESPACE ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleAlterTableMoveTablespace x) {
    }

    @Override
    public boolean visit(OracleSizeExpr x) {
        x.getValue().accept(this);
        this.print(x.getUnit().name());
        return false;
    }

    @Override
    public void endVisit(OracleSizeExpr x) {
    }

    @Override
    public boolean visit(OracleFileSpecification x) {
        this.printAndAccept(x.getFileNames(), ", ");
        if (x.getSize() != null) {
            this.print(" SIZE ");
            x.getSize().accept(this);
        }
        if (x.isAutoExtendOff()) {
            this.print(" AUTOEXTEND OFF");
        } else if (x.getAutoExtendOn() != null) {
            this.print(" AUTOEXTEND ON ");
            x.getAutoExtendOn().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleFileSpecification x) {
    }

    @Override
    public boolean visit(OracleAlterTablespaceAddDataFile x) {
        this.print("ADD DATAFILE");
        this.incrementIndent();
        for (OracleFileSpecification file : x.getFiles()) {
            this.println();
            file.accept(this);
        }
        this.decrementIndent();
        return false;
    }

    @Override
    public void endVisit(OracleAlterTablespaceAddDataFile x) {
    }

    @Override
    public boolean visit(OracleAlterTablespaceStatement x) {
        this.print("ALTER TABLESPACE ");
        x.getName().accept(this);
        this.println();
        x.getItem().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleAlterTablespaceStatement x) {
    }

    @Override
    public boolean visit(OracleTruncateStatement x) {
        this.print("TRUNCATE TABLE ");
        this.printAndAccept(x.getTableSources(), ", ");
        if (x.isPurgeSnapshotLog()) {
            this.print(" PURGE SNAPSHOT LOG");
        }
        return false;
    }

    @Override
    public void endVisit(OracleTruncateStatement x) {
    }

    @Override
    public boolean visit(OracleCreateSequenceStatement x) {
        this.print("CREATE SEQUENCE ");
        x.getName().accept(this);
        if (x.getStartWith() != null) {
            this.print(" START WITH ");
            x.getStartWith().accept(this);
        }
        if (x.getIncrementBy() != null) {
            this.print(" INCREMENT BY ");
            x.getIncrementBy().accept(this);
        }
        if (x.getMaxValue() != null) {
            this.print(" MAXVALUE ");
            x.getMaxValue().accept(this);
        }
        if (x.getCycle() != null) {
            if (x.getCycle().booleanValue()) {
                this.print(" CYCLE");
            } else {
                this.print(" NOCYCLE");
            }
        }
        if (x.getCache() != null) {
            if (x.getCache().booleanValue()) {
                this.print(" CACHE");
            } else {
                this.print(" NOCACHE");
            }
        }
        return false;
    }

    @Override
    public void endVisit(OracleCreateSequenceStatement x) {
    }

    @Override
    public boolean visit(OracleRangeValuesClause x) {
        this.print("PARTITION ");
        x.getName().accept(this);
        this.print(" VALUES LESS THAN (");
        this.printAndAccept(x.getValues(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(OracleRangeValuesClause x) {
    }

    @Override
    public boolean visit(OraclePartitionByRangeClause x) {
        this.print("PARTITION BY RANGE (");
        this.printAndAccept(x.getColumns(), ", ");
        this.print(")");
        if (x.getInterval() != null) {
            this.print(" INTERVAL ");
            x.getInterval().accept(this);
        }
        if (x.getStoreIn().size() > 0) {
            this.print(" STORE IN (");
            this.printAndAccept(x.getStoreIn(), ", ");
            this.print(")");
        }
        this.println();
        this.print("(");
        this.incrementIndent();
        int size = x.getRanges().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(",");
            }
            this.println();
            x.getRanges().get(i).accept(this);
        }
        this.decrementIndent();
        this.println();
        this.print(")");
        return false;
    }

    @Override
    public void endVisit(OraclePartitionByRangeClause x) {
    }

    @Override
    public boolean visit(OracleLoopStatement x) {
        this.print("LOOP");
        this.incrementIndent();
        this.println();
        int size = x.getStatements().size();
        for (int i = 0; i < size; ++i) {
            SQLStatement item = x.getStatements().get(i);
            item.setParent(x);
            item.accept(this);
            if (i == size - 1) continue;
            this.println();
        }
        this.decrementIndent();
        this.println();
        this.print("END LOOP");
        return false;
    }

    @Override
    public void endVisit(OracleLoopStatement x) {
    }

    @Override
    public boolean visit(OracleExitStatement x) {
        this.print("EXIT");
        if (x.getWhen() != null) {
            this.print(" WHEN ");
            x.getWhen().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleExitStatement x) {
    }

    @Override
    public boolean visit(OracleFetchStatement x) {
        this.print("FETCH ");
        x.getCursorName().accept(this);
        this.print(" INTO ");
        this.printAndAccept(x.getInto(), ", ");
        return false;
    }

    @Override
    public void endVisit(OracleFetchStatement x) {
    }

    @Override
    public void endVisit(SQLRollbackStatement x) {
    }

    @Override
    public boolean visit(OracleSavePointStatement x) {
        this.print("ROLLBACK");
        if (x.getTo() != null) {
            this.print(" TO ");
            x.getTo().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleSavePointStatement x) {
    }

    @Override
    public boolean visit(OracleCreateProcedureStatement x) {
        if (x.isOrReplace()) {
            this.print("CREATE OR REPLACE PROCEDURE ");
        } else {
            this.print("CREATE PROCEDURE ");
        }
        x.getName().accept(this);
        int paramSize = x.getParameters().size();
        if (paramSize > 0) {
            this.print(" (");
            this.incrementIndent();
            this.println();
            for (int i = 0; i < paramSize; ++i) {
                if (i != 0) {
                    this.print(", ");
                    this.println();
                }
                OracleParameter param = x.getParameters().get(i);
                param.accept(this);
            }
            this.decrementIndent();
            this.println();
            this.print(")");
        }
        this.println();
        x.getBlock().setParent(x);
        x.getBlock().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleCreateProcedureStatement x) {
    }

    @Override
    public boolean visit(OracleCreateDatabaseDbLinkStatement x) {
        this.print("CREATE ");
        if (x.isShared()) {
            this.print("SHARE ");
        }
        if (x.isPublic()) {
            this.print("PUBLIC ");
        }
        this.print("DATABASE LINK ");
        x.getName().accept(this);
        if (x.getUser() != null) {
            this.print(" CONNECT TO ");
            x.getUser().accept(this);
            if (x.getPassword() != null) {
                this.print(" IDENTIFIED BY ");
                this.print(x.getPassword());
            }
        }
        if (x.getAuthenticatedUser() != null) {
            this.print(" AUTHENTICATED BY ");
            x.getAuthenticatedUser().accept(this);
            if (x.getAuthenticatedPassword() != null) {
                this.print(" IDENTIFIED BY ");
                this.print(x.getAuthenticatedPassword());
            }
        }
        if (x.getUsing() != null) {
            this.print(" USING ");
            x.getUsing().accept(this);
        }
        return false;
    }

    @Override
    public void endVisit(OracleCreateDatabaseDbLinkStatement x) {
    }

    @Override
    public boolean visit(OracleDropDatabaseLinkStatement x) {
        this.print("DROP ");
        if (x.isPublic()) {
            this.print("PUBLIC ");
        }
        this.print("DATABASE LINK ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleDropDatabaseLinkStatement x) {
    }

    @Override
    public boolean visit(SQLCharactorDataType x) {
        this.print(x.getName());
        if (x.getArguments().size() > 0) {
            this.print("(");
            x.getArguments().get(0).accept(this);
            if (x.getCharType() != null) {
                this.print(' ');
                this.print(x.getCharType());
            }
            this.print(")");
        }
        return false;
    }

    @Override
    public boolean visit(OracleDataTypeTimestamp x) {
        this.print(x.getName());
        if (x.getArguments().size() > 0) {
            this.print("(");
            x.getArguments().get(0).accept(this);
            this.print(")");
        }
        if (x.isWithTimeZone()) {
            this.print(" WITH TIME ZONE");
        } else if (x.isWithLocalTimeZone()) {
            this.print(" WITH LOCAL TIME ZONE");
        }
        return false;
    }

    @Override
    public void endVisit(OracleDataTypeTimestamp x) {
    }

    @Override
    public boolean visit(OracleDataTypeIntervalYear x) {
        this.print(x.getName());
        if (x.getArguments().size() > 0) {
            this.print("(");
            x.getArguments().get(0).accept(this);
            this.print(")");
        }
        this.print(" TO MONTH");
        return false;
    }

    @Override
    public void endVisit(OracleDataTypeIntervalYear x) {
    }

    @Override
    public boolean visit(OracleDataTypeIntervalDay x) {
        this.print(x.getName());
        if (x.getArguments().size() > 0) {
            this.print("(");
            x.getArguments().get(0).accept(this);
            this.print(")");
        }
        this.print(" TO SECOND");
        if (x.getFractionalSeconds().size() > 0) {
            this.print("(");
            x.getFractionalSeconds().get(0).accept(this);
            this.print(")");
        }
        return false;
    }

    @Override
    public void endVisit(OracleDataTypeIntervalDay x) {
    }

    @Override
    public boolean visit(OracleDropSequenceStatement x) {
        this.print("DROP SEQUENCE ");
        x.getName().accept(this);
        return false;
    }

    @Override
    public void endVisit(OracleDropSequenceStatement x) {
    }
}

