/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.mock;

import com.alibaba.druid.mock.MockBlob;
import com.alibaba.druid.mock.MockCallableStatement;
import com.alibaba.druid.mock.MockClob;
import com.alibaba.druid.mock.MockConnection;
import com.alibaba.druid.mock.MockDriverMBean;
import com.alibaba.druid.mock.MockNClob;
import com.alibaba.druid.mock.MockPreparedStatement;
import com.alibaba.druid.mock.MockResultSet;
import com.alibaba.druid.mock.MockSQLXML;
import com.alibaba.druid.mock.MockStatement;
import com.alibaba.druid.mock.MockStatementBase;
import com.alibaba.druid.mock.handler.MockExecuteHandler;
import com.alibaba.druid.mock.handler.MySqlMockExecuteHandlerImpl;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.lang.management.ManagementFactory;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class MockDriver
implements Driver,
MockDriverMBean {
    private static final Log LOG = LogFactory.getLog(MockDriver.class);
    public static final MockExecuteHandler DEFAULT_HANDLER = new MySqlMockExecuteHandlerImpl();
    private String prefix = "jdbc:fake:";
    private String mockPrefix = "jdbc:mock:";
    private MockExecuteHandler executeHandler = DEFAULT_HANDLER;
    public static final MockDriver instance = new MockDriver();
    private final AtomicLong connectCount = new AtomicLong();
    private final AtomicLong connectionCloseCount = new AtomicLong();
    private final AtomicLong connectionIdSeed = new AtomicLong(1000L);
    private final List<MockConnection> connections = new CopyOnWriteArrayList<MockConnection>();
    private long idleTimeCount = 180000L;
    private boolean logExecuteQueryEnable = true;
    private static final String MBEAN_NAME = "com.alibaba.druid:type=MockDriver";

    @Override
    public boolean isLogExecuteQueryEnable() {
        return this.logExecuteQueryEnable;
    }

    @Override
    public void setLogExecuteQueryEnable(boolean logExecuteQueryEnable) {
        this.logExecuteQueryEnable = logExecuteQueryEnable;
    }

    @Override
    public long getIdleTimeCount() {
        return this.idleTimeCount;
    }

    @Override
    public void setIdleTimeCount(long idleTimeCount) {
        this.idleTimeCount = idleTimeCount;
    }

    public long generateConnectionId() {
        return this.connectionIdSeed.incrementAndGet();
    }

    @Override
    public void closeAllConnections() throws SQLException {
        int size = this.connections.size();
        for (int i = 0; i < size; ++i) {
            Connection conn = this.connections.get(size - i - 1);
            conn.close();
        }
    }

    @Override
    public int getConnectionsSize() {
        return this.connections.size();
    }

    public List<MockConnection> getConnections() {
        return this.connections;
    }

    protected void incrementConnectionCloseCount() {
        this.connectionCloseCount.incrementAndGet();
    }

    @Override
    public long getConnectionCloseCount() {
        return this.connectionCloseCount.get();
    }

    protected void afterConnectionClose(MockConnection conn) {
        this.connectionCloseCount.incrementAndGet();
        this.connections.remove(conn);
        if (LOG.isDebugEnabled()) {
            LOG.debug("conn-" + conn.getId() + " close");
        }
    }

    public static boolean registerDriver(Driver driver) {
        try {
            DriverManager.registerDriver(driver);
            try {
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName objectName = new ObjectName(MBEAN_NAME);
                if (!mbeanServer.isRegistered(objectName)) {
                    mbeanServer.registerMBean(instance, objectName);
                }
            }
            catch (Exception ex) {
                LOG.error("register druid-driver mbean error", ex);
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("registerDriver error", e);
            return false;
        }
    }

    public MockExecuteHandler getExecuteHandler() {
        return this.executeHandler;
    }

    public void setExecuteHandler(MockExecuteHandler executeHandler) {
        this.executeHandler = executeHandler;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Object val;
        if (!this.acceptsURL(url)) {
            return null;
        }
        if (info != null && (val = info.get("connectSleep")) != null) {
            long millis = Long.parseLong(val.toString());
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        MockConnection conn = this.createMockConnection(this, url, info);
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect, url " + url + ", id " + conn.getId());
        }
        if (url == null) {
            this.connectCount.incrementAndGet();
            this.connections.add(conn);
            return conn;
        }
        if (url.startsWith(this.prefix)) {
            String catalog = url.substring(this.prefix.length());
            conn.setCatalog(catalog);
            this.connectCount.incrementAndGet();
            this.connections.add(conn);
            return conn;
        }
        if (url.startsWith(this.mockPrefix)) {
            String catalog = url.substring(this.mockPrefix.length());
            conn.setCatalog(catalog);
            this.connectCount.incrementAndGet();
            this.connections.add(conn);
            return conn;
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.startsWith(this.prefix) || url.startsWith(this.mockPrefix);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    public MockResultSet createMockResultSet(MockStatementBase stmt) {
        return new MockResultSet(stmt);
    }

    public ResultSet executeQuery(MockStatementBase stmt, String sql) throws SQLException {
        if (this.logExecuteQueryEnable && LOG.isDebugEnabled()) {
            LOG.debug("executeQuery " + sql);
        }
        MockConnection conn = stmt.getConnection();
        long idleTimeMillis = System.currentTimeMillis() - conn.getLastActiveTimeMillis();
        if (idleTimeMillis >= this.idleTimeCount) {
            throw new SQLException("connection is idle time count");
        }
        conn.setLastActiveTimeMillis(System.currentTimeMillis());
        this.handleSleep(conn);
        if ("SELECT value FROM _int_1000_".equalsIgnoreCase(sql)) {
            MockResultSet rs = this.createMockResultSet(stmt);
            for (int i = 0; i < 1000; ++i) {
                rs.getRows().add(new Object[]{i});
            }
            return rs;
        }
        return this.executeHandler.executeQuery(stmt, sql);
    }

    public void handleSleep(MockConnection conn) {
        if (conn != null) {
            conn.handleSleep();
        }
    }

    public ResultSet createResultSet(MockPreparedStatement stmt) {
        MockResultSet rs = new MockResultSet(stmt);
        String sql = stmt.getSql();
        if ("SELECT 1".equalsIgnoreCase(sql)) {
            rs.getRows().add(new Object[]{1});
        } else if ("SELECT NOW()".equalsIgnoreCase(sql)) {
            rs.getRows().add(new Object[]{new Timestamp(System.currentTimeMillis())});
        } else if ("SELECT ?".equalsIgnoreCase(sql)) {
            rs.getRows().add(new Object[]{stmt.getParameters().get(0)});
        }
        return rs;
    }

    protected Clob createClob(MockConnection conn) throws SQLException {
        return new MockClob();
    }

    protected Blob createBlob(MockConnection conn) throws SQLException {
        return new MockBlob();
    }

    protected NClob createNClob(MockConnection conn) throws SQLException {
        return new MockNClob();
    }

    protected SQLXML createSQLXML(MockConnection conn) throws SQLException {
        return new MockSQLXML();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public MockConnection createMockConnection(MockDriver driver, String url, Properties connectProperties) {
        return new MockConnection(this, url, connectProperties);
    }

    public MockPreparedStatement createMockPreparedStatement(MockConnection conn, String sql) {
        return new MockPreparedStatement(conn, sql);
    }

    public MockStatement createMockStatement(MockConnection conn) {
        return new MockStatement(conn);
    }

    public MockCallableStatement createMockCallableStatement(MockConnection conn, String sql) {
        return new MockCallableStatement(conn, sql);
    }

    static {
        MockDriver.registerDriver(instance);
    }
}

