/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.util;

import com.xunlei.channel.util.Md5Encrypt;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SignUtil {
    private static final Log log = LogFactory.getLog(SignUtil.class);

    public static boolean checkSign(Map param, String privateKey) {
        if (SignUtil.isEmpty(privateKey) || param == null) {
            return false;
        }
        String signMsg = (String)param.get("signMsg");
        if (SignUtil.isEmpty(signMsg)) {
            return false;
        }
        String signed = SignUtil.sign(param, privateKey);
        return signMsg.equals(signed);
    }

    public static String sign(Map param, String privateKey) {
        String content = SignUtil.getSignatureContent(param);
        log.info((Object)("\u9700\u8981\u7b7e\u540d\u5904\u7406\u7684URL\uff1a" + content));
        return SignUtil.sign(content, privateKey);
    }

    public static String sign(String content, String privateKey) {
        if (content == null) {
            return null;
        }
        return Md5Encrypt.md5((String)(content + privateKey));
    }

    public static String getSignatureContent(Map param) {
        return SignUtil.getSignatureContent(param, null);
    }

    public static String getSignatureContent(Map param, String encodeCharset) {
        Properties prop = new Properties();
        for (String key : param.keySet()) {
            String value;
            if (key.equals("signMsg") || SignUtil.isEmpty(value = (String)param.get(key))) continue;
            prop.setProperty(key, value);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> keys = new ArrayList<Object>(prop.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = prop.getProperty(key);
            if (!SignUtil.isEmpty(encodeCharset)) {
                try {
                    value = URLEncoder.encode(prop.getProperty(key), encodeCharset);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            sb.append(i != 0 ? "&" : "");
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static String sign(Map<String, String> param, String privateKey, String encodeCharset) {
        return SignUtil.sign(SignUtil.getSignatureContent(param, encodeCharset), privateKey);
    }

    public static String urlEncode(String value, String charset) {
        try {
            return URLEncoder.encode(value, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

