/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.util;

import com.xunlei.common.util.StringTools;
import com.xunlei.netty.httpserver.component.XLHttpRequest;

public class IpUtil {
    public static String getIp(XLHttpRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteHost();
        }
        if (!StringTools.isEmpty((String)ip) && ip.length() > 15) {
            ip = request.getRemoteIP();
        }
        return ip;
    }

    public static boolean isWhiteIp(String whiteIp, String ip) {
        String[] ips;
        if (StringTools.isEmpty((String)whiteIp)) {
            return true;
        }
        if (whiteIp.indexOf(",") == -1) {
            return ip.trim().equals(whiteIp.trim());
        }
        for (String myip : ips = whiteIp.split(",")) {
            if (!myip.trim().equals(ip.trim())) continue;
            return true;
        }
        return false;
    }
}

