/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.thread;

import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.BoxPayOrder;
import com.xunlei.niux.pay.util.HttpClientUtil;
import com.xunlei.niux.pay.util.RBundleUtil;
import com.xunlei.util.Log;
import com.xunlei.util.StringTools;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class BoxTask
implements Runnable {
    private static Logger logger = Log.getLogger(BoxTask.class);
    private static final String BOX_CALL_BACK_URL = RBundleUtil.getString("pay", "boxCallBackUrl");
    private BoxPayOrder order;

    public BoxTask(BoxPayOrder order) {
        this.order = order;
    }

    @Override
    public void run() {
        try {
            String finishTime = DateUtil.getNowTime();
            this.order.setFinishTime(finishTime);
            this.order.setOrderStatus(Integer.valueOf(2));
            boolean isSuccess = this.noticeBox();
            if (isSuccess) {
                this.order.setNoticeBox(Boolean.valueOf(true));
            }
            FacadeFactory.INSTANCE.getBaseSo().updateObjectById((Object)this.order);
            logger.info("noticeBox success orderid:" + this.order.getOrderId());
        }
        catch (Exception e) {
            logger.error("thread:" + Thread.currentThread() + ",orderid:" + this.order.getOrderId(), (Throwable)e);
        }
    }

    private boolean noticeBox() {
        StringBuffer sb = new StringBuffer(BOX_CALL_BACK_URL);
        sb.append("porderid=").append(this.order.getPorderId()).append("&rorderid=").append(this.order.getOrderId());
        logger.info("orderid:" + this.order.getOrderId() + ",url:" + sb);
        String responseText = HttpClientUtil.getInfoForHttpGetMothed(sb.toString());
        if (StringTools.isEmpty((CharSequence)responseText)) {
            return false;
        }
        try {
            JSONObject data = new JSONObject(responseText);
            int rtn = data.getInt("rtn");
            logger.info("orderid:" + this.order.getOrderId() + ",rtn:" + rtn);
            if (rtn == 0) {
                return true;
            }
        }
        catch (JSONException e) {
            logger.error("boxtask error orderid:" + this.order.getOrderId(), (Throwable)e);
            return false;
        }
        return false;
    }
}

