/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.task;

import com.xunlei.util.Log;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class GamePayExecutor {
    private static final Logger logger = Log.getLogger(GamePayExecutor.class);
    private static final GamePayExecutor instance = new GamePayExecutor();
    private ExecutorService executor = new ThreadPoolExecutor(5, 10, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10000), new ThreadPoolExecutor.DiscardOldestPolicy());

    public static GamePayExecutor getInstance() {
        return instance;
    }

    private GamePayExecutor() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.info("GamePayExecutor().destroy()");
                GamePayExecutor.getInstance().destroy();
                logger.info("GamePayExecutor.getInstance().destroy()");
            }
        });
    }

    public void execute(Runnable task) {
        try {
            this.executor.submit(task);
        }
        catch (Exception e) {
            logger.info("Executor \u6dfb\u52a0\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public void destroy() {
        this.executor.shutdown();
    }
}

