/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.proxy;

import com.ferret.common.dao.vo.Page;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.util.DateUtil;
import com.xunlei.niux.data.jinzuan.vo.OrderStatus;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import com.xunlei.niux.pay.proxy.ActProxy;
import com.xunlei.niux.pay.util.HttpUtil;
import com.xunlei.util.Log;
import java.text.ParseException;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class JiFenShopProxy {
    private static Logger logger = Log.getLogger(JiFenShopProxy.class);
    private static final String BIZTYPE = "niux";
    private static final String ACTNO = "jifen";
    private static final JiFenShopProxy instance = new JiFenShopProxy();
    private String callback = ActProxy.getInstance().getCallBackUrl("jifen");

    private JiFenShopProxy() {
    }

    public static JiFenShopProxy getInstance() {
        return instance;
    }

    private boolean isFirstPay(long userid) {
        PayOrder query = new PayOrder();
        query.setUserId(Long.valueOf(userid));
        query.setActNo(ACTNO);
        query.setOrderStatus(Integer.valueOf(3));
        Page page = new Page();
        page.setPageNo(1);
        page.setPageSize(3);
        List polist = FacadeFactory.INSTANCE.getBaseSo().findObjects((Object)query, page);
        return polist == null || polist.size() <= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jiFen(PayOrder payOrder) {
        System.out.println("jiFen  .............");
        long userid = payOrder.getUserId();
        String orderid = payOrder.getOrderId();
        long num = payOrder.getPayMoney() == null ? 0L : payOrder.getPayMoney().longValue();
        System.out.println("jiFen  start  uid=" + userid);
        boolean firstFlag = this.isFirstPay(userid);
        String url = this.getUrl(userid, orderid, num, firstFlag);
        logger.info("JiFenShopProxy userid:" + userid + ",orderid:" + orderid + ",url:" + url);
        OrderStatus query = new OrderStatus();
        query.setUserId(Long.valueOf(userid));
        query.setOrderId(orderid);
        OrderStatus status = (OrderStatus)FacadeFactory.INSTANCE.getBaseSo().findObject((Object)query);
        if (status != null && status.getNoticeJinFenShop().booleanValue()) {
            return true;
        }
        OrderStatus orderstatus = new OrderStatus();
        orderstatus.setUserId(Long.valueOf(userid));
        orderstatus.setOrderId(orderid);
        orderstatus.setNoticeJinFenShop(Boolean.valueOf(false));
        int code = -1;
        try {
            String responseText = HttpUtil.execute(url);
            JSONObject jsonObject = new JSONObject(responseText);
            code = jsonObject.getInt("result");
            if (code == 1) {
                logger.info("JiFenShopProxy success userid:" + userid + ",orderid:" + orderid + ",responseText:" + responseText);
                orderstatus.setNoticeJinFenShop(Boolean.valueOf(true));
                orderstatus.setJinFenShopTime(DateUtil.getNowDay());
                boolean bl = true;
                return bl;
            }
            logger.info("JiFenShopProxy failure userid:" + userid + ",orderid:" + orderid + ",responseText:" + responseText);
            orderstatus.setReason("code:" + code);
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            logger.error("JiFenShopProxy failure userid:" + userid + ",orderid:" + orderid + ",reason:" + e.getMessage());
            orderstatus.setReason(e.getMessage());
        }
        finally {
            if (status != null) {
                if (!status.getNoticeJinFenShop().booleanValue() && code == 1) {
                    status.setNoticeJinFenShop(Boolean.valueOf(true));
                    try {
                        status.setJinFenShopTime(DateUtil.getNowDay());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    FacadeFactory.INSTANCE.getBaseSo().updateObjectById((Object)status);
                }
            } else {
                FacadeFactory.INSTANCE.getBaseSo().addObject((Object)orderstatus);
            }
        }
        return false;
    }

    public boolean addJiFen(PayOrder payOrder) {
        if (!payOrder.getActNo().equals(ACTNO)) {
            return false;
        }
        return this.jiFen(payOrder);
    }

    private String getUrl(long userid, String orderid, long num, boolean firstFlag) {
        System.out.println("jifen callback:" + this.callback);
        StringBuffer sb = new StringBuffer(this.callback);
        sb.append("&userid=").append(userid).append("&orderid=").append(orderid).append("&num=").append(num).append("&onenum=").append(firstFlag ? 2L * num : 0L).append("&biztype=").append(BIZTYPE);
        return sb.toString();
    }
}

