/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.cmd;

import com.ferret.common.dao.enums.OrderType;
import com.ferret.common.dao.vo.Page;
import com.xunlei.common.util.StringTools;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.CodeCode;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import com.xunlei.niux.data.jinzuan.vo.PrivateKey;
import com.xunlei.niux.pay.DefaultCmd;
import com.xunlei.niux.pay.cmd.PayCmd;
import com.xunlei.niux.pay.proxy.ValidIPProxy;
import com.xunlei.niux.pay.util.CodeUtil;
import com.xunlei.niux.pay.util.DateUtil;
import com.xunlei.niux.pay.util.IpUtil;
import com.xunlei.niux.pay.util.RBundleUtil;
import com.xunlei.niux.pay.util.StringUtils;
import com.xunlei.niux.pay.vo.OrderData;
import com.xunlei.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PayQueryCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PayCmd.class);
    private static final String presentKeyIp = RBundleUtil.getString("pay", "presentKeyIp");

    public Object getPresentKey(XLHttpRequest request, XLHttpResponse response) {
        String ip = request.getRemoteIP();
        try {
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            String ptype = request.getParameter("type");
            String account = request.getParameter("account");
            if (StringTools.isEmpty((String)ptype) || StringTools.isEmpty((String)account)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u53c2\u6570\u4e3a\u7a7a");
            }
            logger.info("getpresentkey.do ip=" + ip + ",type=" + ptype + ",account=" + account);
            if (!StringTools.isEmpty((String)presentKeyIp)) {
                if (presentKeyIp.indexOf(",") == -1) {
                    if (!presentKeyIp.trim().equals(ip)) {
                        return JsonObjectUtil.getRtnAndDataJsonObject((int)2, (Object)"\u65e0\u6548ip");
                    }
                } else {
                    String[] keyips = presentKeyIp.split(",");
                    boolean flag = false;
                    for (String keyip : keyips) {
                        if (StringTools.isEmpty((String)keyip) || !keyip.trim().equals(ip)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        return JsonObjectUtil.getRtnAndDataJsonObject((int)2, (Object)"\u65e0\u6548ip");
                    }
                }
            }
            PrivateKey query = new PrivateKey();
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(1);
            page.addOrder("seqId", OrderType.DESC);
            List pklist = FacadeFactory.INSTANCE.getBaseSo().findObjects((Object)query, page);
            PrivateKey mykey = new PrivateKey();
            String nowTime = DateUtil.getNowTime();
            if (pklist == null || pklist.size() == 0) {
                mykey.setBizNo("100001");
                mykey.setKeyType(Integer.valueOf(Integer.parseInt(ptype)));
                mykey.setPrivateKey(UUID.randomUUID().toString());
                mykey.setInputTime(nowTime);
                mykey.setInputBy(account);
            } else {
                PrivateKey pkey = (PrivateKey)pklist.get(0);
                mykey.setBizNo(Long.parseLong(pkey.getBizNo()) + 1L + "");
                mykey.setKeyType(Integer.valueOf(Integer.parseInt(ptype)));
                mykey.setPrivateKey(UUID.randomUUID().toString());
                mykey.setInputTime(nowTime);
                mykey.setInputBy(account);
            }
            FacadeFactory.INSTANCE.getBaseSo().addObject((Object)mykey);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("bizno", mykey.getBizNo());
            result.put("privatekey", mykey.getPrivateKey());
            logger.info("getpresentkey.do success ip=" + ip + ",type=" + ptype + ",account=" + account + ",bizno=" + mykey.getBizNo() + ",privatekey=" + mykey.getPrivateKey());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)0, result);
        }
        catch (Exception e) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)3, (Object)"\u672a\u77e5\u9519\u8bef");
        }
    }

    @CmdMapper(value={"/jinzuan/queryFirstPay.do"})
    public Object queryFirstPay(XLHttpRequest request, XLHttpResponse response) {
        try {
            String actNo;
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            String userid = request.getParameter("userid");
            if (StringTools.isEmpty((String)userid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u53c2\u6570\u4e3a\u7a7a");
            }
            String ip = request.getRemoteIP();
            if (!ValidIPProxy.getInstance().isValidIp(ip, 1)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)2, (Object)"\u65e0\u6548ip");
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            PayOrder query = new PayOrder();
            query.setOrderStatus(Integer.valueOf(3));
            query.setUserId(Long.valueOf(Long.parseLong(userid)));
            String orderType = request.getParameter("orderType");
            if (!StringTools.isEmpty((String)orderType)) {
                int type = Integer.parseInt(orderType);
                query.setOrderType(Integer.valueOf(type));
            }
            if (!StringTools.isEmpty((String)(actNo = request.getParameter("actNo")))) {
                query.setActNo(actNo);
            }
            String orderId = request.getParameter("orderId");
            Page page = new Page();
            page.setPageNo(1);
            page.setPageSize(5);
            List polist = FacadeFactory.INSTANCE.getBaseSo().findObjects((Object)query, page);
            if (CollectionUtils.isEmpty((Collection)polist)) {
                result.put("flag", 0);
            } else if (polist.size() == 1) {
                if (!StringTools.isEmpty((String)orderId)) {
                    PayOrder porder = (PayOrder)polist.get(0);
                    if (porder.getOrderId().equals(orderId)) {
                        result.put("flag", 1);
                    }
                } else {
                    result.put("flag", 1);
                }
            } else {
                result.put("flag", 0);
            }
            return JsonObjectUtil.getRtnAndDataJsonObject((int)0, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject((int)3, (Object)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @CmdMapper(value={"/jinzuan/queryOrder.do"})
    public Object queryOrder(XLHttpRequest request, XLHttpResponse response) {
        MainParam mainParam = null;
        long uid = 0L;
        try {
            mainParam = this.getMainParam(request, response, true);
            uid = mainParam.getUserid();
            String pagesize = request.getParameter("pagesize");
            String pageno = request.getParameter("pageno");
            String actNo = request.getParameter("actNo");
            int pageSize = 20;
            int pageNo = 1;
            if (!StringTools.isEmpty((String)pagesize)) {
                pageSize = Integer.parseInt(pagesize);
            }
            if (!StringTools.isEmpty((String)pageno)) {
                pageNo = Integer.parseInt(pageno);
            }
            ArrayList<String> params = new ArrayList<String>();
            if (StringTools.isEmpty((String)actNo)) {
                params.add("1");
                params.add("1");
            } else {
                params.add(actNo);
                params.add(actNo);
            }
            StringBuffer sql = new StringBuffer("SELECT s1.finishTime,s1.timeType,s1.numValue,s1.orderType,s1.payMoney,s2.orderEndDate ,s2.dayNum payDays,s1.memberStatus memberStatus  FROM (select * from jinzuan_payorder where userid='" + uid + "') s1 INNER JOIN (select * from jinzuan_memberdetail where userid='" + uid + "') s2");
            sql.append(" ON s1.orderid = s2.orderid  ").append(" where  s1.orderStatus=3   and ( 1=? or s1.actNo=? )");
            sql.append(" ORDER BY s1.finishTime DESC ").append(" limit ").append((pageNo - 1) * pageSize).append(",").append(pageSize);
            List list = FacadeFactory.INSTANCE.getBaseSo().executeQuery(OrderData.class, sql.toString(), params);
            logger.info("orderquerysql:" + sql);
            StringBuffer countsql = new StringBuffer("SELECT count(*) FROM (select * from jinzuan_payorder where userid='" + uid + "') s1 INNER JOIN (select * from jinzuan_memberdetail where userid='" + uid + "') s2");
            countsql.append(" ON s1.orderid = s2.orderid  ").append(" where  s1.orderStatus=3");
            logger.info("ordercountsql:" + countsql);
            int count = FacadeFactory.INSTANCE.getBaseSo().count(countsql.toString(), new Object[0]);
            HashMap<String, Object> result = new HashMap<String, Object>();
            System.out.println("count:" + count);
            result.put("totalCount", count);
            for (OrderData data : list) {
                String time = data.getFinishTime();
                if (StringTools.isNotEmpty((String)time) && time.length() > 19) {
                    time = time.substring(0, 19);
                }
                data.setFinishTime(time);
            }
            result.put("orderList", list);
            logger.info("jinzuan queryOrder.do  uid=" + uid + ",list=" + list);
            return JsonObjectUtil.getRtnAndDataJsonObject((int)0, result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @CmdMapper(value={"/jinzuan/queryOrderStatus.do"})
    public Object queryOrderStatus(XLHttpRequest request, XLHttpResponse response) {
        String orderid = StringUtils.filterInputWeak(request.getParameter("orderid"));
        try {
            if (StringTools.isEmpty((String)orderid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)2, (Object)"\u53c2\u6570\u975e\u6cd5");
            }
            PayOrder payOrderQuery = new PayOrder();
            payOrderQuery.setOrderId(orderid);
            PayOrder payOrder = (PayOrder)FacadeFactory.INSTANCE.getBaseSo().findObject((Object)payOrderQuery);
            if (payOrder == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)3, (Object)"\u652f\u4ed8\u6682\u672a\u6210\u529f,\u8bf7\u7a0d\u540e\u67e5\u8be2");
            }
            int orderStatus = payOrder.getOrderStatus();
            logger.info("queryOrderStatus.do orderid=" + orderid + ",orderStatus=" + orderStatus);
            switch (orderStatus) {
                case 1: {
                    return JsonObjectUtil.getRtnAndDataJsonObject((int)4, (Object)"\u8ba2\u5355\u5df2\u751f\u6210\u4f46\u672a\u652f\u4ed8");
                }
                case 2: {
                    return JsonObjectUtil.getRtnAndDataJsonObject((int)5, (Object)"\u8ba2\u5355\u652f\u4ed8\u6210\u529f\u4f46\u672a\u589e\u52a0\u4f1a\u5458\u65f6\u95f4");
                }
            }
            return JsonObjectUtil.getRtnAndDataJsonObject((int)0, (Object)"\u5145\u503c\u6210\u529f");
        }
        catch (Exception e) {
            logger.info("jinzuan/queryOrderStatus.do orderid=" + orderid + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)6, (Object)"\u672a\u77e5\u9519\u8bef");
        }
    }

    @CmdMapper(value={"/jinzuan/queryOrderDetail.do"})
    public Object queryOrderDetail(XLHttpRequest request, XLHttpResponse response) {
        String orderid = StringUtils.filterInputWeak(request.getParameter("orderid"));
        try {
            if (StringTools.isEmpty((String)orderid)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)2, (Object)"\u53c2\u6570\u975e\u6cd5");
            }
            PayOrder payOrderQuery = new PayOrder();
            payOrderQuery.setOrderId(orderid);
            PayOrder payOrder = (PayOrder)FacadeFactory.INSTANCE.getBaseSo().findObject((Object)payOrderQuery);
            if (payOrder == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)3, (Object)"\u652f\u4ed8\u6682\u672a\u6210\u529f,\u8bf7\u7a0d\u540e\u67e5\u8be2");
            }
            HashMap<String, Object> mapDate = new HashMap<String, Object>();
            mapDate.put("ddzt", payOrder.getOrderStatus());
            mapDate.put("userid", payOrder.getUserId());
            mapDate.put("username", payOrder.getUserName());
            mapDate.put("sjlx", payOrder.getTimeType());
            mapDate.put("jtsl", payOrder.getNumValue());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)0, mapDate);
        }
        catch (Exception e) {
            logger.info("jinzuan/queryOrderStatus.do orderid=" + orderid + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)6, (Object)"\u672a\u77e5\u9519\u8bef");
        }
    }

    @CmdMapper(value={"/jinzuan/codestatus.do"})
    public Object codeStatus(XLHttpRequest request, XLHttpResponse response) {
        long uid = 0L;
        String userAccount = null;
        MainParam mainParam = null;
        String ip = IpUtil.getIp(request);
        try {
            mainParam = this.getMainParam(request, response, true);
            uid = mainParam.getUserid();
            userAccount = mainParam.getUserAccount();
        }
        catch (Exception e) {
            logger.error("ip[" + ip + "]\u8bf7\u6c42/jinzuan/pay.do\u7684session\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        }
        if (mainParam == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)11, (Object)"session\u9a8c\u8bc1\u5931\u8d25");
        }
        if (uid == 0L || StringTools.isEmpty((String)userAccount)) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)11, (Object)"session\u9a8c\u8bc1\u5931\u8d25");
        }
        String userid = request.getCookieValue("userid");
        if (!userid.equals(uid + "")) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)12, (Object)"\u8d26\u53f7\u975e\u6cd5");
        }
        String acode = request.getParameter("acode");
        if (StringTools.isEmpty((String)acode)) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)3, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        }
        int len = (acode = acode.toUpperCase()).length();
        if (len < 16 || len > 20) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)6, (Object)"\u975e\u6cd5\u6fc0\u6d3b\u7801");
        }
        if (!CodeUtil.checkCode(acode)) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)6, (Object)"\u975e\u6cd5\u6fc0\u6d3b\u7801");
        }
        CodeCode query = new CodeCode();
        query.setAcode(acode);
        CodeCode code = (CodeCode)FacadeFactory.INSTANCE.getBaseSo().findObject((Object)query);
        if (code == null) {
            return JsonObjectUtil.getRtnAndDataJsonObject((int)4, (Object)"\u8be5\u6fc0\u6d3b\u7801\u4e0d\u5b58\u5728");
        }
        int type = code.getFlag();
        switch (type) {
            case 1: {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)0, (Object)"\u672a\u4f7f\u7528");
            }
            case 2: {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u5df2\u4f7f\u7528");
            }
            case 3: {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)2, (Object)"\u51bb\u7ed3");
            }
        }
        return JsonObjectUtil.getRtnAndDataJsonObject((int)5, (Object)"\u8be5\u6fc0\u6d3b\u7801\u72b6\u6001\u4e0d\u6b63\u786e");
    }
}

