/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.cmd;

import com.ferret.common.dao.vo.Page;
import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.login.MainParam;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.jinzuan.bo.BaseSo;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.MemberShip;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import com.xunlei.niux.data.jinzuan.vo.Price;
import com.xunlei.niux.data.jinzuan.vo.PrivateKey;
import com.xunlei.niux.pay.activity.ActivityFactory;
import com.xunlei.niux.pay.activity.ActivityProxy;
import com.xunlei.niux.pay.activity.IActivityBiz;
import com.xunlei.niux.pay.activity.Result;
import com.xunlei.niux.pay.client.UserClient;
import com.xunlei.niux.pay.cmd.BasePayCmd;
import com.xunlei.niux.pay.proxy.BuQiProxy;
import com.xunlei.niux.pay.proxy.ChargeTypeProxy;
import com.xunlei.niux.pay.proxy.JiFenShopProxy;
import com.xunlei.niux.pay.proxy.PresentProxy;
import com.xunlei.niux.pay.proxy.PriceProxy;
import com.xunlei.niux.pay.proxy.TestAccountProxy;
import com.xunlei.niux.pay.proxy.ValidIPProxy;
import com.xunlei.niux.pay.util.CookieUtil;
import com.xunlei.niux.pay.util.DateUtil;
import com.xunlei.niux.pay.util.IpUtil;
import com.xunlei.niux.pay.util.OrderIdUtil;
import com.xunlei.niux.pay.util.RBundleUtil;
import com.xunlei.niux.pay.util.SignUtil;
import com.xunlei.niux.pay.util.StringUtils;
import com.xunlei.niux.pay.util.UserUtil;
import com.xunlei.niux.pay.vo.ReturnData;
import com.xunlei.util.Log;
import java.net.URL;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PayCmd
extends BasePayCmd {
    private static Logger logger = Log.getLogger(PayCmd.class);
    private static final String noticeWeiXiUrl = RBundleUtil.getString("pay", "noticeWeiXiUrl");
    private static final String chargekey = RBundleUtil.getString("pay", "chargekey");
    private static final String APPID = RBundleUtil.getString("pay", "appId");
    private static final String cancelkey = RBundleUtil.getString("pay", "cancelkey");
    private static final String baiduActNo = RBundleUtil.getString("pay", "baiduActNo");

    public int getLeaveMonths(MemberShip ship) {
        String memberExpireDate = ship.getMemberExpireDate();
        return this.getMonths(memberExpireDate);
    }

    private int getMonths(String time) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date date1 = sdf.parse(sdf.format(new Date()));
            Date date2 = sdf.parse(time);
            long data = (date2.getTime() - date1.getTime()) / 86400000L;
            if (data % 31L == 0L) {
                return (int)(data / 31L);
            }
            return (int)(data / 31L + 1L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private Result checkPriceTime(String startTime, String endTime) throws Exception {
        String nowtime = DateUtil.getNowTime();
        if (!StringTools.isEmpty((String)startTime) && DateUtil.compareTime(startTime, nowtime)) {
            Result result = new Result();
            result.setCode(16);
            result.setMsg("\u8be5\u7c7b\u578b\u7684\u5355\u4ef7\u8fd8\u672a\u5f00\u653e\u4f7f\u7528");
            return result;
        }
        if (!StringTools.isEmpty((String)endTime) && DateUtil.compareTime(nowtime, endTime)) {
            Result result = new Result();
            result.setCode(17);
            result.setMsg("\u8be5\u7c7b\u578b\u7684\u5355\u4ef7\u5df2\u7ecf\u8fc7\u671f");
            return result;
        }
        return null;
    }

    private Result checkLimitAmount(PayOrder porder, Price price) {
        if (price.getAmountFlag().booleanValue()) {
            String amounts = price.getAmounts();
            if (amounts.indexOf(",") == -1) {
                long myamount = Long.parseLong(amounts.trim());
                if (porder.getNumValue() != myamount) {
                    Result result = new Result();
                    result.setCode(19);
                    result.setMsg("\u6570\u91cf\u4e0d\u5bf9");
                    return result;
                }
            } else {
                String[] myamounts = amounts.split(",");
                boolean limitFlag = true;
                for (String myamount : myamounts) {
                    if (StringTools.isEmpty((String)myamount) || porder.getNumValue() != Long.parseLong(myamount)) continue;
                    limitFlag = false;
                    break;
                }
                if (limitFlag) {
                    Result result = new Result();
                    result.setCode(19);
                    result.setMsg("\u6570\u91cf\u4e0d\u5bf9");
                    return result;
                }
            }
        }
        return null;
    }

    private Result checkBuQi(PayOrder porder, double payPrice) {
        if (BuQiProxy.getInstance().validBuQi(porder.getActNo())) {
            MemberShip query = new MemberShip();
            query.setUserId(porder.getUserId());
            MemberShip ship = (MemberShip)FacadeFactory.INSTANCE.getBaseSo().findObject((Object)query);
            if (ship == null) {
                Result result = new Result();
                result.setCode(2);
                result.setMsg("\u53c2\u6570\u9519\u8bef");
                return result;
            }
            int months = this.getLeaveMonths(ship);
            System.out.println("months:" + months + ",paymoney/payPrice:" + porder.getPayMoney() / payPrice);
            if (porder.getPayMoney() / payPrice != (double)(12 - months)) {
                Result result = new Result();
                result.setCode(12);
                result.setMsg("\u6708\u6570\u4e0d\u5bf9");
                return result;
            }
        }
        return null;
    }

    private Result checkExperienceMember(PayOrder porder, Price price) throws Exception {
        int checkMemberStatus = price.getCheckMemberStatus();
        if (checkMemberStatus == 2 && this.checkMemberStatus(porder.getUserId()) != 0) {
            Result result = new Result();
            result.setCode(2);
            result.setMsg("\u53c2\u6570\u9519\u8bef");
            return result;
        }
        return null;
    }

    public Result checkData(PayOrder porder, Price price, double payPrice) throws Exception {
        Result result = this.checkPriceTime(price.getStartTime(), price.getEndTime());
        if (result != null) {
            return result;
        }
        result = this.checkLimitAmount(porder, price);
        if (result != null) {
            return result;
        }
        result = this.checkBuQi(porder, payPrice);
        if (result != null) {
            return result;
        }
        result = this.checkExperienceMember(porder, price);
        return result;
    }

    @CmdMapper(value={"/jinzuan/pay.do"})
    public Object pay(XLHttpRequest request, XLHttpResponse response) {
        long uid = 0L;
        String userAccount = null;
        String ip = IpUtil.getIp(request);
        MainParam mainParam = null;
        String chargeType = StringUtils.filterInputWeak(request.getParameter("chargeType"));
        String cookieprefix = StringUtils.filterInputWeak(request.getParameter("cookieprefix"));
        try {
            mainParam = super.checkMainParam(request, response);
            uid = mainParam.getUserid();
            userAccount = mainParam.getUserAccount();
        }
        catch (Exception e) {
            logger.error("ip[" + ip + "]\u8bf7\u6c42/jinzuan/pay.do\u7684session\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
            return this.getReturn(cookieprefix, 11, "\u60a8\u7684\u767b\u5f55\u6001\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", chargeType, response);
        }
        if (uid == 0L || StringTools.isEmpty((String)userAccount)) {
            return this.getReturn(cookieprefix, 11, "\u60a8\u7684\u767b\u5f55\u6001\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55", chargeType, response);
        }
        String userid = request.getCookieValue("userid");
        if (!userid.equals(uid + "")) {
            return this.getReturn(cookieprefix, 15, "\u8d26\u53f7\u975e\u6cd5", chargeType, response);
        }
        try {
            String copartnerId = StringUtils.filterInputWeak(request.getParameter("copartnerId"));
            String bankNo = StringUtils.filterInputWeak(request.getParameter("bankNo"));
            String payBizNo = StringUtils.filterInputWeak(request.getParameter("payBizNo"));
            String timeType = StringUtils.filterInputWeak(request.getParameter("timeType"));
            String numValue = StringUtils.filterInputWeak(request.getParameter("numValue"));
            String money = StringUtils.filterInputWeak(request.getParameter("money"));
            String priceNo = StringUtils.filterInputWeak(request.getParameter("priceNo"));
            String advNo = StringUtils.filterInputWeak(request.getParameter("advNo"));
            if (StringTools.isEmpty((String)copartnerId)) {
                copartnerId = "0000";
            }
            String actNo = StringUtils.filterInputWeak(request.getParameter("actNo"));
            String ext1 = StringUtils.filterInputWeak(request.getParameter("ext1"));
            logger.info("jinzuan pay.do  uid=" + userid + "&userAccount=" + userAccount + "&copartnerId=" + copartnerId + "&bankNo=" + bankNo + "&payBizNo=" + payBizNo + "&timeType=" + timeType + "&numValue=" + numValue + "&money=" + money + "&priceNo=" + priceNo + "&cookieprefix=" + cookieprefix + "&actNo=" + actNo + "&ext1=" + ext1);
            if (StringTools.isEmpty((String)userAccount) || StringTools.isEmpty((String)copartnerId) || StringTools.isEmpty((String)chargeType) || StringTools.isEmpty((String)payBizNo) || StringTools.isEmpty((String)timeType) || StringTools.isEmpty((String)numValue) || StringTools.isEmpty((String)priceNo) || StringTools.isEmpty((String)cookieprefix) || StringTools.isEmpty((String)money)) {
                return this.getReturn(cookieprefix, 2, "\u53c2\u6570\u4e3a\u7a7a", chargeType, response);
            }
            String openId = StringUtils.filterInputWeak(request.getParameter("openId"));
            if ("W3".equals(chargeType) && StringTools.isEmpty((String)openId)) {
                return this.getReturn(cookieprefix, 2, "\u53c2\u6570\u4e3a\u7a7a", chargeType, response);
            }
            PayOrder porder = new PayOrder();
            porder.setIp(ip);
            if (StringTools.isEmpty((String)actNo)) {
                porder.setActNo("niuxpaycenter");
            } else {
                porder.setActNo(actNo);
            }
            if (!ChargeTypeProxy.getInstance().checkChargeType(chargeType)) {
                return this.getReturn(cookieprefix, 3, "\u652f\u4ed8\u7c7b\u578b\u9519\u8bef", chargeType, response);
            }
            userAccount = UserUtil.getUserNameByUserId(uid + "");
            if (StringTools.isEmpty((String)userAccount)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)4, (Object)"\u8be5\u8d26\u53f7\u975e\u8fc5\u96f7\u8d26\u53f7");
            }
            if (StringTools.isNotEmpty((String)bankNo) && bankNo.equals("-1")) {
                bankNo = "";
            }
            porder.setBankNo(bankNo);
            porder.setBizNo("000001075");
            porder.setChargeType(chargeType);
            porder.setPayBizNo(payBizNo);
            porder.setAdvNo(advNo);
            porder.setOrderType(new Integer(1));
            porder.setMemberStatus(Integer.valueOf(1));
            porder.setTimeType(Integer.valueOf(Integer.parseInt(timeType)));
            porder.setNumValue(Long.valueOf(Long.parseLong(numValue)));
            porder.setPayMoney(Double.valueOf(Double.parseDouble(money)));
            Price price = PriceProxy.getInstance().getPrice(priceNo);
            if (price == null) {
                return this.getReturn(cookieprefix, 5, "\u8be5\u5355\u4ef7\u7c7b\u578b\u4e0d\u5b58\u5728", chargeType, response);
            }
            double basePrice = price.getPrice();
            double payPrice = price.getPayPrice();
            double paymoney = porder.getPayMoney();
            int timetype = price.getTimeType();
            if ((double)porder.getNumValue().longValue() * payPrice != paymoney) {
                return this.getReturn(cookieprefix, 6, "\u91d1\u989d\u975e\u6cd5", chargeType, response);
            }
            porder.setOrderMoney(Double.valueOf((double)porder.getNumValue().longValue() * basePrice));
            int mytimeType = porder.getTimeType();
            if (mytimeType != 1 && mytimeType != 2 && mytimeType != 3) {
                return this.getReturn(cookieprefix, 8, "\u65f6\u95f4\u7c7b\u578b\u9519\u8bef", chargeType, response);
            }
            if (timetype != mytimeType) {
                return this.getReturn(cookieprefix, 9, "\u65f6\u95f4\u7c7b\u578b\u4e0e\u89c4\u5b9a\u7684\u4e0d\u76f8\u7b26", chargeType, response);
            }
            String priceActNo = price.getActNo();
            if (!StringTools.isEmpty((String)priceActNo) && !actNo.equals(priceActNo)) {
                return this.getReturn(cookieprefix, 18, "\u8be5\u6d3b\u52a8\u7f16\u53f7\u548c\u8be5\u5355\u4ef7\u7c7b\u578b\u4e0d\u5bf9\u5e94", chargeType, response);
            }
            if ((userAccount.indexOf("@") > 0 || userAccount.indexOf(":") > 0) && UserClient.getInstance().checkChildrenAccount(uid + "")) {
                return this.getReturn(cookieprefix, 10, "\u5b50\u8d26\u53f7\u4e0d\u80fd\u5145\u503c", chargeType, response);
            }
            porder.setUserId(Long.valueOf(uid));
            Result dataResult = this.checkData(porder, price, payPrice);
            if (dataResult != null) {
                return this.getReturn(cookieprefix, dataResult.getCode(), dataResult.getMsg(), chargeType, response);
            }
            porder.setUserName(userAccount);
            porder.setNoticeActivity(Boolean.valueOf(false));
            porder.setExt1(ext1);
            porder.setOrderId(OrderIdUtil.getOrderId(request));
            porder.setOrderTime(sdf.format(new Date()));
            porder.setOrderStatus(new Integer(1));
            ActivityFactory factory = new ActivityFactory();
            IActivityBiz actBiz = factory.getIActivityBiz(actNo);
            Result objResult = actBiz.procee(porder);
            if (objResult != null) {
                return this.getReturn(cookieprefix, objResult.getCode(), objResult.getMsg(), chargeType, response);
            }
            String paypwdType = null;
            String payPwd = null;
            if (porder.getChargeType().equals("A1")) {
                paypwdType = StringUtils.filterInputWeak(request.getParameter("paypwdtype"));
                payPwd = StringUtils.filterInputWeak(request.getParameter("payPwd"));
                if (StringTools.isEmpty((String)paypwdType) || StringTools.isEmpty((String)payPwd)) {
                    return this.getReturn(cookieprefix, 13, "\u652f\u4ed8\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", chargeType, response);
                }
            }
            FacadeFactory.INSTANCE.getPayOrderBo().insert(porder);
            String chargeRequestUrl = this.getPayUrl(porder, copartnerId, "\u725bX\u91d1\u94bb", paypwdType, payPwd, openId);
            logger.info("jinzuan pay.do addorder success uid=" + uid + ",userAccount=" + userAccount + ",order=" + porder.getOrderId() + " ,url=" + chargeRequestUrl);
            if (porder.getChargeType().equals("A1") || porder.getChargeType().equals("W3") || porder.getChargeType().equals("W2")) {
                ReturnData data = this.rechargeByAccount(porder.getChargeType(), porder.getOrderId(), chargeRequestUrl, request, response);
                if (data.getCode() == 0) {
                    if (porder.getChargeType().equals("W2")) {
                        return "{\"code\":1,\"data\":\"" + data.getMsg() + "\",\"wechaturl\":\"" + data.getAppId() + "\",\"errcode\":\"" + data.getNonceStr() + "\",\"errmsg\":\"" + data.getPackpage() + "\",\"orderid\":\"" + porder.getOrderId() + "\"}";
                    }
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put("orderId", data.getMsg());
                    result.put("appId", data.getAppId());
                    result.put("nonceStr", data.getNonceStr());
                    result.put("package", data.getPackpage());
                    result.put("paySign", data.getPaySign());
                    result.put("signType", data.getSignType());
                    result.put("timeStamp", data.getTimeStamp());
                    return JsonObjectUtil.getRtnAndDataJsonObject((int)data.getCode(), result);
                }
                return JsonObjectUtil.getRtnAndDataJsonObject((int)data.getCode(), (Object)data.getMsg());
            }
            String orderIdCookieName = cookieprefix + "_orderId";
            CookieUtil.getInstance().addCookie(orderIdCookieName, porder.getOrderId(), response, null);
            response.redirect(chargeRequestUrl);
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("orderId", porder.getOrderId());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)0, result);
        }
        catch (SQLException e) {
            logger.info("jinzuan pay.do sqlerror uid=" + uid + ",userAccount=" + userAccount + ",reason=" + e.getMessage());
            e.printStackTrace();
            return this.getReturn(cookieprefix, 12, "\u8be5\u8ba2\u5355\u5df2\u5b58\u5728", chargeType, response);
        }
        catch (Exception e) {
            logger.info("jinzuan pay.do othererror uid=" + uid + ",userAccount=" + userAccount + ",reason=" + e.getMessage());
            e.printStackTrace();
            return this.getReturn(cookieprefix, 14, "\u7f51\u7edc\u5f02\u5e38", chargeType, response);
        }
    }

    private int checkMemberStatus(long userId) throws Exception {
        String nowDay;
        MemberShip query = new MemberShip();
        query.setUserId(Long.valueOf(userId));
        MemberShip ship = (MemberShip)FacadeFactory.INSTANCE.getBaseSo().findObject((Object)query);
        if (ship == null) {
            return -1;
        }
        String experienceDate = ship.getExperienceDate();
        if (DateUtil.compareTime(experienceDate, nowDay = DateUtil.getNowDay())) {
            return 0;
        }
        return -2;
    }

    private boolean rechargeNoticeWeiXi(String orderId, String payRequestUrl) {
        String errcode = "";
        boolean isSuccess = false;
        try {
            String chargeCode = "";
            SAXReader reader = new SAXReader();
            Document doc = reader.read(new URL(payRequestUrl).openStream());
            Iterator it = doc.selectNodes("/pay/payresult").iterator();
            if (it.hasNext()) {
                Element element = (Element)it.next();
                chargeCode = element.getText();
            }
            logger.info("notice weixi orderid=" + orderId + " ,chargeCode=" + chargeCode);
            if (chargeCode.equals("00")) {
                isSuccess = true;
                errcode = "0";
            } else if (chargeCode.equals("10")) {
                Iterator it2 = doc.selectNodes("/pay/errcode").iterator();
                if (it2.hasNext()) {
                    Element element = (Element)it2.next();
                    errcode = element.getText();
                }
                logger.error("notice weixi orderid=" + orderId + " ,errcode=" + errcode);
            }
        }
        catch (Exception e) {
            logger.error("notice weixi error,orderid=" + orderId + ",reason=" + e);
        }
        return isSuccess;
    }

    private String getPayUrl(PayOrder payOrder, String copartnerid, String productName, String paypwdType, String payPwd, String openId) throws Exception {
        String payerName = payOrder.getUserName();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("version", "v1.0");
        params.put("pageCharset", "1");
        if (StringTools.isEmpty((String)payOrder.getActNo()) || "niuxpaycenter".equals(payOrder.getActNo())) {
            params.put("bgUrl", callBackUrl);
        } else {
            params.put("bgUrl", actCallBackUrl);
        }
        if (payOrder.getChargeType().equals("ES")) {
            params.put("fgUrl", "http://vip.niu.xunlei.com/zfbqcodepaysucc.html");
        } else {
            params.put("fgUrl", "http://vip.niu.xunlei.com");
        }
        params.put("bizNo", "000001075");
        params.put("orderId", payOrder.getOrderId());
        params.put("orderAmt", new Double(payOrder.getPayMoney() * 100.0).intValue() + "");
        String uid = payOrder.getUserId() + "";
        TestAccountProxy.getInstance().checkTestAccount(params, uid);
        params.put("orderTime", orderTimeDf.format(sdf.parse(payOrder.getOrderTime())));
        params.put("payType", payOrder.getChargeType());
        params.put("xunleiId", payerName);
        params.put("xlnumId", payOrder.getUserId() + "");
        params.put("productName", productName);
        params.put("productDesc", productName);
        if (StringTools.isNotEmpty((String)payOrder.getBankNo())) {
            params.put("bankNo", payOrder.getBankNo());
        }
        params.put("payerName", payerName);
        params.put("ext1", "");
        params.put("ext2", payOrder.getPayBizNo());
        if (payOrder.getChargeType().equals("A1")) {
            params.put("other1", payPwd);
        }
        if (payOrder.getChargeType().equals("W3")) {
            params.put("other1", "wechatpubpay");
            params.put("other2", openId);
            params.put("other3", APPID);
        }
        if (payOrder.getChargeType().equals("W2")) {
            params.put("other1", "wechatwebpay");
        }
        if (payOrder.getChargeType().equals("E5") && this.isBaiDuAct(payOrder.getActNo())) {
            params.put("other2", "activity");
        }
        if (payOrder.getChargeType().equals("ES")) {
            params.put("other2", "0");
        }
        String signMsg = SignUtil.sign(params, chargekey.trim());
        String requestUrl = payUrl + "?" + SignUtil.getSignatureContent(params, "utf-8") + "&signMsg=" + signMsg;
        if (payOrder.getIp() != null) {
            requestUrl = requestUrl + "&clientIp=" + payOrder.getIp();
        }
        if (payOrder.getChargeType().equals("E5") && this.isBaiDuAct(payOrder.getActNo())) {
            requestUrl = requestUrl + "&other2=activity";
        }
        if (payOrder.getChargeType().equals("A1")) {
            requestUrl = requestUrl + "&paypwdType=" + paypwdType + "&payPwd=" + payPwd;
        }
        return requestUrl;
    }

    private boolean isBaiDuAct(String actNo) {
        if (StringTools.isEmpty((String)actNo)) {
            return false;
        }
        if (baiduActNo.indexOf(",") == -1) {
            if (baiduActNo.trim().equals(actNo)) {
                return true;
            }
        } else {
            String[] actNos;
            for (String myactNo : actNos = baiduActNo.split(",")) {
                if (!myactNo.trim().equals(actNo)) continue;
                return true;
            }
        }
        return false;
    }

    private String getNoticeWeiXiUrl(PayOrder payOrder) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderId", payOrder.getOrderId());
        params.put("deliverStatus", "1");
        params.put("deliverMsg", "");
        params.put("bizNo", "000001075");
        String signMsg = SignUtil.sign(params, chargekey.trim());
        String requestUrl = noticeWeiXiUrl + "?" + SignUtil.getSignatureContent(params, "utf-8") + "&signMsg=" + signMsg;
        return requestUrl;
    }

    @CmdMapper(value={"/jinzuan/back.do"})
    public Object callBack(XLHttpRequest request, XLHttpResponse response) {
        String version = this.getChargeParameter(request, "version");
        String orderId = this.getChargeParameter(request, "orderId");
        String orderAmt = this.getChargeParameter(request, "orderAmt");
        String orderTime = this.getChargeParameter(request, "orderTime");
        String xlpayId = this.getChargeParameter(request, "xlpayId");
        String xlpayTime = this.getChargeParameter(request, "xlpayTime");
        String gameid = this.getChargeParameter(request, "ext1");
        String paybizno = this.getChargeParameter(request, "ext2");
        String payResult = this.getChargeParameter(request, "payResult");
        String signMsg = this.getChargeParameter(request, "signMsg");
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String result = "N";
        try {
            if (!"00".equals(payResult)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u652f\u4ed8\u672a\u6210\u529f");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", version);
            params.put("orderId", orderId);
            params.put("orderAmt", orderAmt);
            params.put("orderTime", orderTime);
            params.put("xlpayId", xlpayId);
            params.put("xlpayTime", xlpayTime);
            params.put("ext1", gameid);
            params.put("ext2", paybizno);
            params.put("payResult", payResult);
            params.put("signMsg", signMsg);
            logger.info("jinzuan payback.do orderid=" + orderId + ", params=" + params);
            System.out.println("back params:" + params);
            if (!SignUtil.checkSign(params, chargekey)) {
                throw new Exception("\u6570\u636e\u6821\u9a8c\u4e0d\u6b63\u786e");
            }
            if (!StringTools.isEmpty((String)orderId)) {
                PayOrder order = new PayOrder();
                order.setOrderId(orderId);
                BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
                List polist = baseSo.findObjects((Object)order, new Page());
                if (polist != null && polist.size() > 0) {
                    PayOrder porder = (PayOrder)polist.get(0);
                    if (porder.getOrderStatus() == 3) {
                        result = "Y";
                        throw new Exception("\u8be5\u5145\u503c\u8ba2\u5355\u5df2\u7ecf\u56de\u8c03\u8fc7");
                    }
                    if (BuQiProxy.getInstance().validBuQi(porder.getActNo())) {
                        FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder, true, true);
                    } else {
                        FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder, true, false);
                    }
                    if (porder.getChargeType().equals("W3")) {
                        boolean pflag = PresentProxy.getInstance().doPresent(request, porder.getUserId(), 2, 1L);
                        logger.info("jinzuan present success orderId=" + orderId + ",pflag=" + pflag);
                        boolean flag = this.noticeWeiXi(porder);
                        if (flag) {
                            result = "Y";
                        }
                    } else {
                        result = "Y";
                    }
                }
            }
            logger.info("jinzuan payback.do success orderId=" + orderId);
        }
        catch (Exception e) {
            logger.info("jinzuan back.do error orderId=" + orderId + ",reason=" + e.getMessage());
            return "<xlresult>" + result + "</xlresult>";
        }
        return "<xlresult>" + result + "</xlresult>";
    }

    @CmdMapper(value={"/jinzuan/actback.do"})
    public Object actCallBack(XLHttpRequest request, XLHttpResponse response) {
        String version = this.getChargeParameter(request, "version");
        String orderId = this.getChargeParameter(request, "orderId");
        String orderAmt = this.getChargeParameter(request, "orderAmt");
        String orderTime = this.getChargeParameter(request, "orderTime");
        String xlpayId = this.getChargeParameter(request, "xlpayId");
        String xlpayTime = this.getChargeParameter(request, "xlpayTime");
        String gameid = this.getChargeParameter(request, "ext1");
        String paybizno = this.getChargeParameter(request, "ext2");
        String payResult = this.getChargeParameter(request, "payResult");
        String signMsg = this.getChargeParameter(request, "signMsg");
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String result = "N";
        try {
            if (!"00".equals(payResult)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u652f\u4ed8\u672a\u6210\u529f");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("version", version);
            params.put("orderId", orderId);
            params.put("orderAmt", orderAmt);
            params.put("orderTime", orderTime);
            params.put("xlpayId", xlpayId);
            params.put("xlpayTime", xlpayTime);
            params.put("ext1", gameid);
            params.put("ext2", paybizno);
            params.put("payResult", payResult);
            params.put("signMsg", signMsg);
            logger.info("jinzuan payback.do orderid=" + orderId + ", params=" + params);
            System.out.println("back params:" + params);
            if (!SignUtil.checkSign(params, chargekey)) {
                throw new Exception("\u6570\u636e\u6821\u9a8c\u4e0d\u6b63\u786e");
            }
            if (!StringTools.isEmpty((String)orderId)) {
                PayOrder order = new PayOrder();
                order.setOrderId(orderId);
                BaseSo baseSo = FacadeFactory.INSTANCE.getBaseSo();
                List polist = baseSo.findObjects((Object)order, new Page());
                if (polist != null && polist.size() > 0) {
                    PayOrder porder = (PayOrder)polist.get(0);
                    if (porder.getNoticeActivity().booleanValue()) {
                        throw new Exception("\u8be5\u5145\u503c\u8ba2\u5355\u5df2\u7ecf\u56de\u8c03\u8fc7");
                    }
                    if (BuQiProxy.getInstance().validBuQi(porder.getActNo())) {
                        FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder, true, true);
                    } else {
                        FacadeFactory.INSTANCE.getPayOrderBo().addPayOrder(porder, true, false);
                    }
                    result = "Y";
                    logger.info("ActivityProxy  start..............,orderid:" + orderId);
                    ActivityProxy.getInstance().notice(porder);
                    logger.info("ActivityProxy  end.............,orderid:" + orderId);
                    JiFenShopProxy.getInstance().addJiFen(porder);
                    logger.info("JiFenShopProxy  end..............,orderid:" + orderId);
                    if (porder.getChargeType().equals("W3")) {
                        boolean pflag = PresentProxy.getInstance().doPresent(request, porder.getUserId(), 2, 1L);
                        logger.info("jinzuan present success orderId=" + orderId + ",pflag=" + pflag);
                        boolean flag = this.noticeWeiXi(porder);
                        if (flag) {
                            result = "Y";
                        }
                    } else {
                        result = "Y";
                    }
                }
            }
            logger.info("jinzuan actback.do success orderId=" + orderId + ", result=" + result);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("jinzuan actback.do error orderId=" + orderId + ",reason=" + e.getMessage());
            return "<xlresult>" + result + "</xlresult>";
        }
        return "<xlresult>" + result + "</xlresult>";
    }

    private boolean noticeWeiXi(PayOrder porder) throws Exception {
        String url = this.getNoticeWeiXiUrl(porder);
        logger.info("notice weixi orderid=" + porder.getOrderId() + " ,url=" + url);
        return this.rechargeNoticeWeiXi(porder.getOrderId(), url);
    }

    @CmdMapper(value={"/jinzuan/cancel.do"})
    public Object doCancel(XLHttpRequest request, XLHttpResponse response) {
        response.setInnerContentType(XLHttpResponse.ContentType.plain);
        String orderid = request.getParameter("orderid");
        String uid = request.getParameter("uid");
        String timestamp = request.getParameter("timestamp");
        String sign = request.getParameter("sign");
        try {
            String ip = request.getRemoteIP();
            if (!ValidIPProxy.getInstance().isValidIp(ip, 2)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)8, (Object)"\u65e0\u6548ip");
            }
            if (StringTools.isEmpty((String)orderid) || StringTools.isEmpty((String)uid) || StringTools.isEmpty((String)timestamp) || StringTools.isEmpty((String)sign)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u53c2\u6570\u4e3a\u7a7a");
            }
            long time = Long.parseLong(timestamp);
            long mytime = System.currentTimeMillis() / 1000L;
            if (mytime - time > 900L) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)4, (Object)"\u8bf7\u6c42\u8d85\u65f6");
            }
            String mysgin = Md5Encrypt.md5((String)(uid + orderid + time + cancelkey));
            if (!sign.trim().equals(mysgin)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)5, (Object)"\u7b7e\u540d\u9519\u8bef");
            }
            logger.info("jinzuan cancel.do uid=" + uid + ",orderid=" + orderid + ",timestamp=" + timestamp + ",sign=" + sign);
            FacadeFactory.INSTANCE.getPayOrderBo().cancelOrder(orderid, Long.parseLong(uid));
            logger.info("jinzuan cancel.do success uid=" + uid + ",orderid=" + orderid + ",timestamp=" + timestamp + ",sign=" + sign);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (XLRuntimeException ee) {
            ee.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject((int)2, (Object)ee.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return JsonObjectUtil.getRtnAndDataJsonObject((int)3, (Object)"\u670d\u52a1\u5668\u5f02\u5e38");
        }
    }

    @CmdMapper(value={"/jinzuan/present.do"})
    public Object doPresent(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        String timeType = request.getParameter("timeType");
        String numValue = request.getParameter("numValue");
        String orderid = request.getParameter("orderid");
        String bizNo = request.getParameter("bizNo");
        String actno = request.getParameter("actno");
        String timestamp = request.getParameter("timestamp");
        String sign = request.getParameter("sign");
        try {
            String ip = request.getRemoteIP();
            logger.info("jinzuan present.do uid=" + uid + ",ip=" + ip + ",timestamp=" + timestamp);
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            if (!ValidIPProxy.getInstance().isValidIp(ip, 2)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)8, (Object)"\u65e0\u6548ip");
            }
            logger.info("jinzuan present.do uid=" + uid + ",orderid=" + orderid + ",timeType=" + timeType + ",numValue=" + numValue + ",timestamp=" + timestamp + ",bizNo=" + bizNo + ",sign=" + sign);
            if (StringTools.isEmpty((String)uid) || StringTools.isEmpty((String)orderid) || StringTools.isEmpty((String)timeType) || StringTools.isEmpty((String)numValue) || StringTools.isEmpty((String)actno) || StringTools.isEmpty((String)timestamp) || StringTools.isEmpty((String)sign) || StringTools.isEmpty((String)bizNo)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u53c2\u6570\u9519\u8bef");
            }
            if (orderid.length() > 30) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)10, (Object)"\u8ba2\u5355\u53f7\u8fc7\u957f");
            }
            logger.info("jinzuan present.do uid=" + uid + ",orderid=" + orderid + ",timeType=" + timeType + ",numValue=" + numValue + ",timestamp=" + timestamp + ",bizNo=" + bizNo + ",sign=" + sign);
            long time = Long.parseLong(timestamp);
            long mytime = System.currentTimeMillis() / 1000L;
            if (mytime - time > 900L) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)4, (Object)"\u8bf7\u6c42\u8d85\u65f6");
            }
            PrivateKey privateKeyquery = new PrivateKey();
            privateKeyquery.setBizNo(bizNo.trim());
            PrivateKey privateKey = (PrivateKey)FacadeFactory.INSTANCE.getBaseSo().findObject((Object)privateKeyquery);
            if (privateKey == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)9, (Object)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u5b58\u5728");
            }
            String mysgin = Md5Encrypt.md5((String)(uid + orderid + timeType + numValue + bizNo + time + privateKey.getPrivateKey()));
            if (!sign.trim().equals(mysgin)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)5, (Object)"\u7b7e\u540d\u9519\u8bef");
            }
            long num = Long.parseLong(numValue);
            if (num <= 0L) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)3, (Object)"\u5f00\u901a\u5929\u6570\u5fc5\u987b\u5927\u4e8e\u96f6");
            }
            String nowtime = DateUtil.getNowTime();
            if (DateUtil.compareTime(privateKey.getStartTime(), nowtime)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)11, (Object)"\u8be5\u8d60\u9001\u63a5\u53e3\u5bc6\u94a5\u672a\u5f00\u653e\u4f7f\u7528");
            }
            if (DateUtil.compareTime(nowtime, privateKey.getEndTime())) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)12, (Object)"\u8be5\u8d60\u9001\u63a5\u53e3\u5bc6\u94a5\u5df2\u7ecf\u8fc7\u671f");
            }
            PayOrder query = new PayOrder();
            query.setOrderId(orderid);
            PayOrder myPayOrder = (PayOrder)FacadeFactory.INSTANCE.getBaseSo().findObject((Object)query);
            if (myPayOrder != null) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)8, (Object)"\u8be5\u8ba2\u5355\u53f7\u5df2\u5b58\u5728");
            }
            PayOrder porder = new PayOrder();
            porder.setBankNo("");
            porder.setBizNo(bizNo);
            porder.setChargeType("A1");
            porder.setPayBizNo("0");
            if (!StringTools.isEmpty((String)actno)) {
                porder.setActNo(actno);
            } else {
                porder.setActNo("present");
            }
            porder.setOrderType(new Integer(2));
            porder.setMemberStatus(Integer.valueOf(1));
            porder.setTimeType(Integer.valueOf(Integer.parseInt(timeType)));
            porder.setNumValue(Long.valueOf(Long.parseLong(numValue)));
            porder.setPayMoney(new Double(0.0));
            porder.setOrderMoney(new Double(0.0));
            porder.setUserId(Long.valueOf(Long.parseLong(uid)));
            porder.setNoticeActivity(Boolean.valueOf(false));
            String username = UserUtil.getUserNameByUserId(uid + "");
            porder.setUserName(StringTools.isEmpty((String)username) ? "" : username);
            porder.setOrderId(orderid);
            Date date = new Date();
            porder.setOrderTime(sdf.format(date));
            porder.setFinishTime(sdf.format(date));
            porder.setOrderStatus(new Integer(3));
            FacadeFactory.INSTANCE.getPayOrderBo().presentPayOrder(porder, privateKey.getSeqId() + "");
            logger.info("jinzuan present.do success uid=" + uid + ",orderid=" + orderid + ",timeType=" + timeType + ",numValue=" + numValue + ",timestamp=" + timestamp + ",bizNo=" + bizNo);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (XLRuntimeException e) {
            logger.info("jinzuan present.do limit  uid=" + uid + ",orderid=" + orderid + ",timeType=" + timeType + ",numValue=" + numValue + ",timestamp=" + timestamp + ",bizNo=" + bizNo + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)13, (Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("jinzuan present.do error uid=" + uid + ",orderid=" + orderid + ",timeType=" + timeType + ",numValue=" + numValue + ",timestamp=" + timestamp + ",bizNo=" + bizNo + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)6, (Object)"\u672a\u77e5\u9519\u8bef");
        }
    }
}

