/*
 * Decompiled with CFR 0.152.
 */
package com.xunlei.niux.pay.cmd;

import com.xunlei.channel.util.Md5Encrypt;
import com.xunlei.common.util.StringTools;
import com.xunlei.common.util.XLRuntimeException;
import com.xunlei.httptool.util.JsonObjectUtil;
import com.xunlei.netty.httpserver.cmd.CmdMapper;
import com.xunlei.netty.httpserver.component.XLHttpRequest;
import com.xunlei.netty.httpserver.component.XLHttpResponse;
import com.xunlei.niux.data.jinzuan.facade.FacadeFactory;
import com.xunlei.niux.data.jinzuan.vo.PayOrder;
import com.xunlei.niux.data.jinzuan.vo.PrivateKey;
import com.xunlei.niux.pay.DefaultCmd;
import com.xunlei.niux.pay.cmd.PayCmd;
import com.xunlei.niux.pay.proxy.JRedisProxy;
import com.xunlei.niux.pay.proxy.ValidIPProxy;
import com.xunlei.niux.pay.util.DateUtil;
import com.xunlei.niux.pay.util.RBundleUtil;
import com.xunlei.niux.pay.util.UserUtil;
import com.xunlei.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ExperienceCmd
extends DefaultCmd {
    private static Logger logger = Log.getLogger(PayCmd.class);
    private static final int[] experienceDays = new int[]{1, 3, 7};
    private static final String whiteIp = RBundleUtil.getString("pay", "whiteIp");
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @CmdMapper(value={"/jinzuan/experience.do"})
    public Object doExperience(XLHttpRequest request, XLHttpResponse response) {
        String uid = request.getParameter("uid");
        String numValue = request.getParameter("numValue");
        String orderid = request.getParameter("orderid");
        String bizNo = request.getParameter("bizNo");
        String actno = request.getParameter("actno");
        String timestamp = request.getParameter("timestamp");
        String ip = request.getParameter("ip");
        String sign = request.getParameter("sign");
        try {
            String serverip = request.getRemoteIP();
            response.setInnerContentType(XLHttpResponse.ContentType.plain);
            if (!ValidIPProxy.getInstance().isValidIp(serverip, 2)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)8, (Object)"\u65e0\u6548ip");
            }
            logger.info("jinzuan experience.do uid=" + uid + ",orderid=" + orderid + ",numValue=" + numValue + ",timestamp=" + timestamp + ",bizNo=" + bizNo + ",sign=" + sign);
            if (StringTools.isEmpty((String)uid) || StringTools.isEmpty((String)orderid) || StringTools.isEmpty((String)numValue) || StringTools.isEmpty((String)actno) || StringTools.isEmpty((String)ip) || StringTools.isEmpty((String)timestamp) || StringTools.isEmpty((String)sign) || StringTools.isEmpty((String)bizNo)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)1, (Object)"\u53c2\u6570\u9519\u8bef");
            }
            if (orderid.length() > 30) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)10, (Object)"\u8ba2\u5355\u53f7\u8fc7\u957f");
            }
            logger.info("jinzuan experience.do uid=" + uid + ",orderid=" + orderid + ",ip=" + ip + ",numValue=" + numValue + ",timestamp=" + timestamp + ",bizNo=" + bizNo + ",sign=" + sign);
            long time = Long.parseLong(timestamp);
            long mytime = System.currentTimeMillis() / 1000L;
            if (mytime - time > 900L) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)4, (Object)"\u8bf7\u6c42\u8d85\u65f6");
            }
            PrivateKey privateKeyquery = new PrivateKey();
            privateKeyquery.setBizNo(bizNo.trim());
            PrivateKey privateKey = (PrivateKey)FacadeFactory.INSTANCE.getBaseSo().findObject((Object)privateKeyquery);
            if (privateKey == null) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)9, (Object)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u5b58\u5728");
            }
            String mysgin = Md5Encrypt.md5((String)(uid + orderid + actno + numValue + bizNo + ip + time + privateKey.getPrivateKey()));
            if (!sign.trim().equals(mysgin)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)5, (Object)"\u7b7e\u540d\u9519\u8bef");
            }
            long num = Long.parseLong(numValue);
            if (num <= 0L) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)3, (Object)"\u5f00\u901a\u5929\u6570\u5fc5\u987b\u5927\u4e8e\u96f6");
            }
            boolean flag = false;
            for (int day : experienceDays) {
                if ((long)day != num) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)2, (Object)"\u76ee\u524d\u53ea\u80fd\u5f00\u901a1\u30013\u30017\u5929\u4f53\u9a8c\u4f1a\u5458");
            }
            String nowtime = DateUtil.getNowTime();
            if (DateUtil.compareTime(privateKey.getStartTime(), nowtime)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)11, (Object)"\u8be5\u4f53\u9a8c\u4f1a\u5458\u5f00\u901a\u63a5\u53e3\u5bc6\u94a5\u672a\u5f00\u653e\u4f7f\u7528");
            }
            if (DateUtil.compareTime(nowtime, privateKey.getEndTime())) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)12, (Object)"\u8be5\u4f53\u9a8c\u4f1a\u5458\u5f00\u901a\u63a5\u53e3\u5bc6\u94a5\u5df2\u7ecf\u8fc7\u671f");
            }
            if (!this.checkUserIp(ip)) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)14, (Object)"\u8be5ip\u5728\u4e00\u5929\u4e4b\u5185\u5f00\u901a\u4f53\u9a8c\u4f1a\u5458\u6570\u8f83\u591a");
            }
            PayOrder query = new PayOrder();
            query.setOrderId(orderid);
            PayOrder myPayOrder = (PayOrder)FacadeFactory.INSTANCE.getBaseSo().findObject((Object)query);
            if (myPayOrder != null) {
                return JsonObjectUtil.getRtnAndDataJsonObject((int)8, (Object)"\u8be5\u8ba2\u5355\u53f7\u5df2\u5b58\u5728");
            }
            PayOrder porder = new PayOrder();
            porder.setBankNo("");
            porder.setBizNo(bizNo);
            porder.setChargeType("A1");
            porder.setPayBizNo("0");
            if (!StringTools.isEmpty((String)actno)) {
                porder.setActNo(actno);
            } else {
                porder.setActNo("present");
            }
            porder.setOrderType(Integer.valueOf(2));
            porder.setMemberStatus(Integer.valueOf(2));
            porder.setTimeType(Integer.valueOf(1));
            porder.setNumValue(Long.valueOf(Long.parseLong(numValue)));
            porder.setPayMoney(new Double(0.0));
            porder.setOrderMoney(new Double(0.0));
            porder.setUserId(Long.valueOf(Long.parseLong(uid)));
            porder.setNoticeActivity(Boolean.valueOf(false));
            String username = UserUtil.getUserNameByUserId(uid + "");
            porder.setUserName(StringTools.isEmpty((String)username) ? "" : username);
            porder.setOrderId(orderid);
            Date date = new Date();
            porder.setOrderTime(sdf.format(date));
            porder.setFinishTime(sdf.format(date));
            porder.setOrderStatus(new Integer(3));
            FacadeFactory.INSTANCE.getPayOrderBo().experiencePayOrder(porder, privateKey.getSeqId() + "");
            logger.info("jinzuan experience.do success uid=" + uid + ",orderid=" + orderid + ",ip=" + ip + ",numValue=" + numValue + ",timestamp=" + timestamp + ",bizNo=" + bizNo);
            return JsonObjectUtil.getOnlyOkJson();
        }
        catch (XLRuntimeException e) {
            logger.info("jinzuan experience.do limit  uid=" + uid + ",orderid=" + orderid + ",ip=" + ip + ",numValue=" + numValue + ",timestamp=" + timestamp + ",bizNo=" + bizNo + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)13, (Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("jinzuan experience.do error uid=" + uid + ",orderid=" + orderid + ",ip=" + ip + ",numValue=" + numValue + ",timestamp=" + timestamp + ",bizNo=" + bizNo + ",reason=" + e.getMessage());
            return JsonObjectUtil.getRtnAndDataJsonObject((int)6, (Object)"\u672a\u77e5\u9519\u8bef");
        }
    }

    private boolean checkUserIp(String ip) {
        String count = JRedisProxy.getInstance().get(ip);
        try {
            if (this.isWhiteIp(ip)) {
                return true;
            }
            long allcount = 0L;
            if (count == null) {
                JRedisProxy.getInstance().set(ip, "1", 86400);
            } else {
                allcount = Integer.parseInt(count);
                if (allcount >= 50L) {
                    return false;
                }
                JRedisProxy.getInstance().set(ip, allcount + 1L + "", 86400);
            }
        }
        catch (Exception e) {
            logger.error("checkUserIp ip:" + ip, (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean isWhiteIp(String ip) {
        String[] ips;
        if (StringTools.isEmpty((String)whiteIp)) {
            return false;
        }
        if (whiteIp.indexOf(",") == -1) {
            return ip.trim().equals(whiteIp.trim());
        }
        for (String myip : ips = whiteIp.split(",")) {
            if (!myip.trim().equals(ip.trim())) continue;
            return true;
        }
        return false;
    }
}

